/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.jetbrains.packagesearch.intellij.plugin.gson.DeserializationFallback;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class EnumWithDeserializationFallbackAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (gson == null || type == null) {
            return null;
        }
        Class rawType = type.getRawType();
        if (!rawType.isEnum()) {
            return null;
        }
        return new EnumTypeAdapter(rawType);
    }

    private static final class EnumTypeAdapter<TT extends Enum<TT>>
    extends TypeAdapter<TT> {
        private TT defaultValue = null;
        private final Map<String, TT> nameToConstant = new HashMap<String, TT>();
        private final Map<TT, String> constantToName = new HashMap<TT, String>();

        EnumTypeAdapter(Class<TT> classOfT) {
            for (Enum constant : (Enum[])classOfT.getEnumConstants()) {
                SerializedName serializedName;
                String name = constant.name();
                try {
                    serializedName = classOfT.getField(name).getAnnotation(SerializedName.class);
                }
                catch (NoSuchFieldException e) {
                    serializedName = null;
                }
                if (serializedName != null) {
                    name = serializedName.value();
                    for (String alternate : serializedName.alternate()) {
                        this.nameToConstant.put(alternate, constant);
                    }
                }
                if (this.defaultValue == null) {
                    DeserializationFallback fallbackAnnotation;
                    try {
                        fallbackAnnotation = classOfT.getField(name).getAnnotation(DeserializationFallback.class);
                    }
                    catch (NoSuchFieldException e) {
                        fallbackAnnotation = null;
                    }
                    if (fallbackAnnotation != null) {
                        this.defaultValue = constant;
                    }
                }
                this.nameToConstant.put(name, constant);
                this.constantToName.put(constant, name);
            }
        }

        public TT read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Enum value = (Enum)this.nameToConstant.get(in.nextString());
            if (value == null) {
                value = this.defaultValue;
            }
            return (TT)value;
        }

        public void write(JsonWriter out, TT value) throws IOException {
            out.value(value == null ? null : this.constantToName.get(value));
        }
    }
}

