/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.security;

import java.security.Permission;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.security.ExitCallHook;
import org.assertj.swing.security.ExitException;
import org.assertj.swing.security.StackTraces;

public class NoExitSecurityManager
extends SecurityManager {
    private static final ExitCallHook NULL_HOOK = new ExitCallHook(){

        @Override
        public void exitCalled(int status) {
        }
    };
    private final ExitCallHook hook;
    private final StackTraces stackTraces;

    public NoExitSecurityManager() {
        this(NULL_HOOK);
    }

    public NoExitSecurityManager(ExitCallHook hook) {
        this(hook, new StackTraces());
    }

    @VisibleForTesting
    NoExitSecurityManager(ExitCallHook hook, StackTraces stackTraces) {
        if (hook == null) {
            throw new NullPointerException(Strings.concat("The given ", ExitCallHook.class.getSimpleName(), " should not be null"));
        }
        this.hook = hook;
        this.stackTraces = stackTraces;
    }

    @Override
    public void checkPermission(Permission permission, Object context2) {
    }

    @Override
    public void checkPermission(Permission permission) {
    }

    @Override
    public void checkExit(int status) {
        if (this.exitInvoked()) {
            this.hook.exitCalled(status);
            throw new ExitException(Strings.concat("Application tried to terminate current JVM with status ", status));
        }
    }

    private boolean exitInvoked() {
        for (StackTraceElement e : this.stackTraces.stackTraceInCurrentThread()) {
            if (!this.exitInvoked(e)) continue;
            return true;
        }
        return false;
    }

    private boolean exitInvoked(StackTraceElement e) {
        if (!Runtime.class.getName().equals(e.getClassName())) {
            return false;
        }
        String method = e.getMethodName();
        return "exit".equals(method) || "halt".equals(method);
    }
}

