/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js.ast;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsDocComment;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsMultiLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.LocalAlias;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.serialization.js.ast.JsAstProtoBuf;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H&J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0004J\u0010\u0010!\u001a\u00020%2\u0006\u0010#\u001a\u00020&H\u0004J\u0010\u0010!\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0004J\u0010\u0010!\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0004J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u0005H\u0004J\u0010\u0010-\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0004J\u0010\u0010-\u001a\u0002022\u0006\u00103\u001a\u000204H\u0004J\u0010\u0010-\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\nH\u0004J\u0010\u0010-\u001a\u0002062\u0006\u00107\u001a\u000208H\u0004J\u0010\u0010-\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0004J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0004J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0004J\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0004J\u0010\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0004JG\u0010N\u001a\u00020O2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020O0Q2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u00020O0Q2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020O0UH\u0082\bR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u001c\u0010\u0019\u001a\n \u0014*\u0004\u0018\u00010\u001a0\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006V"}, d2={"Lorg/jetbrains/kotlin/serialization/js/ast/JsAstSerializerBase;", "", "()V", "fileStack", "Ljava/util/Deque;", "", "getFileStack", "()Ljava/util/Deque;", "importedNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getImportedNames", "()Ljava/util/Set;", "nameMap", "", "", "getNameMap", "()Ljava/util/Map;", "nameTableBuilder", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$NameTable$Builder;", "kotlin.jvm.PlatformType", "getNameTableBuilder", "()Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$NameTable$Builder;", "stringMap", "getStringMap", "stringTableBuilder", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$StringTable$Builder;", "getStringTableBuilder", "()Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$StringTable$Builder;", "extractLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "map", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$BinaryOperation$Type;", "op", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperator;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$UnaryOperation$Type;", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperator;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$SideEffects;", "sideEffects", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SideEffectKind;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$SpecialFunction;", "specialFunction", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SpecialFunction;", "serialize", "string", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Expression;", "expression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$JsImportedModule;", "module", "Lorg/jetbrains/kotlin/js/backend/ast/JsImportedModule;", "name", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Statement;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$LocalAlias;", "alias", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/LocalAlias;", "serializeBlock", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$CompositeBlock;", "block", "Lorg/jetbrains/kotlin/js/backend/ast/JsCompositeBlock;", "serializeParameter", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Parameter;", "parameter", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "serializeUnary", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$UnaryOperation;", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperation;", "postfix", "", "serializeVars", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Vars;", "vars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "withLocation", "", "fileConsumer", "Lkotlin/Function1;", "locationConsumer", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Location;", "inner", "Lkotlin/Function0;", "js.serializer"})
public abstract class JsAstSerializerBase {
    private final JsAstProtoBuf.NameTable.Builder nameTableBuilder = JsAstProtoBuf.NameTable.newBuilder();
    private final JsAstProtoBuf.StringTable.Builder stringTableBuilder = JsAstProtoBuf.StringTable.newBuilder();
    @NotNull
    private final Map<JsName, Integer> nameMap = new LinkedHashMap();
    @NotNull
    private final Map<String, Integer> stringMap = new LinkedHashMap();
    @NotNull
    private final Deque<String> fileStack = new ArrayDeque();
    @NotNull
    private final Set<JsName> importedNames = new LinkedHashSet();

    protected final JsAstProtoBuf.NameTable.Builder getNameTableBuilder() {
        return this.nameTableBuilder;
    }

    protected final JsAstProtoBuf.StringTable.Builder getStringTableBuilder() {
        return this.stringTableBuilder;
    }

    @NotNull
    protected final Map<JsName, Integer> getNameMap() {
        return this.nameMap;
    }

    @NotNull
    protected final Map<String, Integer> getStringMap() {
        return this.stringMap;
    }

    @NotNull
    protected final Deque<String> getFileStack() {
        return this.fileStack;
    }

    @NotNull
    protected final Set<JsName> getImportedNames() {
        return this.importedNames;
    }

    @NotNull
    protected final JsAstProtoBuf.Statement serialize(@NotNull JsStatement statement2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        JsVisitor visitor2 = new JsVisitor(this){
            private final JsAstProtoBuf.Statement.Builder builder;
            final /* synthetic */ JsAstSerializerBase this$0;
            {
                this.this$0 = $receiver;
                this.builder = JsAstProtoBuf.Statement.newBuilder();
            }

            public final JsAstProtoBuf.Statement.Builder getBuilder() {
                return this.builder;
            }

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Return.Builder returnBuilder = JsAstProtoBuf.Return.newBuilder();
                JsExpression jsExpression = x.getExpression();
                if (jsExpression != null) {
                    JsExpression jsExpression2 = jsExpression;
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    JsExpression it = jsExpression2;
                    boolean bl = false;
                    returnBuilder.setValue(jsAstSerializerBase.serialize(it));
                }
                this.builder.setReturnStatement(returnBuilder.build());
            }

            public void visitThrow(@NotNull JsThrow x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Throw.Builder throwBuilder = JsAstProtoBuf.Throw.newBuilder();
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
                throwBuilder.setException(this.this$0.serialize(jsExpression));
                this.builder.setThrowStatement(throwBuilder.build());
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Break.Builder breakBuilder = JsAstProtoBuf.Break.newBuilder();
                JsNameRef jsNameRef = x.getLabel();
                if (jsNameRef != null) {
                    JsNameRef jsNameRef2 = jsNameRef;
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    JsNameRef it = jsNameRef2;
                    boolean bl = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNull((Object)jsName);
                    breakBuilder.setLabelId(jsAstSerializerBase.serialize(jsName));
                }
                this.builder.setBreakStatement(breakBuilder.build());
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Continue.Builder continueBuilder = JsAstProtoBuf.Continue.newBuilder();
                JsNameRef jsNameRef = x.getLabel();
                if (jsNameRef != null) {
                    JsNameRef jsNameRef2 = jsNameRef;
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    JsNameRef it = jsNameRef2;
                    boolean bl = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNull((Object)jsName);
                    continueBuilder.setLabelId(jsAstSerializerBase.serialize(jsName));
                }
                this.builder.setContinueStatement(continueBuilder.build());
            }

            public void visitDebugger(@NotNull JsDebugger x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setDebugger(JsAstProtoBuf.Debugger.newBuilder().build());
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ExpressionStatement.Builder statementBuilder = JsAstProtoBuf.ExpressionStatement.newBuilder();
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
                statementBuilder.setExpression(this.this$0.serialize(jsExpression));
                String tag = MetadataProperties.getExportedTag(x);
                if (tag != null) {
                    statementBuilder.setExportedTagId(this.this$0.serialize(tag));
                }
                this.builder.setExpression(statementBuilder.build());
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setVars(this.this$0.serializeVars(x));
            }

            public void visitBlock(@NotNull JsBlock x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (x instanceof JsCompositeBlock) {
                    this.builder.setCompositeBlock(this.this$0.serializeBlock((JsCompositeBlock)x));
                } else {
                    JsAstProtoBuf.Block.Builder blockBuilder = JsAstProtoBuf.Block.newBuilder();
                    for (JsStatement part : x.getStatements()) {
                        Intrinsics.checkNotNullExpressionValue((Object)part, (String)"part");
                        blockBuilder.addStatement(this.this$0.serialize(part));
                    }
                    this.builder.setBlock(blockBuilder.build());
                }
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Label.Builder labelBuilder = JsAstProtoBuf.Label.newBuilder();
                JsName jsName = x.getName();
                Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"x.name");
                labelBuilder.setNameId(this.this$0.serialize(jsName));
                JsStatement jsStatement = x.getStatement();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"x.statement");
                labelBuilder.setInnerStatement(this.this$0.serialize(jsStatement));
                this.builder.setLabel(labelBuilder.build());
            }

            public void visitIf(@NotNull JsIf x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.If.Builder ifBuilder = JsAstProtoBuf.If.newBuilder();
                JsExpression jsExpression = x.getIfExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.ifExpression");
                ifBuilder.setCondition(this.this$0.serialize(jsExpression));
                JsStatement jsStatement = x.getThenStatement();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"x.thenStatement");
                ifBuilder.setThenStatement(this.this$0.serialize(jsStatement));
                JsStatement jsStatement2 = x.getElseStatement();
                if (jsStatement2 != null) {
                    JsStatement jsStatement3 = jsStatement2;
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    JsStatement it = jsStatement3;
                    boolean bl = false;
                    ifBuilder.setElseStatement(jsAstSerializerBase.serialize(it));
                }
                this.builder.setIfStatement(ifBuilder.build());
            }

            /*
             * WARNING - void declaration
             */
            public void visit(@NotNull JsSwitch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Switch.Builder switchBuilder = JsAstProtoBuf.Switch.newBuilder();
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
                switchBuilder.setExpression(this.this$0.serialize(jsExpression));
                for (JsSwitchMember jsSwitchMember : x.getCases()) {
                    void this_$iv;
                    JsAstProtoBuf.SwitchEntry.Builder entryBuilder = JsAstProtoBuf.SwitchEntry.newBuilder();
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    Intrinsics.checkNotNullExpressionValue((Object)jsSwitchMember, (String)"case");
                    JsNode node$iv = jsSwitchMember;
                    boolean $i$f$withLocation = false;
                    JsLocation location$iv = this_$iv.extractLocation(node$iv);
                    boolean fileChanged$iv = false;
                    if (location$iv != null) {
                        JsAstProtoBuf.Location it;
                        String newFile$iv;
                        String lastFile$iv = this_$iv.getFileStack().peek();
                        boolean bl = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
                        if (fileChanged$iv) {
                            int it2 = this_$iv.serialize(newFile$iv);
                            boolean bl2 = false;
                            entryBuilder.setFileId(it2);
                            this_$iv.getFileStack().push(location$iv.getFile());
                        }
                        JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
                        locationBuilder$iv.setStartLine(location$iv.getStartLine());
                        locationBuilder$iv.setStartChar(location$iv.getStartChar());
                        Intrinsics.checkNotNullExpressionValue((Object)locationBuilder$iv.build(), (String)"locationBuilder.build()");
                        boolean bl3 = false;
                        entryBuilder.setLocation(it);
                    }
                    boolean bl = false;
                    if (fileChanged$iv) {
                        this_$iv.getFileStack().pop();
                    }
                    if (jsSwitchMember instanceof JsCase) {
                        JsExpression jsExpression2 = ((JsCase)jsSwitchMember).getCaseExpression();
                        Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"case.caseExpression");
                        entryBuilder.setLabel(this.this$0.serialize(jsExpression2));
                    }
                    for (JsStatement part : jsSwitchMember.getStatements()) {
                        Intrinsics.checkNotNullExpressionValue((Object)part, (String)"part");
                        entryBuilder.addStatement(this.this$0.serialize(part));
                    }
                    switchBuilder.addEntry(entryBuilder);
                }
                this.builder.setSwitchStatement(switchBuilder.build());
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.While.Builder whileBuilder = JsAstProtoBuf.While.newBuilder();
                JsExpression jsExpression = x.getCondition();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.condition");
                whileBuilder.setCondition(this.this$0.serialize(jsExpression));
                JsStatement jsStatement = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"x.body");
                whileBuilder.setBody(this.this$0.serialize(jsStatement));
                this.builder.setWhileStatement(whileBuilder.build());
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.DoWhile.Builder doWhileBuilder = JsAstProtoBuf.DoWhile.newBuilder();
                JsExpression jsExpression = x.getCondition();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.condition");
                doWhileBuilder.setCondition(this.this$0.serialize(jsExpression));
                JsStatement jsStatement = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"x.body");
                doWhileBuilder.setBody(this.this$0.serialize(jsStatement));
                this.builder.setDoWhileStatement(doWhileBuilder.build());
            }

            public void visitFor(@NotNull JsFor x) {
                JsStatement jsStatement;
                JsExpression it;
                JsAstSerializerBase jsAstSerializerBase;
                JsExpression jsExpression;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.For.Builder forBuilder = JsAstProtoBuf.For.newBuilder();
                if (x.getInitVars() != null) {
                    JsVars jsVars = x.getInitVars();
                    Intrinsics.checkNotNullExpressionValue((Object)jsVars, (String)"x.initVars");
                    forBuilder.setVariables(this.this$0.serialize(jsVars));
                } else if (x.getInitExpression() != null) {
                    JsExpression jsExpression2 = x.getInitExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"x.initExpression");
                    forBuilder.setExpression(this.this$0.serialize(jsExpression2));
                } else {
                    forBuilder.setEmpty(JsAstProtoBuf.EmptyInit.newBuilder().build());
                }
                JsExpression jsExpression3 = x.getCondition();
                if (jsExpression3 != null) {
                    jsExpression = jsExpression3;
                    jsAstSerializerBase = this.this$0;
                    it = jsExpression;
                    boolean bl = false;
                    forBuilder.setCondition(jsAstSerializerBase.serialize(it));
                }
                JsExpression jsExpression4 = x.getIncrementExpression();
                if (jsExpression4 != null) {
                    jsExpression = jsExpression4;
                    jsAstSerializerBase = this.this$0;
                    it = jsExpression;
                    boolean bl = false;
                    forBuilder.setIncrement(jsAstSerializerBase.serialize(it));
                }
                if ((jsStatement = x.getBody()) == null) {
                    jsStatement = JsEmpty.INSTANCE;
                }
                forBuilder.setBody(this.this$0.serialize(jsStatement));
                this.builder.setForStatement(forBuilder.build());
            }

            public void visitForIn(@NotNull JsForIn x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ForIn.Builder forInBuilder = JsAstProtoBuf.ForIn.newBuilder();
                if (x.getIterVarName() != null) {
                    JsName jsName = x.getIterVarName();
                    Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"x.iterVarName");
                    forInBuilder.setNameId(this.this$0.serialize(jsName));
                } else if (x.getIterExpression() != null) {
                    JsExpression jsExpression = x.getIterExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.iterExpression");
                    forInBuilder.setExpression(this.this$0.serialize(jsExpression));
                }
                JsExpression jsExpression = x.getObjectExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.objectExpression");
                forInBuilder.setIterable(this.this$0.serialize(jsExpression));
                JsStatement jsStatement = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"x.body");
                forInBuilder.setBody(this.this$0.serialize(jsStatement));
                this.builder.setForInStatement(forInBuilder.build());
            }

            public void visitTry(@NotNull JsTry x) {
                JsAstSerializerBase jsAstSerializerBase;
                SourceInfoAwareJsNode sourceInfoAwareJsNode;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Try.Builder tryBuilder = JsAstProtoBuf.Try.newBuilder();
                JsBlock jsBlock = x.getTryBlock();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"x.tryBlock");
                tryBuilder.setTryBlock(this.this$0.serialize(jsBlock));
                List<JsCatch> list2 = x.getCatches();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"x.catches");
                JsCatch jsCatch = (JsCatch)CollectionsKt.firstOrNull(list2);
                if (jsCatch != null) {
                    sourceInfoAwareJsNode = jsCatch;
                    jsAstSerializerBase = this.this$0;
                    JsCatch c = sourceInfoAwareJsNode;
                    boolean bl = false;
                    JsAstProtoBuf.Catch.Builder catchBuilder = JsAstProtoBuf.Catch.newBuilder();
                    JsParameter jsParameter = c.getParameter();
                    Intrinsics.checkNotNullExpressionValue((Object)jsParameter, (String)"c.parameter");
                    catchBuilder.setParameter(jsAstSerializerBase.serializeParameter(jsParameter));
                    JsBlock jsBlock2 = c.getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsBlock2, (String)"c.body");
                    catchBuilder.setBody(jsAstSerializerBase.serialize(jsBlock2));
                    tryBuilder.setCatchBlock(catchBuilder.build());
                }
                JsBlock jsBlock3 = x.getFinallyBlock();
                if (jsBlock3 != null) {
                    sourceInfoAwareJsNode = jsBlock3;
                    jsAstSerializerBase = this.this$0;
                    SourceInfoAwareJsNode it = sourceInfoAwareJsNode;
                    boolean bl = false;
                    tryBuilder.setFinallyBlock(jsAstSerializerBase.serialize((JsStatement)((Object)it)));
                }
                this.builder.setTryStatement(tryBuilder.build());
            }

            public void visitEmpty(@NotNull JsEmpty x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setEmpty(JsAstProtoBuf.Empty.newBuilder().build());
            }

            public void visitSingleLineComment(@NotNull JsSingleLineComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                this.builder.setSingleLineComment(JsAstProtoBuf.SingleLineComment.newBuilder().setMessage(comment.getText()).build());
            }

            public void visitMultiLineComment(@NotNull JsMultiLineComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                this.builder.setMultiLineComment(JsAstProtoBuf.MultiLineComment.newBuilder().setMessage(comment.getText()).build());
            }
        };
        JsAstSerializerBase this_$iv = this;
        boolean $i$f$withLocation = false;
        JsLocation location$iv = this_$iv.extractLocation(statement2);
        boolean fileChanged$iv = false;
        if (location$iv != null) {
            String newFile$iv;
            String lastFile$iv = this_$iv.getFileStack().peek();
            boolean bl = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
            if (fileChanged$iv) {
                int it = this_$iv.serialize(newFile$iv);
                boolean bl2 = false;
                visitor2.getBuilder().setFileId(it);
                this_$iv.getFileStack().push(location$iv.getFile());
            }
            JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
            locationBuilder$iv.setStartLine(location$iv.getStartLine());
            locationBuilder$iv.setStartChar(location$iv.getStartChar());
            JsAstProtoBuf.Location location = locationBuilder$iv.build();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"locationBuilder.build()");
            JsAstProtoBuf.Location it = location;
            boolean bl3 = false;
            visitor2.getBuilder().setLocation(it);
        }
        boolean bl = false;
        statement2.accept(visitor2);
        if (fileChanged$iv) {
            this_$iv.getFileStack().pop();
        }
        if (statement2 instanceof HasMetadata && MetadataProperties.getSynthetic((HasMetadata)((Object)statement2))) {
            visitor2.getBuilder().setSynthetic(true);
        }
        if (visitor2.getBuilder().getStatementCase() == JsAstProtoBuf.Statement.StatementCase.STATEMENT_NOT_SET) {
            throw new IllegalStateException(("Unknown statement type: " + Reflection.getOrCreateKotlinClass(statement2.getClass()).getQualifiedName()).toString());
        }
        JsAstProtoBuf.Statement statement3 = visitor2.getBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)statement3, (String)"visitor.builder.build()");
        return statement3;
    }

    @NotNull
    protected final JsAstProtoBuf.Expression serialize(@NotNull JsExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        JsVisitor visitor2 = new JsVisitor(this){
            private final JsAstProtoBuf.Expression.Builder builder;
            final /* synthetic */ JsAstSerializerBase this$0;
            {
                this.this$0 = $receiver;
                this.builder = JsAstProtoBuf.Expression.newBuilder();
            }

            public final JsAstProtoBuf.Expression.Builder getBuilder() {
                return this.builder;
            }

            public void visitThis(@NotNull JsThisRef x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setThisLiteral(JsAstProtoBuf.ThisLiteral.newBuilder().build());
            }

            public void visitNull(@NotNull JsNullLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setNullLiteral(JsAstProtoBuf.NullLiteral.newBuilder().build());
            }

            public void visitBoolean(@NotNull JsBooleanLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (x.getValue()) {
                    this.builder.setTrueLiteral(JsAstProtoBuf.TrueLiteral.newBuilder().build());
                } else {
                    this.builder.setFalseLiteral(JsAstProtoBuf.FalseLiteral.newBuilder().build());
                }
            }

            public void visitString(@NotNull JsStringLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                String string2 = x.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"x.value");
                this.builder.setStringLiteral(this.this$0.serialize(string2));
            }

            public void visitRegExp(@NotNull JsRegExp x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.RegExpLiteral.Builder regExpBuilder = JsAstProtoBuf.RegExpLiteral.newBuilder();
                String string2 = x.getPattern();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"x.pattern");
                regExpBuilder.setPatternStringId(this.this$0.serialize(string2));
                String string3 = x.getFlags();
                if (string3 != null) {
                    String string4 = string3;
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    String it = string4;
                    boolean bl = false;
                    regExpBuilder.setFlagsStringId(jsAstSerializerBase.serialize(it));
                }
                this.builder.setRegExpLiteral(regExpBuilder.build());
            }

            public void visitInt(@NotNull JsIntLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setIntLiteral(x.value);
            }

            public void visitDouble(@NotNull JsDoubleLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setDoubleLiteral(x.value);
            }

            /*
             * WARNING - void declaration
             */
            public void visitArray(@NotNull JsArrayLiteral x) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ArrayLiteral.Builder arrayBuilder = JsAstProtoBuf.ArrayLiteral.newBuilder();
                List<JsExpression> list2 = x.getExpressions();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"x.expressions");
                Iterable iterable = list2;
                JsAstSerializerBase jsAstSerializerBase = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsExpression it = (JsExpression)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    arrayBuilder.addElement(jsAstSerializerBase.serialize(it));
                }
                this.builder.setArrayLiteral(arrayBuilder.build());
            }

            public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ObjectLiteral.Builder objectBuilder = JsAstProtoBuf.ObjectLiteral.newBuilder();
                for (JsPropertyInitializer initializer : x.getPropertyInitializers()) {
                    JsAstProtoBuf.ObjectLiteralEntry.Builder entryBuilder = JsAstProtoBuf.ObjectLiteralEntry.newBuilder();
                    JsExpression jsExpression = initializer.getLabelExpr();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"initializer.labelExpr");
                    entryBuilder.setKey(this.this$0.serialize(jsExpression));
                    JsExpression jsExpression2 = initializer.getValueExpr();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"initializer.valueExpr");
                    entryBuilder.setValue(this.this$0.serialize(jsExpression2));
                    objectBuilder.addEntry(entryBuilder);
                }
                objectBuilder.setMultiline(x.isMultiline());
                this.builder.setObjectLiteral(objectBuilder.build());
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(@NotNull JsFunction x) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Function.Builder functionBuilder = JsAstProtoBuf.Function.newBuilder();
                List<JsParameter> list2 = x.getParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"x.parameters");
                Iterable iterable = list2;
                Object object = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsParameter it = (JsParameter)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    functionBuilder.addParameter(((JsAstSerializerBase)object).serializeParameter(it));
                }
                JsName jsName = x.getName();
                if (jsName != null) {
                    object = jsName;
                    JsAstSerializerBase jsAstSerializerBase = this.this$0;
                    Object it = object;
                    boolean bl = false;
                    functionBuilder.setNameId(jsAstSerializerBase.serialize((JsName)it));
                }
                JsBlock jsBlock = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"x.body");
                functionBuilder.setBody(this.this$0.serialize(jsBlock));
                if (MetadataProperties.isLocal(x)) {
                    functionBuilder.setLocal(true);
                }
                this.builder.setFunction(functionBuilder.build());
            }

            public void visitDocComment(@NotNull JsDocComment comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                JsAstProtoBuf.DocComment.Builder commentBuilder = JsAstProtoBuf.DocComment.newBuilder();
                Map<String, Object> map = comment.getTags();
                Intrinsics.checkNotNullExpressionValue(map, (String)"comment.tags");
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String name = entry.getKey();
                    Object value2 = entry.getValue();
                    JsAstProtoBuf.DocCommentTag.Builder tagBuilder = JsAstProtoBuf.DocCommentTag.newBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    tagBuilder.setNameId(this.this$0.serialize(name));
                    Object object = value2;
                    if (object instanceof JsNameRef) {
                        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                        tagBuilder.setExpression(this.this$0.serialize((JsExpression)value2));
                    } else if (object instanceof String) {
                        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                        tagBuilder.setValueStringId(this.this$0.serialize((String)value2));
                    }
                    commentBuilder.addTag(tagBuilder);
                }
                this.builder.setDocComment(commentBuilder.build());
            }

            public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.BinaryOperation.Builder binaryBuilder = JsAstProtoBuf.BinaryOperation.newBuilder();
                JsExpression jsExpression = x.getArg1();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.arg1");
                binaryBuilder.setLeft(this.this$0.serialize(jsExpression));
                JsExpression jsExpression2 = x.getArg2();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"x.arg2");
                binaryBuilder.setRight(this.this$0.serialize(jsExpression2));
                JsBinaryOperator jsBinaryOperator = x.getOperator();
                Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperator, (String)"x.operator");
                binaryBuilder.setType(this.this$0.map(jsBinaryOperator));
                this.builder.setBinary(binaryBuilder.build());
            }

            public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setUnary(this.this$0.serializeUnary(x, false));
            }

            public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.builder.setUnary(this.this$0.serializeUnary(x, true));
            }

            public void visitConditional(@NotNull JsConditional x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Conditional.Builder conditionalBuilder = JsAstProtoBuf.Conditional.newBuilder();
                JsExpression jsExpression = x.getTestExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.testExpression");
                conditionalBuilder.setTestExpression(this.this$0.serialize(jsExpression));
                JsExpression jsExpression2 = x.getThenExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"x.thenExpression");
                conditionalBuilder.setThenExpression(this.this$0.serialize(jsExpression2));
                JsExpression jsExpression3 = x.getElseExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"x.elseExpression");
                conditionalBuilder.setElseExpression(this.this$0.serialize(jsExpression3));
                this.builder.setConditional(conditionalBuilder.build());
            }

            public void visitArrayAccess(@NotNull JsArrayAccess x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.ArrayAccess.Builder arrayAccessBuilder = JsAstProtoBuf.ArrayAccess.newBuilder();
                JsExpression jsExpression = x.getArrayExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.arrayExpression");
                arrayAccessBuilder.setArray(this.this$0.serialize(jsExpression));
                JsExpression jsExpression2 = x.getIndexExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"x.indexExpression");
                arrayAccessBuilder.setIndex(this.this$0.serialize(jsExpression2));
                this.builder.setArrayAccess(arrayAccessBuilder.build());
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                JsName name = nameRef.getName();
                JsExpression qualifier = nameRef.getQualifier();
                if (name != null) {
                    if (qualifier != null || Intrinsics.areEqual((Object)MetadataProperties.isInline(nameRef), (Object)true)) {
                        JsAstProtoBuf.NameReference.Builder nameRefBuilder = JsAstProtoBuf.NameReference.newBuilder();
                        nameRefBuilder.setNameId(this.this$0.serialize(name));
                        if (qualifier != null) {
                            nameRefBuilder.setQualifier(this.this$0.serialize(qualifier));
                        }
                        Boolean bl = MetadataProperties.isInline(nameRef);
                        if (bl != null) {
                            boolean it = bl;
                            boolean bl2 = false;
                            nameRefBuilder.setInlineStrategy(it ? JsAstProtoBuf.InlineStrategy.IN_PLACE : JsAstProtoBuf.InlineStrategy.NOT_INLINE);
                        }
                        this.builder.setNameReference(nameRefBuilder.build());
                    } else {
                        this.builder.setSimpleNameReference(this.this$0.serialize(name));
                    }
                } else {
                    JsAstProtoBuf.PropertyReference.Builder propertyRefBuilder = JsAstProtoBuf.PropertyReference.newBuilder();
                    String string2 = nameRef.getIdent();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nameRef.ident");
                    propertyRefBuilder.setStringId(this.this$0.serialize(string2));
                    JsExpression jsExpression = qualifier;
                    if (jsExpression != null) {
                        JsExpression jsExpression2 = jsExpression;
                        JsAstSerializerBase jsAstSerializerBase = this.this$0;
                        JsExpression it = jsExpression2;
                        boolean bl = false;
                        propertyRefBuilder.setQualifier(jsAstSerializerBase.serialize(it));
                    }
                    Boolean bl = MetadataProperties.isInline(nameRef);
                    if (bl != null) {
                        boolean it = bl;
                        boolean bl3 = false;
                        propertyRefBuilder.setInlineStrategy(it ? JsAstProtoBuf.InlineStrategy.IN_PLACE : JsAstProtoBuf.InlineStrategy.NOT_INLINE);
                    }
                    this.builder.setPropertyReference(propertyRefBuilder.build());
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitInvocation(@NotNull JsInvocation invocation) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                JsAstProtoBuf.Invocation.Builder invocationBuilder = JsAstProtoBuf.Invocation.newBuilder();
                JsExpression jsExpression = invocation.getQualifier();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"invocation.qualifier");
                invocationBuilder.setQualifier(this.this$0.serialize(jsExpression));
                List<JsExpression> list2 = invocation.getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"invocation.arguments");
                Iterable iterable = list2;
                JsAstSerializerBase jsAstSerializerBase = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsExpression it = (JsExpression)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    invocationBuilder.addArgument(jsAstSerializerBase.serialize(it));
                }
                if (Intrinsics.areEqual((Object)MetadataProperties.isInline(invocation), (Object)true)) {
                    invocationBuilder.setInlineStrategy(JsAstProtoBuf.InlineStrategy.IN_PLACE);
                }
                this.builder.setInvocation(invocationBuilder.build());
            }

            /*
             * WARNING - void declaration
             */
            public void visitNew(@NotNull JsNew x) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsAstProtoBuf.Instantiation.Builder instantiationBuilder = JsAstProtoBuf.Instantiation.newBuilder();
                JsExpression jsExpression = x.getConstructorExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.constructorExpression");
                instantiationBuilder.setQualifier(this.this$0.serialize(jsExpression));
                List<JsExpression> list2 = x.getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"x.arguments");
                Iterable iterable = list2;
                JsAstSerializerBase jsAstSerializerBase = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsExpression it = (JsExpression)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    instantiationBuilder.addArgument(jsAstSerializerBase.serialize(it));
                }
                this.builder.setInstantiation(instantiationBuilder.build());
            }
        };
        JsAstSerializerBase this_$iv = this;
        boolean $i$f$withLocation = false;
        JsLocation location$iv = this_$iv.extractLocation(expression2);
        boolean fileChanged$iv = false;
        if (location$iv != null) {
            String newFile$iv;
            String lastFile$iv = this_$iv.getFileStack().peek();
            boolean bl = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
            if (fileChanged$iv) {
                int it = this_$iv.serialize(newFile$iv);
                boolean bl2 = false;
                visitor2.getBuilder().setFileId(it);
                this_$iv.getFileStack().push(location$iv.getFile());
            }
            JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
            locationBuilder$iv.setStartLine(location$iv.getStartLine());
            locationBuilder$iv.setStartChar(location$iv.getStartChar());
            JsAstProtoBuf.Location location = locationBuilder$iv.build();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"locationBuilder.build()");
            JsAstProtoBuf.Location it = location;
            boolean bl3 = false;
            visitor2.getBuilder().setLocation(it);
        }
        boolean bl = false;
        expression2.accept(visitor2);
        if (fileChanged$iv) {
            this_$iv.getFileStack().pop();
        }
        JsAstProtoBuf.Expression.Builder $this$serialize_u24lambda_u2d7 = visitor2.getBuilder();
        boolean bl4 = false;
        $this$serialize_u24lambda_u2d7.setSynthetic(MetadataProperties.getSynthetic(expression2));
        $this$serialize_u24lambda_u2d7.setSideEffects(this.map(MetadataProperties.getSideEffects(expression2)));
        JsImportedModule jsImportedModule = MetadataProperties.getLocalAlias(expression2);
        if (jsImportedModule != null) {
            JsImportedModule it = jsImportedModule;
            boolean bl5 = false;
            $this$serialize_u24lambda_u2d7.setLocalAlias(this.serialize(it));
        }
        JsAstProtoBuf.Expression expression3 = visitor2.getBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)expression3, (String)"visitor.builder.build()");
        return expression3;
    }

    @NotNull
    protected final JsAstProtoBuf.JsImportedModule serialize(@NotNull JsImportedModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        JsAstProtoBuf.JsImportedModule.Builder moduleBuilder = JsAstProtoBuf.JsImportedModule.newBuilder();
        moduleBuilder.setExternalName(this.serialize(module.getExternalName()));
        moduleBuilder.setInternalName(this.serialize(module.getInternalName()));
        JsExpression jsExpression = module.getPlainReference();
        if (jsExpression != null) {
            JsExpression it = jsExpression;
            boolean bl = false;
            moduleBuilder.setPlainReference(this.serialize(it));
        }
        JsAstProtoBuf.JsImportedModule jsImportedModule = moduleBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jsImportedModule, (String)"moduleBuilder.build()");
        return jsImportedModule;
    }

    @NotNull
    protected final JsAstProtoBuf.Parameter serializeParameter(@NotNull JsParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        JsAstProtoBuf.Parameter.Builder parameterBuilder = JsAstProtoBuf.Parameter.newBuilder();
        JsName jsName = parameter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"parameter.name");
        parameterBuilder.setNameId(this.serialize(jsName));
        if (MetadataProperties.getHasDefaultValue(parameter)) {
            parameterBuilder.setHasDefaultValue(true);
        }
        JsAstProtoBuf.Parameter parameter2 = parameterBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)parameter2, (String)"parameterBuilder.build()");
        return parameter2;
    }

    @NotNull
    protected final JsAstProtoBuf.CompositeBlock serializeBlock(@NotNull JsCompositeBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        JsAstProtoBuf.CompositeBlock.Builder blockBuilder = JsAstProtoBuf.CompositeBlock.newBuilder();
        for (JsStatement part : block.getStatements()) {
            Intrinsics.checkNotNullExpressionValue((Object)part, (String)"part");
            blockBuilder.addStatement(this.serialize(part));
        }
        JsAstProtoBuf.CompositeBlock compositeBlock = blockBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)compositeBlock, (String)"blockBuilder.build()");
        return compositeBlock;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final JsAstProtoBuf.Vars serializeVars(@NotNull JsVars vars) {
        Intrinsics.checkNotNullParameter((Object)vars, (String)"vars");
        JsAstProtoBuf.Vars.Builder varsBuilder = JsAstProtoBuf.Vars.newBuilder();
        for (JsVars.JsVar varDecl : vars.getVars()) {
            JsExpression jsExpression;
            void this_$iv;
            JsAstProtoBuf.VarDeclaration.Builder declBuilder = JsAstProtoBuf.VarDeclaration.newBuilder();
            JsAstSerializerBase jsAstSerializerBase = this;
            Intrinsics.checkNotNullExpressionValue((Object)varDecl, (String)"varDecl");
            JsNode node$iv = varDecl;
            boolean $i$f$withLocation = false;
            JsLocation location$iv = this_$iv.extractLocation(node$iv);
            boolean fileChanged$iv = false;
            if (location$iv != null) {
                JsAstProtoBuf.Location it;
                String newFile$iv;
                String lastFile$iv = this_$iv.getFileStack().peek();
                boolean bl = fileChanged$iv = !Intrinsics.areEqual((Object)lastFile$iv, (Object)(newFile$iv = location$iv.getFile()));
                if (fileChanged$iv) {
                    int it2 = this_$iv.serialize(newFile$iv);
                    boolean bl2 = false;
                    declBuilder.setFileId(it2);
                    this_$iv.getFileStack().push(location$iv.getFile());
                }
                JsAstProtoBuf.Location.Builder locationBuilder$iv = JsAstProtoBuf.Location.newBuilder();
                locationBuilder$iv.setStartLine(location$iv.getStartLine());
                locationBuilder$iv.setStartChar(location$iv.getStartChar());
                Intrinsics.checkNotNullExpressionValue((Object)locationBuilder$iv.build(), (String)"locationBuilder.build()");
                boolean bl3 = false;
                declBuilder.setLocation(it);
            }
            boolean bl = false;
            JsName jsName = varDecl.getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"varDecl.name");
            declBuilder.setNameId(this.serialize(jsName));
            JsExpression jsExpression2 = jsExpression = varDecl.getInitExpression();
            if (jsExpression2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"initExpression");
                JsExpression it = jsExpression;
                boolean bl4 = false;
                declBuilder.setInitialValue(this.serialize(it));
            }
            if (fileChanged$iv) {
                this_$iv.getFileStack().pop();
            }
            varsBuilder.addDeclaration(declBuilder);
        }
        if (vars.isMultiline()) {
            varsBuilder.setMultiline(true);
        }
        String string2 = MetadataProperties.getExportedPackage(vars);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            varsBuilder.setExportedPackageId(this.serialize(it));
        }
        JsAstProtoBuf.Vars vars2 = varsBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)vars2, (String)"varsBuilder.build()");
        return vars2;
    }

    @NotNull
    protected final JsAstProtoBuf.UnaryOperation serializeUnary(@NotNull JsUnaryOperation x, boolean postfix) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        JsAstProtoBuf.UnaryOperation.Builder unaryBuilder = JsAstProtoBuf.UnaryOperation.newBuilder();
        JsExpression jsExpression = x.getArg();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.arg");
        unaryBuilder.setOperand(this.serialize(jsExpression));
        JsUnaryOperator jsUnaryOperator = x.getOperator();
        Intrinsics.checkNotNullExpressionValue((Object)jsUnaryOperator, (String)"x.operator");
        unaryBuilder.setType(this.map(jsUnaryOperator));
        unaryBuilder.setPostfix(postfix);
        JsAstProtoBuf.UnaryOperation unaryOperation = unaryBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)unaryOperation, (String)"unaryBuilder.build()");
        return unaryOperation;
    }

    @NotNull
    protected final JsAstProtoBuf.BinaryOperation.Type map(@NotNull JsBinaryOperator op) {
        JsAstProtoBuf.BinaryOperation.Type type2;
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        switch (WhenMappings.$EnumSwitchMapping$0[op.ordinal()]) {
            case 1: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.MUL;
                break;
            }
            case 2: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.DIV;
                break;
            }
            case 3: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.MOD;
                break;
            }
            case 4: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ADD;
                break;
            }
            case 5: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SUB;
                break;
            }
            case 6: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SHL;
                break;
            }
            case 7: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SHR;
                break;
            }
            case 8: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.SHRU;
                break;
            }
            case 9: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.LT;
                break;
            }
            case 10: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.LTE;
                break;
            }
            case 11: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.GT;
                break;
            }
            case 12: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.GTE;
                break;
            }
            case 13: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.INSTANCEOF;
                break;
            }
            case 14: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.IN;
                break;
            }
            case 15: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.EQ;
                break;
            }
            case 16: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.NEQ;
                break;
            }
            case 17: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.REF_EQ;
                break;
            }
            case 18: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.REF_NEQ;
                break;
            }
            case 19: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.BIT_AND;
                break;
            }
            case 20: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.BIT_XOR;
                break;
            }
            case 21: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.BIT_OR;
                break;
            }
            case 22: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.AND;
                break;
            }
            case 23: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.OR;
                break;
            }
            case 24: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG;
                break;
            }
            case 25: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_ADD;
                break;
            }
            case 26: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SUB;
                break;
            }
            case 27: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_MUL;
                break;
            }
            case 28: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_DIV;
                break;
            }
            case 29: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_MOD;
                break;
            }
            case 30: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SHL;
                break;
            }
            case 31: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SHR;
                break;
            }
            case 32: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_SHRU;
                break;
            }
            case 33: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_BIT_AND;
                break;
            }
            case 34: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_BIT_OR;
                break;
            }
            case 35: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.ASG_BIT_XOR;
                break;
            }
            case 36: {
                type2 = JsAstProtoBuf.BinaryOperation.Type.COMMA;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return type2;
    }

    @NotNull
    protected final JsAstProtoBuf.UnaryOperation.Type map(@NotNull JsUnaryOperator op) {
        JsAstProtoBuf.UnaryOperation.Type type2;
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        switch (WhenMappings.$EnumSwitchMapping$1[op.ordinal()]) {
            case 1: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.BIT_NOT;
                break;
            }
            case 2: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.DEC;
                break;
            }
            case 3: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.DELETE;
                break;
            }
            case 4: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.INC;
                break;
            }
            case 5: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.NEG;
                break;
            }
            case 6: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.POS;
                break;
            }
            case 7: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.NOT;
                break;
            }
            case 8: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.TYPEOF;
                break;
            }
            case 9: {
                type2 = JsAstProtoBuf.UnaryOperation.Type.VOID;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return type2;
    }

    @NotNull
    protected final JsAstProtoBuf.SideEffects map(@NotNull SideEffectKind sideEffects) {
        JsAstProtoBuf.SideEffects sideEffects2;
        Intrinsics.checkNotNullParameter((Object)((Object)sideEffects), (String)"sideEffects");
        switch (WhenMappings.$EnumSwitchMapping$2[sideEffects.ordinal()]) {
            case 1: {
                sideEffects2 = JsAstProtoBuf.SideEffects.AFFECTS_STATE;
                break;
            }
            case 2: {
                sideEffects2 = JsAstProtoBuf.SideEffects.DEPENDS_ON_STATE;
                break;
            }
            case 3: {
                sideEffects2 = JsAstProtoBuf.SideEffects.PURE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sideEffects2;
    }

    @NotNull
    protected final JsAstProtoBuf.SpecialFunction map(@NotNull SpecialFunction specialFunction) {
        JsAstProtoBuf.SpecialFunction specialFunction2;
        Intrinsics.checkNotNullParameter((Object)((Object)specialFunction), (String)"specialFunction");
        switch (WhenMappings.$EnumSwitchMapping$3[specialFunction.ordinal()]) {
            case 1: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.DEFINE_INLINE_FUNCTION;
                break;
            }
            case 2: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.WRAP_FUNCTION;
                break;
            }
            case 3: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.TO_BOXED_CHAR;
                break;
            }
            case 4: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.UNBOX_CHAR;
                break;
            }
            case 5: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.SUSPEND_CALL;
                break;
            }
            case 6: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.COROUTINE_RESULT;
                break;
            }
            case 7: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.COROUTINE_CONTROLLER;
                break;
            }
            case 8: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.COROUTINE_RECEIVER;
                break;
            }
            case 9: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.SET_COROUTINE_RESULT;
                break;
            }
            case 10: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.GET_KCLASS;
                break;
            }
            case 11: {
                specialFunction2 = JsAstProtoBuf.SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return specialFunction2;
    }

    protected final int serialize(@NotNull JsName name) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<JsName, Integer> $this$getOrPut$iv = this.nameMap;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            Object it;
            boolean bl = false;
            JsAstProtoBuf.Name.Builder builder2 = JsAstProtoBuf.Name.newBuilder();
            String string2 = name.getIdent();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.ident");
            builder2.setIdentifier(this.serialize(string2));
            builder2.setTemporary(name.isTemporary());
            LocalAlias localAlias = MetadataProperties.getLocalAlias(name);
            if (localAlias != null) {
                it = localAlias;
                boolean bl2 = false;
                builder2.setLocalNameId(this.serialize((LocalAlias)it));
            }
            if (MetadataProperties.getImported(name) && !this.importedNames.contains(name)) {
                builder2.setImported(true);
            }
            SpecialFunction specialFunction = MetadataProperties.getSpecialFunction(name);
            if (specialFunction != null) {
                it = specialFunction;
                boolean bl3 = false;
                builder2.setSpecialFunction(this.map((SpecialFunction)((Object)it)));
            }
            int result2 = this.nameTableBuilder.getEntryCount();
            this.nameTableBuilder.addEntry(builder2);
            Integer answer$iv = result2;
            $this$getOrPut$iv.put(name, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    @NotNull
    protected final JsAstProtoBuf.LocalAlias serialize(@NotNull LocalAlias alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        JsAstProtoBuf.LocalAlias.Builder builder2 = JsAstProtoBuf.LocalAlias.newBuilder();
        builder2.setLocalNameId(this.serialize(alias.getName()));
        String string2 = alias.getTag();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            builder2.setTag(this.serialize(it));
        }
        JsAstProtoBuf.LocalAlias localAlias = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)localAlias, (String)"builder.build()");
        return localAlias;
    }

    protected final int serialize(@NotNull String string2) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        Map<String, Integer> $this$getOrPut$iv = this.stringMap;
        boolean $i$f$getOrPut = false;
        Integer value$iv = $this$getOrPut$iv.get(string2);
        if (value$iv == null) {
            boolean bl = false;
            int result2 = this.stringTableBuilder.getEntryCount();
            this.stringTableBuilder.addEntry(string2);
            Integer answer$iv = result2;
            $this$getOrPut$iv.put(string2, answer$iv);
            n = answer$iv;
        } else {
            n = value$iv;
        }
        return ((Number)n).intValue();
    }

    private final void withLocation(JsNode node, Function1<? super Integer, Unit> fileConsumer, Function1<? super JsAstProtoBuf.Location, Unit> locationConsumer, Function0<Unit> inner) {
        boolean $i$f$withLocation = false;
        JsLocation location = this.extractLocation(node);
        boolean fileChanged = false;
        if (location != null) {
            String newFile;
            String lastFile = this.getFileStack().peek();
            boolean bl = fileChanged = !Intrinsics.areEqual((Object)lastFile, (Object)(newFile = location.getFile()));
            if (fileChanged) {
                fileConsumer.invoke((Object)this.serialize(newFile));
                this.getFileStack().push(location.getFile());
            }
            JsAstProtoBuf.Location.Builder locationBuilder = JsAstProtoBuf.Location.newBuilder();
            locationBuilder.setStartLine(location.getStartLine());
            locationBuilder.setStartChar(location.getStartChar());
            JsAstProtoBuf.Location location2 = locationBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"locationBuilder.build()");
            locationConsumer.invoke((Object)location2);
        }
        inner.invoke();
        if (fileChanged) {
            this.getFileStack().pop();
        }
    }

    @Nullable
    public abstract JsLocation extractLocation(@NotNull JsNode var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[JsBinaryOperator.values().length];
            nArray[JsBinaryOperator.MUL.ordinal()] = 1;
            nArray[JsBinaryOperator.DIV.ordinal()] = 2;
            nArray[JsBinaryOperator.MOD.ordinal()] = 3;
            nArray[JsBinaryOperator.ADD.ordinal()] = 4;
            nArray[JsBinaryOperator.SUB.ordinal()] = 5;
            nArray[JsBinaryOperator.SHL.ordinal()] = 6;
            nArray[JsBinaryOperator.SHR.ordinal()] = 7;
            nArray[JsBinaryOperator.SHRU.ordinal()] = 8;
            nArray[JsBinaryOperator.LT.ordinal()] = 9;
            nArray[JsBinaryOperator.LTE.ordinal()] = 10;
            nArray[JsBinaryOperator.GT.ordinal()] = 11;
            nArray[JsBinaryOperator.GTE.ordinal()] = 12;
            nArray[JsBinaryOperator.INSTANCEOF.ordinal()] = 13;
            nArray[JsBinaryOperator.INOP.ordinal()] = 14;
            nArray[JsBinaryOperator.EQ.ordinal()] = 15;
            nArray[JsBinaryOperator.NEQ.ordinal()] = 16;
            nArray[JsBinaryOperator.REF_EQ.ordinal()] = 17;
            nArray[JsBinaryOperator.REF_NEQ.ordinal()] = 18;
            nArray[JsBinaryOperator.BIT_AND.ordinal()] = 19;
            nArray[JsBinaryOperator.BIT_XOR.ordinal()] = 20;
            nArray[JsBinaryOperator.BIT_OR.ordinal()] = 21;
            nArray[JsBinaryOperator.AND.ordinal()] = 22;
            nArray[JsBinaryOperator.OR.ordinal()] = 23;
            nArray[JsBinaryOperator.ASG.ordinal()] = 24;
            nArray[JsBinaryOperator.ASG_ADD.ordinal()] = 25;
            nArray[JsBinaryOperator.ASG_SUB.ordinal()] = 26;
            nArray[JsBinaryOperator.ASG_MUL.ordinal()] = 27;
            nArray[JsBinaryOperator.ASG_DIV.ordinal()] = 28;
            nArray[JsBinaryOperator.ASG_MOD.ordinal()] = 29;
            nArray[JsBinaryOperator.ASG_SHL.ordinal()] = 30;
            nArray[JsBinaryOperator.ASG_SHR.ordinal()] = 31;
            nArray[JsBinaryOperator.ASG_SHRU.ordinal()] = 32;
            nArray[JsBinaryOperator.ASG_BIT_AND.ordinal()] = 33;
            nArray[JsBinaryOperator.ASG_BIT_OR.ordinal()] = 34;
            nArray[JsBinaryOperator.ASG_BIT_XOR.ordinal()] = 35;
            nArray[JsBinaryOperator.COMMA.ordinal()] = 36;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JsUnaryOperator.values().length];
            nArray[JsUnaryOperator.BIT_NOT.ordinal()] = 1;
            nArray[JsUnaryOperator.DEC.ordinal()] = 2;
            nArray[JsUnaryOperator.DELETE.ordinal()] = 3;
            nArray[JsUnaryOperator.INC.ordinal()] = 4;
            nArray[JsUnaryOperator.NEG.ordinal()] = 5;
            nArray[JsUnaryOperator.POS.ordinal()] = 6;
            nArray[JsUnaryOperator.NOT.ordinal()] = 7;
            nArray[JsUnaryOperator.TYPEOF.ordinal()] = 8;
            nArray[JsUnaryOperator.VOID.ordinal()] = 9;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[SideEffectKind.values().length];
            nArray[SideEffectKind.AFFECTS_STATE.ordinal()] = 1;
            nArray[SideEffectKind.DEPENDS_ON_STATE.ordinal()] = 2;
            nArray[SideEffectKind.PURE.ordinal()] = 3;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[SpecialFunction.values().length];
            nArray[SpecialFunction.DEFINE_INLINE_FUNCTION.ordinal()] = 1;
            nArray[SpecialFunction.WRAP_FUNCTION.ordinal()] = 2;
            nArray[SpecialFunction.TO_BOXED_CHAR.ordinal()] = 3;
            nArray[SpecialFunction.UNBOX_CHAR.ordinal()] = 4;
            nArray[SpecialFunction.SUSPEND_CALL.ordinal()] = 5;
            nArray[SpecialFunction.COROUTINE_RESULT.ordinal()] = 6;
            nArray[SpecialFunction.COROUTINE_CONTROLLER.ordinal()] = 7;
            nArray[SpecialFunction.COROUTINE_RECEIVER.ordinal()] = 8;
            nArray[SpecialFunction.SET_COROUTINE_RESULT.ordinal()] = 9;
            nArray[SpecialFunction.GET_KCLASS.ordinal()] = 10;
            nArray[SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE.ordinal()] = 11;
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

