/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryBytesSource;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFileFromBytes;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.ir.backend.js.ic.ArtifactCache;
import org.jetbrains.kotlin.ir.backend.js.ic.FileUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.ic.HashCalculatorForICKt;
import org.jetbrains.kotlin.ir.backend.js.ic.ICHash;
import org.jetbrains.kotlin.ir.backend.js.ic.ModuleArtifact;
import org.jetbrains.kotlin.ir.backend.js.ic.SrcFileArtifact;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.CodedOutputStream;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ^2\u00020\u0001:\u0003\\]^B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u0012\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b3\u00104J\b\u00105\u001a\u000206H\u0002J\u0014\u00107\u001a\u0002062\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u0005H\u0002J\u000e\u00109\u001a\u0002062\u0006\u00108\u001a\u00020\u0005J\u0006\u0010:\u001a\u000206J\b\u0010;\u001a\u000206H\u0002J\b\u0010<\u001a\u00020=H\u0016J\r\u0010>\u001a\u0004\u0018\u000106\u00a2\u0006\u0002\u0010?J\u0006\u0010@\u001a\u000206J\u0010\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\u0005H\u0002J\u0006\u0010C\u001a\u000206J\u001b\u0010D\u001a\u0002062\u0006\u0010E\u001a\u00020\u0012\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bF\u0010GJ\u000e\u0010H\u001a\u0002062\u0006\u0010I\u001a\u00020\u0005JO\u0010J\u001a\u0002062\u0006\u0010I\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u00122\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00172\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0017\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bL\u0010MJ\"\u0010N\u001a\u0002062\u0006\u0010I\u001a\u00020\u00052\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020#0\u0017J\u001e\u0010P\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020R0Q0$*\u00020\u0003H\u0002J=\u0010S\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0017*\u00020T2\u0006\u0010U\u001a\u00020R2\u0016\b\u0002\u0010V\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020#\u0018\u00010\u0011H\u0002\u00f8\u0001\u0000J\f\u0010W\u001a\u000206*\u00020TH\u0002J7\u0010X\u001a\u000206*\u00020Y2\u0012\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020#0\u00172\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120\u0017H\u0002\u00f8\u0001\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120\u00170\u00168F\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR)\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120\u00170\u0011X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u00128F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020#0\u00170\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050$2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050$@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R \u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u00178F\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010-\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120\u00170\u00178F\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b.\u0010*R)\u0010/\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120\u00170\u0011X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006_"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ArtifactCache;", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "cachePath", "", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;Ljava/lang/String;)V", "cacheDir", "Ljava/io/File;", "cacheFastInfo", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$CacheFastInfo;", "<set-?>", "", "deletedSrcFiles", "getDeletedSrcFiles", "()Ljava/util/Set;", "fingerprints", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ICHash;", "forceRebuildJs", "", "implementedFunctions", "", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getImplementedFunctions", "()Ljava/util/Collection;", "implementedInlineFunctions", "klibTransitiveHash", "getKlibTransitiveHash-Yd-dAqs", "()J", "klibUpdated", "getKlibUpdated", "()Z", "signatureToIdMapping", "", "", "srcFilesInOrderFromKLib", "getSrcFilesInOrderFromKLib", "()Ljava/util/List;", "srcFingerprints", "getSrcFingerprints", "()Ljava/util/Map;", "state", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$CacheState;", "usedFunctions", "getUsedFunctions", "usedInlineFunctions", "checkAndUpdateCacheFastInfo", "flatHash", "transHash", "checkAndUpdateCacheFastInfo-VBntS4A", "(JJ)Z", "clearCacheAfterCommit", "", "commitCacheFastInfo", "klibModuleName", "commitCacheForRebuiltSrcFiles", "commitCacheForRemovedSrcFiles", "commitCacheFullInfo", "fetchArtifacts", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ModuleArtifact;", "fetchCacheDataForDependency", "()Lkotlin/Unit;", "fetchFullCacheData", "getBinaryAstPath", "srcFile", "invalidate", "invalidateCacheForNewConfig", "configHash", "invalidateCacheForNewConfig-ycJ14Ss", "(J)V", "invalidateForSrcFile", "srcPath", "updateHashes", "fingerprint", "updateHashes--BhkBBM", "(Ljava/lang/String;JLjava/util/Map;Ljava/util/Map;)V", "updateSignatureToIdMapping", "mapping", "filesAndSigReaders", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "readFunctionHashes", "Lorg/jetbrains/kotlin/protobuf/CodedInputStream;", "deserializer", "signatureToId", "skipFunctionHashes", "writeFunctionHashes", "Lorg/jetbrains/kotlin/protobuf/CodedOutputStream;", "sigToIndexMap", "hashes", "CacheFastInfo", "CacheState", "Companion", "backend.js"})
public final class IncrementalCache
extends ArtifactCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinLibrary library;
    @NotNull
    private CacheState state;
    private boolean forceRebuildJs;
    @NotNull
    private final File cacheDir;
    @NotNull
    private final Map<String, Map<IdSignature, Integer>> signatureToIdMapping;
    @NotNull
    private final Map<String, ICHash> fingerprints;
    @NotNull
    private final Map<String, Map<IdSignature, ICHash>> usedInlineFunctions;
    @NotNull
    private final Map<String, Map<IdSignature, ICHash>> implementedInlineFunctions;
    @NotNull
    private CacheFastInfo cacheFastInfo;
    @NotNull
    private List<String> srcFilesInOrderFromKLib;
    @NotNull
    private Set<String> deletedSrcFiles;
    @NotNull
    private static final String cacheFullInfoFile = "cache.full.info";
    @NotNull
    private static final String cacheFastInfoFile = "cache.fast.info";
    @NotNull
    private static final String binaryAstSuffix = "binary.ast";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public IncrementalCache(@NotNull KotlinLibrary library, @NotNull String cachePath) {
        void $this$cacheFastInfo_u24lambda_u2d1;
        CacheFastInfo cacheFastInfo;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)cachePath, (String)"cachePath");
        this.library = library;
        this.state = CacheState.NON_LOADED;
        this.cacheDir = new File(cachePath);
        this.signatureToIdMapping = new LinkedHashMap();
        this.fingerprints = new LinkedHashMap();
        this.usedInlineFunctions = new LinkedHashMap();
        this.implementedInlineFunctions = new LinkedHashMap();
        CacheFastInfo cacheFastInfo2 = cacheFastInfo = new CacheFastInfo(null, 0L, 0L, 0L, 0L, 31, null);
        IncrementalCache incrementalCache = this;
        boolean bl = false;
        File $this$useCodedInputIfExists$iv = new File(this.cacheDir, cacheFastInfoFile);
        boolean $i$f$useCodedInputIfExists = false;
        File $this$ifExists$iv$iv = $this$useCodedInputIfExists$iv;
        boolean $i$f$ifExists = false;
        if ($this$ifExists$iv$iv.exists()) {
            File $this$useCodedInputIfExists_u24lambda_u2d1$iv = $this$ifExists$iv$iv;
            boolean bl2 = false;
            Closeable closeable = new FileInputStream($this$useCodedInputIfExists_u24lambda_u2d1$iv);
            Throwable throwable = null;
            try {
                FileInputStream it$iv = (FileInputStream)closeable;
                boolean bl3 = false;
                CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)it$iv);
                Intrinsics.checkNotNullExpressionValue((Object)codedInputStream, (String)"newInstance(it)");
                CodedInputStream $this$cacheFastInfo_u24lambda_u2d1_u24lambda_u2d0 = codedInputStream;
                boolean bl4 = false;
                $this$cacheFastInfo_u24lambda_u2d1.setModuleName($this$cacheFastInfo_u24lambda_u2d1_u24lambda_u2d0.readString());
                $this$cacheFastInfo_u24lambda_u2d1.setFlatHash-ycJ14Ss(ICHash.Companion.fromProtoStream-TVZkk9w($this$cacheFastInfo_u24lambda_u2d1_u24lambda_u2d0));
                $this$cacheFastInfo_u24lambda_u2d1.setTransHash-ycJ14Ss(ICHash.Companion.fromProtoStream-TVZkk9w($this$cacheFastInfo_u24lambda_u2d1_u24lambda_u2d0));
                $this$cacheFastInfo_u24lambda_u2d1.setConfigHash-ycJ14Ss(ICHash.Companion.fromProtoStream-TVZkk9w($this$cacheFastInfo_u24lambda_u2d1_u24lambda_u2d0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        $this$cacheFastInfo_u24lambda_u2d1.setInitialFlatHash-ycJ14Ss($this$cacheFastInfo_u24lambda_u2d1.getFlatHash-Yd-dAqs());
        incrementalCache.cacheFastInfo = cacheFastInfo;
        this.srcFilesInOrderFromKLib = CollectionsKt.emptyList();
        this.deletedSrcFiles = SetsKt.emptySet();
    }

    @NotNull
    public final Map<String, ICHash> getSrcFingerprints() {
        return this.fingerprints;
    }

    @NotNull
    public final Map<String, Map<IdSignature, ICHash>> getUsedFunctions() {
        return this.usedInlineFunctions;
    }

    @NotNull
    public final Collection<Map<IdSignature, ICHash>> getImplementedFunctions() {
        return this.implementedInlineFunctions.values();
    }

    public final boolean getKlibUpdated() {
        CacheFastInfo $this$_get_klibUpdated__u24lambda_u2d2 = this.cacheFastInfo;
        boolean bl = false;
        return ICHash.equals-impl0($this$_get_klibUpdated__u24lambda_u2d2.getInitialFlatHash-Yd-dAqs(), ICHash.constructor-impl$default(0L, 1, null)) || !ICHash.equals-impl0($this$_get_klibUpdated__u24lambda_u2d2.getInitialFlatHash-Yd-dAqs(), $this$_get_klibUpdated__u24lambda_u2d2.getFlatHash-Yd-dAqs());
    }

    public final long getKlibTransitiveHash-Yd-dAqs() {
        return this.cacheFastInfo.getTransHash-Yd-dAqs();
    }

    @NotNull
    public final List<String> getSrcFilesInOrderFromKLib() {
        return this.srcFilesInOrderFromKLib;
    }

    @NotNull
    public final Set<String> getDeletedSrcFiles() {
        return this.deletedSrcFiles;
    }

    public final void updateSignatureToIdMapping(@NotNull String srcPath, @NotNull Map<IdSignature, Integer> mapping2) {
        Intrinsics.checkNotNullParameter((Object)srcPath, (String)"srcPath");
        Intrinsics.checkNotNullParameter(mapping2, (String)"mapping");
        this.signatureToIdMapping.put(srcPath, mapping2);
    }

    public final void updateHashes--BhkBBM(@NotNull String srcPath, long fingerprint, @Nullable Map<IdSignature, ICHash> usedFunctions, @Nullable Map<IdSignature, ICHash> implementedFunctions) {
        block1: {
            Map<IdSignature, ICHash> it;
            Intrinsics.checkNotNullParameter((Object)srcPath, (String)"srcPath");
            ICHash iCHash = ICHash.box-impl(fingerprint);
            this.fingerprints.put(srcPath, iCHash);
            Map<IdSignature, ICHash> map = usedFunctions;
            if (map != null) {
                it = map;
                boolean bl = false;
                this.usedInlineFunctions.put(srcPath, it);
            }
            Map<IdSignature, ICHash> map2 = implementedFunctions;
            if (map2 == null) break block1;
            it = map2;
            boolean bl = false;
            this.implementedInlineFunctions.put(srcPath, it);
        }
    }

    public final void invalidateCacheForNewConfig-ycJ14Ss(long configHash) {
        if (!ICHash.equals-impl0(this.cacheFastInfo.getConfigHash-Yd-dAqs(), configHash)) {
            this.invalidate();
            this.cacheFastInfo.setConfigHash-ycJ14Ss(configHash);
        }
    }

    public final boolean checkAndUpdateCacheFastInfo-VBntS4A(long flatHash, long transHash) {
        if (!ICHash.equals-impl0(this.cacheFastInfo.getTransHash-Yd-dAqs(), transHash)) {
            this.cacheFastInfo.setFlatHash-ycJ14Ss(flatHash);
            this.cacheFastInfo.setTransHash-ycJ14Ss(transHash);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void commitCacheFastInfo(String klibModuleName) {
        CacheFastInfo $this$commitCacheFastInfo_u24lambda_u2d6 = this.cacheFastInfo;
        boolean bl = false;
        String string2 = klibModuleName;
        if (string2 == null) {
            string2 = $this$commitCacheFastInfo_u24lambda_u2d6.getModuleName();
        }
        $this$commitCacheFastInfo_u24lambda_u2d6.setModuleName(string2);
        String string3 = $this$commitCacheFastInfo_u24lambda_u2d6.getModuleName();
        if (string3 == null) {
            throw new IllegalStateException(("Internal error: uninitialized fast cache info for " + this.library.getLibraryName()).toString());
        }
        String name = string3;
        File $this$useCodedOutput$iv = new File(this.cacheDir, cacheFastInfoFile);
        boolean $i$f$useCodedOutput = false;
        File file2 = $this$useCodedOutput$iv.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        FileUtilsKt.recreate($this$useCodedOutput$iv);
        Closeable closeable = new FileOutputStream($this$useCodedOutput$iv);
        Throwable throwable = null;
        try {
            FileOutputStream it$iv = (FileOutputStream)closeable;
            boolean bl2 = false;
            CodedOutputStream out$iv = CodedOutputStream.newInstance((OutputStream)it$iv);
            Intrinsics.checkNotNullExpressionValue((Object)out$iv, (String)"out");
            CodedOutputStream $this$commitCacheFastInfo_u24lambda_u2d6_u24lambda_u2d5 = out$iv;
            boolean bl3 = false;
            $this$commitCacheFastInfo_u24lambda_u2d6_u24lambda_u2d5.writeStringNoTag(name);
            ICHash.toProtoStream-impl($this$commitCacheFastInfo_u24lambda_u2d6.getFlatHash-Yd-dAqs(), $this$commitCacheFastInfo_u24lambda_u2d6_u24lambda_u2d5);
            ICHash.toProtoStream-impl($this$commitCacheFastInfo_u24lambda_u2d6.getTransHash-Yd-dAqs(), $this$commitCacheFastInfo_u24lambda_u2d6_u24lambda_u2d5);
            ICHash.toProtoStream-impl($this$commitCacheFastInfo_u24lambda_u2d6.getConfigHash-Yd-dAqs(), $this$commitCacheFastInfo_u24lambda_u2d6_u24lambda_u2d5);
            out$iv.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static /* synthetic */ void commitCacheFastInfo$default(IncrementalCache incrementalCache, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        incrementalCache.commitCacheFastInfo(string2);
    }

    private final Map<IdSignature, ICHash> readFunctionHashes(CodedInputStream $this$readFunctionHashes, IdSignatureDeserializer deserializer, Map<IdSignature, Integer> signatureToId) {
        int functions2 = $this$readFunctionHashes.readInt32();
        if (functions2 == 0) {
            return null;
        }
        Map result2 = new LinkedHashMap();
        for (int funIndex = 0; funIndex < functions2; ++funIndex) {
            int sigId = $this$readFunctionHashes.readInt32();
            long hash = ICHash.Companion.fromProtoStream-TVZkk9w($this$readFunctionHashes);
            try {
                Map<IdSignature, Integer> it;
                IdSignature signature = deserializer.deserializeIdSignature(sigId);
                ICHash iCHash = ICHash.box-impl(hash);
                result2.put(signature, iCHash);
                if (signatureToId == null) continue;
                boolean bl = false;
                Integer n = sigId;
                it.put(signature, n);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return result2;
    }

    static /* synthetic */ Map readFunctionHashes$default(IncrementalCache incrementalCache, CodedInputStream codedInputStream, IdSignatureDeserializer idSignatureDeserializer, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return incrementalCache.readFunctionHashes(codedInputStream, idSignatureDeserializer, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void fetchFullCacheData() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                throw new IllegalStateException(("Internal error: cache for " + this.library.getLibraryName() + " has been already fetched for dependency").toString());
            }
            case 3: {
                Object object;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                this.state = CacheState.FETCHED_FULL;
                List<Pair<String, IdSignatureDeserializer>> signatureReaders = this.filesAndSigReaders(this.library);
                Iterable iterable = signatureReaders;
                IncrementalCache incrementalCache = this;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    object = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)it.getFirst());
                }
                incrementalCache.srcFilesInOrderFromKLib = (List)destination$iv$iv;
                File $this$useCodedInputIfExists$iv = new File(this.cacheDir, cacheFullInfoFile);
                boolean $i$f$useCodedInputIfExists = false;
                File $this$ifExists$iv$iv = $this$useCodedInputIfExists$iv;
                boolean $i$f$ifExists = false;
                if (!$this$ifExists$iv$iv.exists()) break;
                File $this$useCodedInputIfExists_u24lambda_u2d1$iv = $this$ifExists$iv$iv;
                boolean bl = false;
                Closeable closeable = new FileInputStream($this$useCodedInputIfExists_u24lambda_u2d1$iv);
                object = null;
                try {
                    FileInputStream it$iv = (FileInputStream)closeable;
                    boolean bl2 = false;
                    CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)it$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)codedInputStream, (String)"newInstance(it)");
                    CodedInputStream $this$fetchFullCacheData_u24lambda_u2d11 = codedInputStream;
                    boolean bl3 = false;
                    Set deleted = new LinkedHashSet();
                    Map signatureReadersMap = MapsKt.toMap((Iterable)signatureReaders);
                    int srcFiles = $this$fetchFullCacheData_u24lambda_u2d11.readInt32();
                    for (int srcIndex = 0; srcIndex < srcFiles; ++srcIndex) {
                        String srcPath = $this$fetchFullCacheData_u24lambda_u2d11.readString();
                        long fingerprint = ICHash.Companion.fromProtoStream-TVZkk9w($this$fetchFullCacheData_u24lambda_u2d11);
                        IdSignatureDeserializer deserializer = (IdSignatureDeserializer)signatureReadersMap.get(srcPath);
                        if (deserializer != null) {
                            Map<IdSignature, ICHash> it;
                            ICHash iCHash = ICHash.box-impl(fingerprint);
                            Intrinsics.checkNotNullExpressionValue((Object)srcPath, (String)"srcPath");
                            this.fingerprints.put(srcPath, iCHash);
                            Map signatureToId = new LinkedHashMap();
                            if (this.readFunctionHashes($this$fetchFullCacheData_u24lambda_u2d11, deserializer, signatureToId) != null) {
                                boolean bl4 = false;
                                this.implementedInlineFunctions.put(srcPath, it);
                            }
                            if (this.readFunctionHashes($this$fetchFullCacheData_u24lambda_u2d11, deserializer, signatureToId) != null) {
                                boolean bl5 = false;
                                this.usedInlineFunctions.put(srcPath, it);
                            }
                            if (!(!signatureToId.isEmpty())) continue;
                            this.signatureToIdMapping.put(srcPath, signatureToId);
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)srcPath, (String)"srcPath");
                        deleted.add(srcPath);
                        this.skipFunctionHashes($this$fetchFullCacheData_u24lambda_u2d11);
                        this.skipFunctionHashes($this$fetchFullCacheData_u24lambda_u2d11);
                    }
                    this.deletedSrcFiles = deleted;
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
        }
    }

    private final void skipFunctionHashes(CodedInputStream $this$skipFunctionHashes) {
        int functions2 = $this$skipFunctionHashes.readInt32();
        for (int funIndex = 0; funIndex < functions2; ++funIndex) {
            $this$skipFunctionHashes.readInt32();
            $this$skipFunctionHashes.readFixed64();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Unit fetchCacheDataForDependency() {
        Unit unit;
        File $this$useCodedInputIfExists$iv = new File(this.cacheDir, cacheFullInfoFile);
        boolean $i$f$useCodedInputIfExists = false;
        File $this$ifExists$iv$iv = $this$useCodedInputIfExists$iv;
        boolean $i$f$ifExists = false;
        if ($this$ifExists$iv$iv.exists()) {
            File $this$useCodedInputIfExists_u24lambda_u2d1$iv = $this$ifExists$iv$iv;
            boolean bl = false;
            Closeable closeable = new FileInputStream($this$useCodedInputIfExists_u24lambda_u2d1$iv);
            Throwable throwable = null;
            try {
                FileInputStream it$iv = (FileInputStream)closeable;
                boolean bl2 = false;
                CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)it$iv);
                Intrinsics.checkNotNullExpressionValue((Object)codedInputStream, (String)"newInstance(it)");
                CodedInputStream $this$fetchCacheDataForDependency_u24lambda_u2d13 = codedInputStream;
                boolean bl3 = false;
                if (this.state == CacheState.NON_LOADED) {
                    this.state = CacheState.FETCHED_FOR_DEPENDENCY;
                    Map signatureReadersMap = MapsKt.toMap((Iterable)this.filesAndSigReaders(this.library));
                    int srcFiles = $this$fetchCacheDataForDependency_u24lambda_u2d13.readInt32();
                    for (int srcIndex = 0; srcIndex < srcFiles; ++srcIndex) {
                        String srcPath = $this$fetchCacheDataForDependency_u24lambda_u2d13.readString();
                        long fingerprint = ICHash.Companion.fromProtoStream-TVZkk9w($this$fetchCacheDataForDependency_u24lambda_u2d13);
                        IdSignatureDeserializer deserializer = (IdSignatureDeserializer)signatureReadersMap.get(srcPath);
                        if (deserializer != null) {
                            ICHash iCHash = ICHash.box-impl(fingerprint);
                            Intrinsics.checkNotNullExpressionValue((Object)srcPath, (String)"srcPath");
                            this.fingerprints.put(srcPath, iCHash);
                            if (IncrementalCache.readFunctionHashes$default(this, $this$fetchCacheDataForDependency_u24lambda_u2d13, deserializer, null, 2, null) != null) {
                                Map it;
                                boolean bl4 = false;
                                this.implementedInlineFunctions.put(srcPath, it);
                            }
                        }
                        this.skipFunctionHashes($this$fetchCacheDataForDependency_u24lambda_u2d13);
                    }
                }
                Unit unit2 = Unit.INSTANCE;
                unit = unit2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        unit = null;
        return unit;
    }

    private final File getBinaryAstPath(String srcFile) {
        String binaryAstFileName = new File(srcFile).getName() + '.' + ICHash.toString-impl(HashCalculatorForICKt.stringHashForIC(srcFile)) + ".binary.ast";
        return new File(this.cacheDir, binaryAstFileName);
    }

    private final void writeFunctionHashes(CodedOutputStream $this$writeFunctionHashes, Map<IdSignature, Integer> sigToIndexMap, Map<IdSignature, ICHash> hashes) {
        $this$writeFunctionHashes.writeInt32NoTag(hashes.size());
        for (Map.Entry<IdSignature, ICHash> entry : hashes.entrySet()) {
            IdSignature sig = entry.getKey();
            long functionHash = entry.getValue().unbox-impl();
            Integer n = sigToIndexMap.get(sig);
            if (n == null) {
                throw new IllegalStateException(("No index found for sig " + sig).toString());
            }
            int sigId = n;
            $this$writeFunctionHashes.writeInt32NoTag(sigId);
            ICHash.toProtoStream-impl(functionHash, $this$writeFunctionHashes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void commitCacheFullInfo() {
        if (this.state != CacheState.FETCHED_FULL) {
            throw new IllegalStateException(("Internal error: cache for " + this.library.getLibraryName() + " has not been fetched fully").toString());
        }
        File $this$useCodedOutput$iv = new File(this.cacheDir, cacheFullInfoFile);
        boolean $i$f$useCodedOutput = false;
        File file2 = $this$useCodedOutput$iv.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        FileUtilsKt.recreate($this$useCodedOutput$iv);
        Closeable closeable = new FileOutputStream($this$useCodedOutput$iv);
        Throwable throwable = null;
        try {
            FileOutputStream it$iv = (FileOutputStream)closeable;
            boolean bl = false;
            CodedOutputStream out$iv = CodedOutputStream.newInstance((OutputStream)it$iv);
            Intrinsics.checkNotNullExpressionValue((Object)out$iv, (String)"out");
            CodedOutputStream $this$commitCacheFullInfo_u24lambda_u2d14 = out$iv;
            boolean bl2 = false;
            $this$commitCacheFullInfo_u24lambda_u2d14.writeInt32NoTag(this.fingerprints.size());
            for (Map.Entry<String, ICHash> entry : this.fingerprints.entrySet()) {
                Map map;
                Map sigToIndexMap;
                String srcPath = entry.getKey();
                long fingerprint = entry.getValue().unbox-impl();
                $this$commitCacheFullInfo_u24lambda_u2d14.writeStringNoTag(srcPath);
                ICHash.toProtoStream-impl(fingerprint, $this$commitCacheFullInfo_u24lambda_u2d14);
                Map map2 = this.signatureToIdMapping.get(srcPath);
                if (map2 == null) {
                    map2 = sigToIndexMap = MapsKt.emptyMap();
                }
                if ((map = this.implementedInlineFunctions.get(srcPath)) == null) {
                    map = MapsKt.emptyMap();
                }
                this.writeFunctionHashes($this$commitCacheFullInfo_u24lambda_u2d14, sigToIndexMap, map);
                Map map3 = this.usedInlineFunctions.get(srcPath);
                if (map3 == null) {
                    map3 = MapsKt.emptyMap();
                }
                this.writeFunctionHashes($this$commitCacheFullInfo_u24lambda_u2d14, sigToIndexMap, map3);
            }
            out$iv.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void clearCacheAfterCommit() {
        this.state = CacheState.FETCHED_FOR_DEPENDENCY;
        this.forceRebuildJs = !((Collection)this.deletedSrcFiles).isEmpty();
        this.signatureToIdMapping.clear();
        this.usedInlineFunctions.clear();
        this.srcFilesInOrderFromKLib = CollectionsKt.emptyList();
        this.deletedSrcFiles = SetsKt.emptySet();
        this.getBinaryAsts().clear();
    }

    public final void commitCacheForRemovedSrcFiles() {
        IncrementalCache.commitCacheFastInfo$default(this, null, 1, null);
        if (!((Collection)this.deletedSrcFiles).isEmpty()) {
            this.commitCacheFullInfo();
        }
        this.clearCacheAfterCommit();
    }

    public final void commitCacheForRebuiltSrcFiles(@NotNull String klibModuleName) {
        Intrinsics.checkNotNullParameter((Object)klibModuleName, (String)"klibModuleName");
        this.commitCacheFastInfo(klibModuleName);
        this.commitCacheFullInfo();
        for (Map.Entry<String, byte[]> entry : this.getBinaryAsts().entrySet()) {
            File file2;
            String srcPath = entry.getKey();
            byte[] ast = entry.getValue();
            File $this$commitCacheForRebuiltSrcFiles_u24lambda_u2d15 = file2 = this.getBinaryAstPath(srcPath);
            boolean bl = false;
            FileUtilsKt.recreate($this$commitCacheForRebuiltSrcFiles_u24lambda_u2d15);
            FilesKt.writeBytes((File)file2, (byte[])ast);
        }
        this.clearCacheAfterCommit();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ModuleArtifact fetchArtifacts() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string2 = this.cacheFastInfo.getModuleName();
        if (string2 == null) {
            throw new IllegalStateException("Internal error: missing module name".toString());
        }
        Iterable iterable = this.fingerprints.keySet();
        String string3 = string2;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string4 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SrcFileArtifact((String)it, this.getFragments().get(it), this.getBinaryAstPath((String)it)));
        }
        boolean bl = this.forceRebuildJs;
        File file2 = this.cacheDir;
        List list2 = (List)destination$iv$iv;
        String string5 = string3;
        return new ModuleArtifact(string5, list2, file2, bl);
    }

    public final void invalidate() {
        FilesKt.deleteRecursively((File)this.cacheDir);
        this.signatureToIdMapping.clear();
        this.implementedInlineFunctions.clear();
        this.usedInlineFunctions.clear();
        this.fingerprints.clear();
        this.getBinaryAsts().clear();
        this.getFragments().clear();
        this.cacheFastInfo = new CacheFastInfo(null, 0L, 0L, 0L, 0L, 31, null);
        this.srcFilesInOrderFromKLib = CollectionsKt.emptyList();
        this.deletedSrcFiles = SetsKt.emptySet();
    }

    public final void invalidateForSrcFile(@NotNull String srcPath) {
        Intrinsics.checkNotNullParameter((Object)srcPath, (String)"srcPath");
        this.getBinaryAstPath(srcPath).delete();
        this.signatureToIdMapping.remove(srcPath);
        this.implementedInlineFunctions.remove(srcPath);
        this.usedInlineFunctions.remove(srcPath);
        this.fingerprints.remove(srcPath);
        this.getBinaryAsts().remove(srcPath);
        this.getFragments().remove(srcPath);
    }

    private final List<Pair<String, IdSignatureDeserializer>> filesAndSigReaders(KotlinLibrary $this$filesAndSigReaders) {
        int fileSize = $this$filesAndSigReaders.fileCount();
        ArrayList<Pair> result2 = new ArrayList<Pair>(fileSize);
        ExtensionRegistryLite extReg = ExtensionRegistryLite.newInstance();
        for (int i = 0; i < fileSize; ++i) {
            CodedInputStream fileStream = BasicIrModuleDeserializerKt.getCodedInputStream((byte[])$this$filesAndSigReaders.file(i));
            IrFile fileProto = IrFile.parseFrom((CodedInputStream)fileStream, (ExtensionRegistryLite)extReg);
            IdSignatureDeserializer sigReader2 = new IdSignatureDeserializer((IrLibraryFile)new IrLibraryFileFromBytes(new IrLibraryBytesSource($this$filesAndSigReaders, i){
                final /* synthetic */ KotlinLibrary $this_filesAndSigReaders;
                final /* synthetic */ int $i;
                {
                    this.$this_filesAndSigReaders = $receiver;
                    this.$i = $i;
                }

                private final Void err() {
                    throw new IllegalStateException("Not supported".toString());
                }

                @NotNull
                public byte[] irDeclaration(int index2) {
                    this.err();
                    throw null;
                }

                @NotNull
                public byte[] type(int index2) {
                    this.err();
                    throw null;
                }

                @NotNull
                public byte[] signature(int index2) {
                    return this.$this_filesAndSigReaders.signature(index2, this.$i);
                }

                @NotNull
                public byte[] string(int index2) {
                    return this.$this_filesAndSigReaders.string(index2, this.$i);
                }

                @NotNull
                public byte[] body(int index2) {
                    this.err();
                    throw null;
                }

                @Nullable
                public byte[] debugInfo(int index2) {
                    return null;
                }
            }), null);
            result2.add(TuplesKt.to((Object)fileProto.getFileEntry().getName(), (Object)sigReader2));
        }
        return result2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$Companion;", "", "()V", "binaryAstSuffix", "", "cacheFastInfoFile", "cacheFullInfoFile", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001B<\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tR%\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR%\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR%\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\rR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R%\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\r\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$CacheFastInfo;", "", "moduleName", "", "flatHash", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ICHash;", "transHash", "configHash", "initialFlatHash", "(Ljava/lang/String;JJJJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getConfigHash-Yd-dAqs", "()J", "setConfigHash-ycJ14Ss", "(J)V", "J", "getFlatHash-Yd-dAqs", "setFlatHash-ycJ14Ss", "getInitialFlatHash-Yd-dAqs", "setInitialFlatHash-ycJ14Ss", "getModuleName", "()Ljava/lang/String;", "setModuleName", "(Ljava/lang/String;)V", "getTransHash-Yd-dAqs", "setTransHash-ycJ14Ss", "backend.js"})
    public static final class CacheFastInfo {
        @Nullable
        private String moduleName;
        private long flatHash;
        private long transHash;
        private long configHash;
        private long initialFlatHash;

        private CacheFastInfo(String moduleName, long flatHash, long transHash, long configHash, long initialFlatHash) {
            this.moduleName = moduleName;
            this.flatHash = flatHash;
            this.transHash = transHash;
            this.configHash = configHash;
            this.initialFlatHash = initialFlatHash;
        }

        public /* synthetic */ CacheFastInfo(String string2, long l, long l2, long l3, long l4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                l = ICHash.constructor-impl$default(0L, 1, null);
            }
            if ((n & 4) != 0) {
                l2 = ICHash.constructor-impl$default(0L, 1, null);
            }
            if ((n & 8) != 0) {
                l3 = ICHash.constructor-impl$default(0L, 1, null);
            }
            if ((n & 0x10) != 0) {
                l4 = ICHash.constructor-impl$default(0L, 1, null);
            }
            this(string2, l, l2, l3, l4, null);
        }

        @Nullable
        public final String getModuleName() {
            return this.moduleName;
        }

        public final void setModuleName(@Nullable String string2) {
            this.moduleName = string2;
        }

        public final long getFlatHash-Yd-dAqs() {
            return this.flatHash;
        }

        public final void setFlatHash-ycJ14Ss(long l) {
            this.flatHash = l;
        }

        public final long getTransHash-Yd-dAqs() {
            return this.transHash;
        }

        public final void setTransHash-ycJ14Ss(long l) {
            this.transHash = l;
        }

        public final long getConfigHash-Yd-dAqs() {
            return this.configHash;
        }

        public final void setConfigHash-ycJ14Ss(long l) {
            this.configHash = l;
        }

        public final long getInitialFlatHash-Yd-dAqs() {
            return this.initialFlatHash;
        }

        public final void setInitialFlatHash-ycJ14Ss(long l) {
            this.initialFlatHash = l;
        }

        public /* synthetic */ CacheFastInfo(String moduleName, long flatHash, long transHash, long configHash, long initialFlatHash, DefaultConstructorMarker $constructor_marker) {
            this(moduleName, flatHash, transHash, configHash, initialFlatHash);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache$CacheState;", "", "(Ljava/lang/String;I)V", "NON_LOADED", "FETCHED_FOR_DEPENDENCY", "FETCHED_FULL", "backend.js"})
    private static final class CacheState
    extends Enum<CacheState> {
        public static final /* enum */ CacheState NON_LOADED = new CacheState();
        public static final /* enum */ CacheState FETCHED_FOR_DEPENDENCY = new CacheState();
        public static final /* enum */ CacheState FETCHED_FULL = new CacheState();
        private static final /* synthetic */ CacheState[] $VALUES;

        public static CacheState[] values() {
            return (CacheState[])$VALUES.clone();
        }

        public static CacheState valueOf(String value2) {
            return Enum.valueOf(CacheState.class, value2);
        }

        static {
            $VALUES = cacheStateArray = new CacheState[]{CacheState.NON_LOADED, CacheState.FETCHED_FOR_DEPENDENCY, CacheState.FETCHED_FULL};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CacheState.values().length];
            nArray[CacheState.FETCHED_FULL.ordinal()] = 1;
            nArray[CacheState.FETCHED_FOR_DEPENDENCY.ordinal()] = 2;
            nArray[CacheState.NON_LOADED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

