/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.lang.Language;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMethodReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyResolver;
import org.jetbrains.plugins.groovy.lang.resolve.ReceiverKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ConstructorsKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodReferenceProcessor;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/GrMethodReferenceResolver;", "Lorg/jetbrains/plugins/groovy/lang/resolve/GroovyResolver;", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/GrMethodReferenceExpressionImpl;", "()V", "fakeArrayConstructor", "Lcom/intellij/psi/impl/light/LightMethodBuilder;", "type", "Lcom/intellij/psi/PsiArrayType;", "manager", "Lcom/intellij/psi/PsiManager;", "dimensions", "", "fakeArrayConstructors", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "resolve", "", "ref", "incomplete", "", "(Lorg/jetbrains/plugins/groovy/lang/psi/impl/GrMethodReferenceExpressionImpl;Z)[Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "intellij.groovy.psi"})
public final class GrMethodReferenceResolver
implements GroovyResolver<GrMethodReferenceExpressionImpl> {
    @NotNull
    public static final GrMethodReferenceResolver INSTANCE;

    @Override
    @NotNull
    public GroovyResolveResult[] resolve(@NotNull GrMethodReferenceExpressionImpl ref, boolean incomplete) {
        List<GroovyResolveResult> list;
        GrMethodReferenceResolver grMethodReferenceResolver;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        String string = ref.getReferenceName();
        if (string == null) {
            Intrinsics.checkNotNullExpressionValue((Object)GroovyResolveResult.EMPTY_ARRAY, (String)"GroovyResolveResult.EMPTY_ARRAY");
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ref.referenceName ?: ret\u2026ResolveResult.EMPTY_ARRAY");
        String name = string;
        GrExpression grExpression = ref.getQualifier();
        if (grExpression == null || (grExpression = grExpression.getType()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)GroovyResolveResult.EMPTY_ARRAY, (String)"GroovyResolveResult.EMPTY_ARRAY");
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"ref.qualifier?.type ?: r\u2026ResolveResult.EMPTY_ARRAY");
        GrExpression type2 = grExpression;
        GrMethodReferenceResolver $this$run = grMethodReferenceResolver = this;
        boolean bl = false;
        MethodReferenceProcessor processor = new MethodReferenceProcessor(name);
        PsiScopeProcessor psiScopeProcessor = processor;
        ResolveState resolveState = ResolveState.initial();
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"ResolveState.initial()");
        ReceiverKt.processReceiverType((PsiType)type2, psiScopeProcessor, resolveState, ref);
        List<GroovyResolveResult> methods = processor.getResults();
        PsiType psiType = ResolveUtil.unwrapClassType((PsiType)type2);
        if (psiType == null) {
            Collection $this$toTypedArray$iv = methods;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            GroovyResolveResult[] groovyResolveResultArray = thisCollection$iv.toArray(new GroovyResolveResult[0]);
            if (groovyResolveResultArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return groovyResolveResultArray;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"unwrapClassType(type) ?:\u2026rn methods.toTypedArray()");
        PsiType unwrapped = psiType;
        if (Intrinsics.areEqual((Object)name, (Object)"new")) {
            PsiType $i$f$toTypedArray = unwrapped;
            if ($i$f$toTypedArray instanceof PsiClassType) {
                list = CollectionsKt.toList((Iterable)ConstructorsKt.getAllConstructorResults((PsiClassType)unwrapped, ref));
            } else if ($i$f$toTypedArray instanceof PsiArrayType) {
                PsiArrayType psiArrayType = (PsiArrayType)unwrapped;
                PsiManagerEx psiManagerEx = ref.getManager();
                Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"ref.manager");
                list = this.fakeArrayConstructors(psiArrayType, (PsiManager)psiManagerEx);
            } else {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        List<GroovyResolveResult> constructors = list;
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)methods, (Iterable)constructors);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        GroovyResolveResult[] groovyResolveResultArray = thisCollection$iv.toArray(new GroovyResolveResult[0]);
        if (groovyResolveResultArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return groovyResolveResultArray;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GroovyResolveResult> fakeArrayConstructors(PsiArrayType type2, PsiManager manager) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)type2.getArrayDimensions());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ElementResolveResult<PsiElement> elementResolveResult = new ElementResolveResult<PsiElement>((PsiElement)INSTANCE.fakeArrayConstructor(type2, manager, (int)i));
            collection.add(elementResolveResult);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final LightMethodBuilder fakeArrayConstructor(PsiArrayType type2, PsiManager manager, int dimensions) {
        LightMethodBuilder lightMethodBuilder;
        LightMethodBuilder $this$apply = lightMethodBuilder = new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "fake array constructor");
        boolean bl = false;
        $this$apply.setMethodReturnType((PsiType)type2);
        if (dimensions == 0) {
            $this$apply.addParameter("size", (PsiType)PsiType.INT);
        } else {
            int n = 0;
            int n2 = dimensions;
            if (n <= n2) {
                while (true) {
                    void i;
                    $this$apply.addParameter("size" + (int)i, (PsiType)PsiType.INT);
                    if (i == n2) break;
                    ++i;
                }
            }
        }
        return lightMethodBuilder;
    }

    private GrMethodReferenceResolver() {
    }

    static {
        GrMethodReferenceResolver grMethodReferenceResolver;
        INSTANCE = grMethodReferenceResolver = new GrMethodReferenceResolver();
    }
}

