/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.OrderUtil;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.WorkCounter;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.WorkList;

public final class DFAEngine<E> {
    private final Instruction[] myFlow;
    private final DfaInstance<E> myDfa;
    private final Semilattice<E> mySemilattice;
    private WorkCounter myCounter;

    public DFAEngine(Instruction @NotNull [] flow, @NotNull DfaInstance<E> dfa, @NotNull Semilattice<E> semilattice) {
        if (dfa == null) {
            DFAEngine.$$$reportNull$$$0(0);
        }
        if (semilattice == null) {
            DFAEngine.$$$reportNull$$$0(1);
        }
        if (flow == null) {
            DFAEngine.$$$reportNull$$$0(2);
        }
        this.myCounter = null;
        this.myFlow = flow;
        this.myDfa = dfa;
        this.mySemilattice = semilattice;
    }

    public @NotNull List<@Nullable E> performForceDFA() {
        List<E> result2 = this.performDFA(false);
        assert (result2 != null);
        List<E> list = result2;
        if (list == null) {
            DFAEngine.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public @Nullable List<@Nullable E> performDFAWithTimeout() {
        return this.performDFA(true);
    }

    @Nullable
    private @Nullable List<@Nullable E> performDFA(boolean timeout) {
        int n = this.myFlow.length;
        List<Optional<Optional<E>>> info = this.getEmptyInfo(n);
        MyCallEnvironment env = new MyCallEnvironment(n);
        WorkList workList = new WorkList(n, this.getFlowOrder());
        while (!workList.isEmpty()) {
            ProgressManager.checkCanceled();
            if (timeout && this.checkCounter()) {
                return null;
            }
            int num = workList.next();
            Instruction curr = this.myFlow[num];
            Optional<E> oldE = info.get(num);
            List<E> ins = this.getPrevInfos(curr, info, env);
            E jointE = this.mySemilattice.join(ins);
            E newE = this.myDfa.fun(jointE, curr);
            if (!oldE.isEmpty() && this.mySemilattice.eq(newE, oldE.get())) continue;
            info.set(num, Optional.of(newE));
            for (Instruction next : this.getNext(curr, env)) {
                workList.offer(next.num());
            }
        }
        return ContainerUtil.map(info, e -> e.orElse(null));
    }

    @NotNull
    private List<Optional<E>> getEmptyInfo(int n) {
        Object[] optionals = new Optional[n];
        Arrays.fill(optionals, Optional.empty());
        List<Object> list = Arrays.asList(optionals);
        if (list == null) {
            DFAEngine.$$$reportNull$$$0(4);
        }
        return list;
    }

    private int @NotNull [] getFlowOrder() {
        if (this.myDfa.isForward()) {
            int[] nArray = OrderUtil.reversedPostOrder(this.myFlow, this.myDfa.isReachable());
            if (nArray == null) {
                DFAEngine.$$$reportNull$$$0(5);
            }
            return nArray;
        }
        int[] nArray = OrderUtil.postOrder(this.myFlow, this.myDfa.isReachable());
        if (nArray == null) {
            DFAEngine.$$$reportNull$$$0(6);
        }
        return nArray;
    }

    @NotNull
    private List<E> getPrevInfos(@NotNull Instruction instruction, @NotNull List<Optional<E>> info, @NotNull CallEnvironment env) {
        if (instruction == null) {
            DFAEngine.$$$reportNull$$$0(7);
        }
        if (info == null) {
            DFAEngine.$$$reportNull$$$0(8);
        }
        if (env == null) {
            DFAEngine.$$$reportNull$$$0(9);
        }
        SmartList prevInfos = new SmartList();
        for (Instruction i : this.getPrevious(instruction, env)) {
            Optional<E> prevInfo = info.get(i.num());
            prevInfo.ifPresent(arg_0 -> DFAEngine.lambda$getPrevInfos$1((List)prevInfos, arg_0));
        }
        SmartList smartList = prevInfos;
        if (smartList == null) {
            DFAEngine.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    @NotNull
    private Iterable<Instruction> getPrevious(@NotNull Instruction instruction, @NotNull CallEnvironment env) {
        if (instruction == null) {
            DFAEngine.$$$reportNull$$$0(11);
        }
        if (env == null) {
            DFAEngine.$$$reportNull$$$0(12);
        }
        Iterable<Instruction> iterable = this.myDfa.isForward() ? instruction.predecessors(env) : instruction.successors(env);
        if (iterable == null) {
            DFAEngine.$$$reportNull$$$0(13);
        }
        return iterable;
    }

    @NotNull
    private Iterable<Instruction> getNext(@NotNull Instruction instruction, @NotNull CallEnvironment env) {
        if (instruction == null) {
            DFAEngine.$$$reportNull$$$0(14);
        }
        if (env == null) {
            DFAEngine.$$$reportNull$$$0(15);
        }
        Iterable<Instruction> iterable = this.myDfa.isForward() ? instruction.successors(env) : instruction.predecessors(env);
        if (iterable == null) {
            DFAEngine.$$$reportNull$$$0(16);
        }
        return iterable;
    }

    private boolean checkCounter() {
        if (this.myCounter == null) {
            this.myCounter = new WorkCounter();
            return false;
        }
        return this.myCounter.isTimeOver();
    }

    private static /* synthetic */ void lambda$getPrevInfos$1(List prevInfos, Object e) {
        prevInfos.add(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfa";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semilattice";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "performForceDFA";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowOrder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevInfos";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevious";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPrevInfos";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPrevious";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyCallEnvironment
    implements CallEnvironment {
        ArrayList<Deque<CallInstruction>> myEnv;

        private MyCallEnvironment(int instructionNum) {
            this.myEnv = new ArrayList(instructionNum);
            for (int i = 0; i < instructionNum; ++i) {
                this.myEnv.add(new ArrayDeque());
            }
        }

        @Override
        @NotNull
        public Deque<CallInstruction> callStack(@NotNull Instruction instruction) {
            if (instruction == null) {
                MyCallEnvironment.$$$reportNull$$$0(0);
            }
            Deque<CallInstruction> deque = this.myEnv.get(instruction.num());
            if (deque == null) {
                MyCallEnvironment.$$$reportNull$$$0(1);
            }
            return deque;
        }

        @Override
        public void update(@NotNull Deque<CallInstruction> callStack, @NotNull Instruction instruction) {
            if (callStack == null) {
                MyCallEnvironment.$$$reportNull$$$0(2);
            }
            if (instruction == null) {
                MyCallEnvironment.$$$reportNull$$$0(3);
            }
            this.myEnv.set(instruction.num(), callStack);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine$MyCallEnvironment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine$MyCallEnvironment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "callStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "callStack";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

