/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.style.InferMethodParametersTypesIntention;
import org.jetbrains.plugins.groovy.intentions.style.inference.DefaultInferenceContext;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceOptions;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.InferenceDriverUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/InferMethodParametersTypesIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/Intention;", "()V", "collectParameterSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "virtualMethod", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "getFamilyName", "", "getText", "isStopElement", "", "element", "Lcom/intellij/psi/PsiElement;", "processIntention", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "substituteMethodSignature", "sourceMethod", "sinkMethod", "intellij.groovy"})
public final class InferMethodParametersTypesIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GrMethod method = (GrMethod)element;
        SignatureInferenceOptions options2 = new SignatureInferenceOptions(false, DefaultInferenceContext.INSTANCE);
        GrMethod virtualMethod = InferenceProcessKt.runInferenceProcess(method, options2);
        this.substituteMethodSignature(virtualMethod, method);
    }

    /*
     * WARNING - void declaration
     */
    private final void substituteMethodSignature(GrMethod sourceMethod, GrMethod sinkMethod) {
        block19: {
            Object object;
            block21: {
                block20: {
                    PsiType psiType;
                    if (!sinkMethod.isConstructor() && !sinkMethod.getModifierList().hasModifierProperty("def")) {
                        sinkMethod.getModifierList().setModifierProperty("def", true);
                    }
                    if (sourceMethod.hasTypeParameters()) {
                        if (sinkMethod.hasTypeParameters()) {
                            PsiTypeParameterList psiTypeParameterList = sinkMethod.getTypeParameterList();
                            Intrinsics.checkNotNull((Object)psiTypeParameterList);
                            PsiTypeParameterList psiTypeParameterList2 = sourceMethod.getTypeParameterList();
                            Intrinsics.checkNotNull((Object)psiTypeParameterList2);
                            psiTypeParameterList.replace((PsiElement)psiTypeParameterList2);
                        } else if (sinkMethod.isConstructor()) {
                            PsiSubstitutor parameterSubstitutor = this.collectParameterSubstitutor(sourceMethod);
                            GrParameter[] grParameterArray = sourceMethod.getParameters();
                            Intrinsics.checkNotNullExpressionValue((Object)grParameterArray, (String)"sourceMethod.parameters");
                            GrParameter[] $this$forEach$iv = grParameterArray;
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int i = 0; i < n; ++i) {
                                GrParameter element$iv;
                                GrParameter it = element$iv = $this$forEach$iv[i];
                                boolean bl = false;
                                GrParameter grParameter = it;
                                Intrinsics.checkNotNullExpressionValue((Object)grParameter, (String)"it");
                                PsiType psiType2 = grParameter.getType();
                                Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"it.type");
                                it.setType(InferenceProcessUtilKt.recursiveSubstitute$default(parameterSubstitutor, psiType2, 0, 2, null));
                            }
                        } else {
                            PsiTypeParameterList psiTypeParameterList = sourceMethod.getTypeParameterList();
                            Intrinsics.checkNotNull((Object)psiTypeParameterList);
                            sinkMethod.addAfter((PsiElement)psiTypeParameterList, sinkMethod.getFirstChild());
                        }
                    }
                    Object[] objectArray = sinkMethod.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"sinkMethod.parameters");
                    Object[] objectArray2 = sourceMethod.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"sourceMethod.parameters");
                    for (PsiSubstitutor parameterSubstitutor : ArraysKt.zip((Object[])objectArray, (Object[])objectArray2)) {
                        PsiAnnotation[] $this$forEach$iv;
                        void $this$mapTo$iv$iv;
                        PsiAnnotation[] $this$map$iv;
                        void actual;
                        GrParameter inferred;
                        GrParameter $i$f$forEach = (GrParameter)parameterSubstitutor.component1();
                        GrParameter grParameter = inferred = (GrParameter)parameterSubstitutor.component2();
                        Intrinsics.checkNotNullExpressionValue((Object)grParameter, (String)"inferred");
                        actual.setType(grParameter.getType());
                        void v9 = actual;
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"actual");
                        v9.getModifierList().setModifierProperty("def", false);
                        if (actual.isVarArgs()) {
                            PsiElement psiElement = actual.getEllipsisDots();
                            Intrinsics.checkNotNull((Object)psiElement);
                            psiElement.delete();
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)actual.getAnnotations(), (String)"actual.annotations");
                        boolean $i$f$map = false;
                        PsiAnnotation[] bl = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        int n = ((void)$this$mapTo$iv$iv).length;
                        for (int i = 0; i < n; ++i) {
                            void it;
                            void item$iv$iv;
                            void var16_29 = item$iv$iv = $this$mapTo$iv$iv[i];
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            void v11 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"it");
                            String string = v11.getText();
                            collection.add(string);
                        }
                        List currentAnnotations = (List)destination$iv$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)inferred.getAnnotations(), (String)"inferred.annotations");
                        boolean $i$f$forEach2 = false;
                        int n2 = $this$forEach$iv.length;
                        for (int i = 0; i < n2; ++i) {
                            PsiAnnotation anno;
                            String string;
                            PsiAnnotation element$iv;
                            PsiAnnotation it = element$iv = $this$forEach$iv[i];
                            boolean bl3 = false;
                            PsiAnnotation psiAnnotation = it;
                            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"it");
                            if (currentAnnotations.contains(psiAnnotation.getText())) continue;
                            GrModifierList grModifierList = actual.getModifierList();
                            Intrinsics.checkNotNullExpressionValue((Object)it.getText(), (String)"it.text");
                            int n3 = 1;
                            String string2 = string.substring(n3);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                            Intrinsics.checkNotNullExpressionValue((Object)grModifierList.addAnnotation(string2), (String)"actual.modifierList.addA\u2026ion(it.text.substring(1))");
                            PsiAnnotation psiAnnotation2 = anno;
                            if (psiAnnotation2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation");
                            }
                            PsiElement psiElement = ((GrAnnotation)psiAnnotation2).getOriginalElement();
                            if (psiElement == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement");
                            }
                            GrReferenceAdjuster.shortenAllReferencesIn((GroovyPsiElement)psiElement);
                            PsiAnnotationMemberValue psiAnnotationMemberValue = anno.findAttributeValue("value");
                            Object object2 = psiAnnotationMemberValue != null ? psiAnnotationMemberValue.getReference() : null;
                            if (!(object2 instanceof GrQualifiedReference)) {
                                object2 = null;
                            }
                            GrQualifiedReference grQualifiedReference = (GrQualifiedReference)object2;
                            if (grQualifiedReference == null) {
                                continue;
                            }
                            GrReferenceAdjuster.shortenReference(grQualifiedReference);
                        }
                    }
                    PsiTypeParameter[] psiTypeParameterArray = sinkMethod.getTypeParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"sinkMethod.typeParameters");
                    PsiTypeParameter[] $this$forEach$iv = psiTypeParameterArray;
                    boolean $i$f$forEach = false;
                    int inferred = $this$forEach$iv.length;
                    for (int actual = 0; actual < inferred; ++actual) {
                        PsiTypeParameter element$iv;
                        PsiTypeParameter it = element$iv = $this$forEach$iv[actual];
                        boolean bl = false;
                        PsiTypeParameter psiTypeParameter = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameter, (String)"it");
                        GrReferenceAdjuster.shortenAllReferencesIn((GroovyPsiElement)psiTypeParameter.getOriginalElement());
                    }
                    if (sinkMethod.isConstructor() || sinkMethod.getReturnTypeElement() != null) break block19;
                    object = sinkMethod.getInferredReturnType();
                    if (object == null) break block20;
                    PsiType it = psiType = object;
                    boolean bl = false;
                    object = Intrinsics.areEqual((Object)it, (Object)PsiType.NULL) ^ true ? psiType : null;
                    if (object != null) break block21;
                }
                object = (PsiType)InferenceDriverUtilKt.getJavaLangObject(sinkMethod);
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sinkMethod.inferredRetur\u2026avaLangObject(sinkMethod)");
            PsiType returnType2 = object;
            GrReferenceAdjuster.shortenAllReferencesIn(sinkMethod.setReturnType(returnType2));
        }
        sinkMethod.getModifierList().setModifierProperty("def", false);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiSubstitutor collectParameterSubstitutor(GrMethod virtualMethod) {
        void $this$mapTo$iv$iv;
        PsiTypeParameter[] psiTypeParameterArray = virtualMethod.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"virtualMethod.typeParameters");
        PsiTypeParameter[] $this$map$iv = psiTypeParameterArray;
        boolean $i$f$map = false;
        PsiTypeParameter[] psiTypeParameterArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            Object[] objectArray = v1.getExtendsListTypes();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"it.extendsListTypes");
            PsiClassType psiClassType = (PsiClassType)ArraysKt.firstOrNull((Object[])objectArray);
            if (psiClassType == null) {
                psiClassType = InferenceDriverUtilKt.getJavaLangObject(virtualMethod);
            }
            PsiClassType psiClassType2 = psiClassType;
            collection.add(psiClassType2);
        }
        List parameterTypes = (List)destination$iv$iv;
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"PsiSubstitutor.EMPTY");
        PsiTypeParameter[] psiTypeParameterArray3 = virtualMethod.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray3, (String)"virtualMethod.typeParameters");
        Collection $this$toTypedArray$iv = parameterTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiClassType[] psiClassTypeArray = thisCollection$iv.toArray(new PsiClassType[0]);
        if (psiClassTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return InferenceKt.putAll(psiSubstitutor, psiTypeParameterArray3, (PsiType[])psiClassTypeArray);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return getElementPredicate.1.INSTANCE;
    }

    @Override
    protected boolean isStopElement(@Nullable PsiElement element) {
        return element instanceof GrOpenBlock || element instanceof GrMethod || super.isStopElement(element);
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("infer.method.parameters.types", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"in\u2026method.parameters.types\")");
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("infer.method.parameters.types.for.method.declaration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"in\u2026.for.method.declaration\")");
        return string;
    }
}

