/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.settingsSync.CloudConfigServerCommunicator;
import com.intellij.settingsSync.GitSettingsLog;
import com.intellij.settingsSync.LocalDirSettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.ServerState;
import com.intellij.settingsSync.SettingsSyncBridge;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncIdeMediator;
import com.intellij.settingsSync.SettingsSyncIdeMediatorImpl;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncUpdateChecker;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\nH\u0016J\r\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\r\u0010\u000f\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain;", "Lcom/intellij/openapi/Disposable;", "()V", "componentStore", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "controls", "Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "getControls$intellij_settingsSync", "()Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "disableSyncing", "", "dispose", "getRemoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "getRemoteCommunicator$intellij_settingsSync", "syncSettings", "syncSettings$intellij_settingsSync", "Companion", "SettingsSyncControls", "intellij.settingsSync"})
public final class SettingsSyncMain
implements Disposable {
    @NotNull
    private final SettingsSyncControls controls;
    private final ComponentStoreImpl componentStore;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final SettingsSyncControls getControls$intellij_settingsSync() {
        return this.controls;
    }

    public void dispose() {
    }

    @NotNull
    public final SettingsSyncRemoteCommunicator getRemoteCommunicator$intellij_settingsSync() {
        return this.controls.getRemoteCommunicator();
    }

    @RequiresBackgroundThread
    public final void syncSettings$intellij_settingsSync() {
        ServerState serverState = this.controls.getRemoteCommunicator().checkServerState();
        if (serverState instanceof ServerState.UpdateNeeded) {
            LOG.info("Updating from server");
            this.controls.getUpdateChecker().scheduleUpdateFromServer();
        } else if (Intrinsics.areEqual((Object)serverState, (Object)ServerState.FileNotExists.INSTANCE)) {
            LOG.info("No file on server, we must push");
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(SyncSettingsEvent.MustPushRequest.INSTANCE);
        } else if (Intrinsics.areEqual((Object)serverState, (Object)ServerState.UpToDate.INSTANCE)) {
            LOG.info("Updating settings is not needed, will check if push is needed");
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(SyncSettingsEvent.PushIfNeededRequest.INSTANCE);
        } else if (!(serverState instanceof ServerState.Error)) {
            // empty if block
        }
    }

    public final void disableSyncing() {
        this.controls.getIdeMediator().removeStreamProvider();
    }

    public SettingsSyncMain() {
        SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator;
        Application application = ApplicationManager.getApplication();
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PathManager.getConfigDir()");
        Path appConfigPath = path;
        Path settingsSyncStorage = appConfigPath.resolve("settingsSync");
        if (System.getProperty("idea.settings.sync.local.server.path") != null) {
            Path path2 = settingsSyncStorage;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"settingsSyncStorage");
            settingsSyncRemoteCommunicator = new LocalDirSettingsSyncRemoteCommunicator(path2);
        } else {
            settingsSyncRemoteCommunicator = new CloudConfigServerCommunicator();
        }
        SettingsSyncRemoteCommunicator remoteCommunicator = settingsSyncRemoteCommunicator;
        Application application2 = application;
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"application");
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application2));
        if (iComponentStore == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        this.componentStore = (ComponentStoreImpl)iComponentStore;
        SettingsSyncIdeMediatorImpl ideMediator2 = new SettingsSyncIdeMediatorImpl(this.componentStore, appConfigPath, (Function0<Boolean>)((Function0)ideMediator.1.INSTANCE));
        Disposable disposable = this;
        Path path3 = settingsSyncStorage;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"settingsSyncStorage");
        this.controls = Companion.init$intellij_settingsSync(application, disposable, path3, appConfigPath, remoteCommunicator, ideMediator2);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncMain.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "", "ideMediator", "Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "updateChecker", "Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "bridge", "Lcom/intellij/settingsSync/SettingsSyncBridge;", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "settingsSyncStorage", "Ljava/nio/file/Path;", "(Lcom/intellij/settingsSync/SettingsSyncIdeMediator;Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;Lcom/intellij/settingsSync/SettingsSyncBridge;Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;Ljava/nio/file/Path;)V", "getBridge", "()Lcom/intellij/settingsSync/SettingsSyncBridge;", "getIdeMediator", "()Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "getRemoteCommunicator", "()Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "getSettingsSyncStorage", "()Ljava/nio/file/Path;", "getUpdateChecker", "()Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "intellij.settingsSync"})
    public static final class SettingsSyncControls {
        @NotNull
        private final SettingsSyncIdeMediator ideMediator;
        @NotNull
        private final SettingsSyncUpdateChecker updateChecker;
        @NotNull
        private final SettingsSyncBridge bridge;
        @NotNull
        private final SettingsSyncRemoteCommunicator remoteCommunicator;
        @NotNull
        private final Path settingsSyncStorage;

        @NotNull
        public final SettingsSyncIdeMediator getIdeMediator() {
            return this.ideMediator;
        }

        @NotNull
        public final SettingsSyncUpdateChecker getUpdateChecker() {
            return this.updateChecker;
        }

        @NotNull
        public final SettingsSyncBridge getBridge() {
            return this.bridge;
        }

        @NotNull
        public final SettingsSyncRemoteCommunicator getRemoteCommunicator() {
            return this.remoteCommunicator;
        }

        @NotNull
        public final Path getSettingsSyncStorage() {
            return this.settingsSyncStorage;
        }

        public SettingsSyncControls(@NotNull SettingsSyncIdeMediator ideMediator2, @NotNull SettingsSyncUpdateChecker updateChecker, @NotNull SettingsSyncBridge bridge, @NotNull SettingsSyncRemoteCommunicator remoteCommunicator, @NotNull Path settingsSyncStorage) {
            Intrinsics.checkNotNullParameter((Object)ideMediator2, (String)"ideMediator");
            Intrinsics.checkNotNullParameter((Object)updateChecker, (String)"updateChecker");
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
            Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
            this.ideMediator = ideMediator2;
            this.updateChecker = updateChecker;
            this.bridge = bridge;
            this.remoteCommunicator = remoteCommunicator;
            this.settingsSyncStorage = settingsSyncStorage;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J=\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0017R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/settingsSync/SettingsSyncMain;", "init", "Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "application", "Lcom/intellij/openapi/application/Application;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "settingsSyncStorage", "Ljava/nio/file/Path;", "appConfigPath", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "ideMediator", "Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "init$intellij_settingsSync", "isAvailable", "", "intellij.settingsSync"})
    public static final class Companion {
        public final boolean isAvailable() {
            return ApplicationManager.getApplication().getServiceIfCreated(SettingsSyncMain.class) != null;
        }

        @NotNull
        public final SettingsSyncMain getInstance() {
            Object object = ApplicationManager.getApplication().getService(SettingsSyncMain.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026ingsSyncMain::class.java)");
            return (SettingsSyncMain)object;
        }

        @NotNull
        public final SettingsSyncControls init$intellij_settingsSync(@NotNull Application application, @NotNull Disposable parentDisposable, @NotNull Path settingsSyncStorage, @NotNull Path appConfigPath, @NotNull SettingsSyncRemoteCommunicator remoteCommunicator, @NotNull SettingsSyncIdeMediator ideMediator2) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
            Intrinsics.checkNotNullParameter((Object)appConfigPath, (String)"appConfigPath");
            Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
            Intrinsics.checkNotNullParameter((Object)ideMediator2, (String)"ideMediator");
            GitSettingsLog settingsLog = new GitSettingsLog(settingsSyncStorage, appConfigPath, parentDisposable, ideMediator2.collectFilesToExportFromSettings(appConfigPath));
            SettingsSyncUpdateChecker updateChecker = new SettingsSyncUpdateChecker(application, remoteCommunicator);
            SettingsSyncBridge bridge = new SettingsSyncBridge(parentDisposable, settingsLog, ideMediator2, remoteCommunicator, updateChecker);
            return new SettingsSyncControls(ideMediator2, updateChecker, bridge, remoteCommunicator, settingsSyncStorage);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

