/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TransportableAIObject;

public class Cargo {
    private static final Logger logger = Logger.getLogger(Cargo.class.getName());
    private static final int MAX_TRY = 3;
    private TransportableAIObject transportable;
    private Unit carrier;
    private int tries;
    private int spaceLeft;
    private List<Cargo> wrapped;
    private CargoPlan plan;
    private static final String CDST_TAG = "cdst";
    private static final String CWAIT_TAG = "cwait";
    private static final String CARRIER_TAG = "carrier";
    private static final String FALLBACK_TAG = "fallback";
    private static final String MODE_TAG = "mode";
    private static final String SPACELEFT_TAG = "space";
    private static final String TDST_TAG = "tdst";
    private static final String TRIES_TAG = "tries";
    private static final String TURNS_TAG = "turns";
    private static final String TWAIT_TAG = "twait";

    private Cargo(TransportableAIObject transportable, Unit carrier, CargoPlan plan) {
        this.transportable = transportable;
        this.carrier = carrier;
        this.tries = 0;
        this.spaceLeft = carrier.getSpaceLeft();
        this.wrapped = null;
        this.plan = plan;
    }

    public Cargo(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(aiMain, xr);
    }

    private String initialize(Location destination, boolean allowFallback) {
        return this.plan.initialize(this.transportable, this.carrier, destination, allowFallback);
    }

    public String update() {
        return this.plan.initialize(this.transportable, this.carrier, null, this.plan.fallback);
    }

    public static Cargo newCargo(TransportableAIObject t, Unit carrier) throws FreeColException {
        return Cargo.newCargo(t, carrier, t.getTransportDestination(), true);
    }

    public static Cargo newCargo(TransportableAIObject t, Unit carrier, Location destination, boolean allowFallback) throws FreeColException {
        Cargo cargo = new Cargo(t, carrier, new CargoPlan());
        String reason = cargo.plan.initialize(t, carrier, destination, allowFallback);
        if (reason != null) {
            throw new FreeColException(reason);
        }
        return cargo;
    }

    public String dump() {
        if (!this.isCarried()) {
            return "not-carried";
        }
        PathNode path = this.carrier.getTrivialPath();
        if (path == null) {
            return "no-trivial-path";
        }
        String reason = this.initialize(path.getLastNode().getLocation(), false);
        if (reason != null) {
            return reason;
        }
        this.plan.mode = CargoMode.DUMP;
        return null;
    }

    public TransportableAIObject getTransportable() {
        return this.transportable;
    }

    public Unit getCarrier() {
        return this.carrier;
    }

    public int getTries() {
        return this.tries;
    }

    public int getSpaceLeft() {
        return this.spaceLeft;
    }

    public void setSpaceLeft(int spaceLeft) {
        this.spaceLeft = spaceLeft;
    }

    public boolean isValid() {
        return this.plan != null && this.plan.mode != null;
    }

    public CargoMode getMode() {
        return this.plan.mode;
    }

    public String getModeString() {
        CargoMode mode = this.getMode();
        return mode == null ? "null" : mode.toString().toLowerCase(Locale.US);
    }

    public int getTurns() {
        return this.plan.turns;
    }

    public boolean isFallback() {
        return this.plan.fallback;
    }

    public Location getTransportTarget() {
        return this.getMode().isCollection() ? this.plan.twait : this.plan.tdst;
    }

    public Location getCarrierTarget() {
        return this.getMode().isCollection() ? this.plan.cwait : this.plan.cdst;
    }

    public void clear() {
        this.transportable = null;
        this.carrier = null;
        this.plan.mode = null;
    }

    public boolean isCarried() {
        return this.transportable != null && this.transportable.getLocation() == this.carrier;
    }

    public boolean isCollectable() {
        if (!this.getMode().isCollection() || this.isCarried()) {
            return false;
        }
        return Map.isSameLocation(this.plan.twait, this.transportable.getLocation()) && Map.isSameLocation(this.plan.cwait, this.carrier.getLocation());
    }

    public boolean isDeliverable() {
        if (this.getMode().isCollection() || !this.isCarried()) {
            return false;
        }
        return Map.isSameLocation(this.plan.cdst, this.carrier.getLocation());
    }

    public boolean isDelivered() {
        return !this.getMode().isCollection() && !this.isCarried();
    }

    public boolean hasPath() {
        return this.carrier.findPath(this.getCarrierTarget()) != null;
    }

    public Direction getJoinDirection() {
        return this.carrier.isInEurope() || this.plan.cwait == this.plan.twait ? null : this.carrier.getGame().getMap().getDirection(this.plan.twait.getTile(), this.plan.cwait.getTile());
    }

    public Direction getLeaveDirection() {
        if (!this.carrier.hasTile() || this.plan.cdst == this.plan.tdst) {
            return null;
        }
        TransportableAIObject t = this.getTransportable();
        PathNode path = t.getDeliveryPath(this.getCarrier(), this.plan.tdst);
        return path == null || path.next == null ? null : path.next.getDirection();
    }

    public int getNewSpace() {
        if (!this.isValid()) {
            return 0;
        }
        int ret = 0;
        ret += this.getMode().isCollection() ? this.getTransportable().getSpaceTaken() : -this.getTransportable().getSpaceTaken();
        if (this.hasWrapped()) {
            ret += this.wrapped.stream().mapToInt(c -> c.getNewSpace()).sum();
        }
        return ret;
    }

    public boolean hasWrapped() {
        return this.wrapped != null;
    }

    public boolean couldWrap(Cargo other) {
        return this.getCarrierTarget() == other.getCarrierTarget() && this.getNewSpace() < 0 && other.getNewSpace() < 0;
    }

    public void wrap(Cargo other) {
        if (other == this) {
            throw new IllegalStateException("Autowrap at" + this);
        }
        if (this.wrapped == null) {
            this.wrapped = new ArrayList<Cargo>();
        }
        this.wrapped.add(other);
    }

    public List<Cargo> unwrap() {
        if (this.wrapped == null) {
            throw new IllegalStateException("Bogus unwrap " + this);
        }
        List<Cargo> result = this.wrapped;
        this.wrapped = null;
        return result;
    }

    public boolean retry() {
        return this.tries++ < 3;
    }

    public void resetTries() {
        this.tries = 0;
    }

    public boolean isEuropeanTrade(GoodsType type) {
        return this.transportable instanceof AIGoods && ((AIGoods)this.transportable).getGoodsType() == type && this.getCarrierTarget() instanceof Europe;
    }

    public String check(AIUnit aiCarrier) {
        if (this.transportable == null) {
            return "null transportable";
        }
        if (this.transportable.isDisposed()) {
            return "disposed transportable";
        }
        Locatable l = this.transportable.getTransportLocatable();
        if (l == null) {
            return "null locatable: " + this.transportable;
        }
        if (l instanceof FreeColGameObject && ((FreeColGameObject)((Object)l)).isDisposed()) {
            return "locatable disposed";
        }
        Location tLoc = l.getLocation();
        if (tLoc instanceof Unit && tLoc != this.carrier) {
            return "carrier usurped";
        }
        return null;
    }

    public boolean canQueueAt(Unit carrier, int index, List<Cargo> cargoes) {
        int maxHolds = carrier.getCargoCapacity();
        int newSpace = this.getNewSpace();
        Cargo tr = cargoes.get(index);
        for (int j = index; j < cargoes.size(); ++j) {
            int holds;
            int n = holds = j == 0 ? carrier.getCargoSpaceTaken() : maxHolds - cargoes.get(j - 1).getSpaceLeft();
            if ((holds += newSpace) >= 0 && holds <= maxHolds) continue;
            return false;
        }
        return true;
    }

    public String toShortString() {
        LogBuilder lb = new LogBuilder(32);
        lb.add(this.getModeString(), " ", this.transportable);
        Location lt = this.getTransportTarget();
        lb.add(" @ ", lt == null ? "null" : lt.toShortString());
        Location ct = this.getCarrierTarget();
        if (ct != lt) {
            lb.add("/", ct.toShortString());
        }
        return lb.toString();
    }

    public String toString() {
        LogBuilder lb = new LogBuilder(64);
        lb.add("[", this.transportable, " ", this.getModeString(), " ", this.getTurns(), "/", this.tries, " space=", this.spaceLeft, this.wrapped == null ? "" : " wrap");
        if (this.plan.twait != null && this.plan.cwait != null) {
            lb.add(" ", this.plan.twait.toShortString(), "/", this.plan.cwait.toShortString());
        }
        if (this.plan.cdst != null && this.plan.tdst != null) {
            lb.add("->", this.plan.cdst.toShortString(), "/", this.plan.tdst.toShortString());
        }
        lb.add(" ", this.plan.fallback, "]");
        return lb.toString();
    }

    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        xw.writeStartElement(Cargo.getXMLElementTagName());
        xw.writeAttribute("id", this.getTransportable());
        xw.writeAttribute(CARRIER_TAG, this.getCarrier());
        xw.writeAttribute(TRIES_TAG, this.getTries());
        xw.writeAttribute(SPACELEFT_TAG, this.getSpaceLeft());
        if (this.plan.twait != null) {
            xw.writeLocationAttribute(TWAIT_TAG, this.plan.twait);
        }
        if (this.plan.cwait != null) {
            xw.writeLocationAttribute(CWAIT_TAG, this.plan.cwait);
        }
        if (this.plan.cdst != null) {
            xw.writeLocationAttribute(CDST_TAG, this.plan.cdst);
        }
        if (this.plan.tdst != null) {
            xw.writeLocationAttribute(TDST_TAG, this.plan.tdst);
        }
        xw.writeAttribute(TURNS_TAG, this.plan.turns);
        xw.writeAttribute(MODE_TAG, this.plan.mode);
        xw.writeAttribute(FALLBACK_TAG, this.plan.fallback);
        xw.writeEndElement();
    }

    public void readFromXML(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        Game game = aiMain.getGame();
        String tid = xr.readId();
        TransportableAIObject tao = null;
        if (tid != null) {
            AIObject aio = aiMain.getAIObject(tid);
            if (aio == null) {
                if (tid.startsWith(Unit.getXMLElementTagName())) {
                    tao = new AIUnit(aiMain, tid);
                } else if (tid.startsWith(AIGoods.getXMLElementTagName())) {
                    tao = new AIGoods(aiMain, tid);
                }
            } else {
                tao = (TransportableAIObject)aio;
            }
        }
        if (tao == null) {
            throw new XMLStreamException("Transportable expected: " + tid);
        }
        this.transportable = tao;
        this.carrier = xr.getAttribute(game, CARRIER_TAG, Unit.class, (Unit)null);
        this.tries = xr.getAttribute(TRIES_TAG, 0);
        this.spaceLeft = xr.getAttribute(SPACELEFT_TAG, -1);
        this.wrapped = null;
        this.plan = new CargoPlan();
        this.plan.twait = xr.getLocationAttribute(game, TWAIT_TAG, false);
        this.plan.cwait = xr.getLocationAttribute(game, CWAIT_TAG, false);
        this.plan.cdst = xr.getLocationAttribute(game, CDST_TAG, false);
        this.plan.tdst = xr.getLocationAttribute(game, TDST_TAG, false);
        this.plan.turns = xr.getAttribute(TURNS_TAG, -1);
        this.plan.mode = xr.getAttribute(MODE_TAG, CargoMode.class, null);
        this.plan.fallback = xr.getAttribute(FALLBACK_TAG, false);
        xr.closeTag(Cargo.getXMLElementTagName());
    }

    public static String getXMLElementTagName() {
        return "cargo";
    }

    public static class CargoPlan {
        public Location twait;
        public Location cwait;
        public Location cdst;
        public Location tdst;
        public int turns;
        public CargoMode mode;
        public boolean fallback;

        public String initialize(TransportableAIObject t, Unit carrier, Location destination, boolean allowFallback) {
            boolean carrying;
            if (t.isDisposed()) {
                return "invalid-disposed";
            }
            if (carrier == null) {
                return "invalid-null-carrier";
            }
            if (destination == null && (destination = t.getTransportDestination()) == null) {
                return "invalid-null-destination";
            }
            this.tdst = Location.upLoc(destination);
            Location src = t.getLocation();
            boolean bl = carrying = src == carrier;
            if (!carrying && src instanceof Unit) {
                return "invalid-collected-elsewhere";
            }
            PathNode deliver = t.getDeliveryPath(carrier, this.tdst);
            this.fallback = false;
            if (deliver == null && allowFallback) {
                deliver = t.getIntermediatePath(carrier, this.tdst);
                this.fallback = true;
            }
            if (deliver == null) {
                return "no-deliver " + t + "/" + carrier.toShortString() + " -> " + this.tdst.toShortString();
            }
            PathNode pick = deliver.getCarrierMove();
            if (pick == null) {
                return "invalid-transport-not-needed";
            }
            if (carrying) {
                this.cwait = null;
                this.twait = null;
            } else {
                this.cwait = Location.upLoc(pick.getLocation());
                PathNode prev = pick.previous == null ? pick : pick.previous;
                this.twait = Location.upLoc(prev.getLocation());
            }
            PathNode collect = null;
            if (!carrying && (collect = carrier.findPath(this.cwait)) == null) {
                return "no-collect " + t + "/" + carrier.toShortString() + " at " + this.cwait.toShortString();
            }
            PathNode drop = pick.getTransportDropNode();
            if (drop == null || drop.previous == null) {
                throw new IllegalStateException("Cargo failure " + t + " " + deliver.fullPathToString() + " " + pick.fullPathToString() + " " + drop);
            }
            this.cdst = Location.upLoc(drop.previous.getLocation());
            this.tdst = Location.upLoc(deliver.getLastNode().getLocation());
            if (carrying) {
                this.turns = deliver.getTotalTurns();
                this.mode = this.cdst instanceof Europe || this.cdst == this.tdst ? CargoMode.UNLOAD : CargoMode.DROPOFF;
            } else {
                this.turns = Math.max(pick.getTurns(), collect.getTotalTurns()) + pick.getTotalTurns();
                this.mode = this.cwait instanceof Europe || this.cwait == this.twait ? CargoMode.LOAD : CargoMode.PICKUP;
            }
            return null;
        }
    }

    public static enum CargoMode {
        LOAD,
        UNLOAD,
        PICKUP,
        DROPOFF,
        DUMP;


        public boolean isCollection() {
            return this == LOAD || this == PICKUP;
        }
    }
}

