/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.app.ClientAppManager;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.update.UpdateManager;
import net.i2p.update.UpdateType;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

public class Blocklist {
    private final Log _log;
    private final RouterContext _context;
    private long[] _blocklist;
    private int _blocklistSize;
    private long[] _countryBlocklist;
    private int _countryBlocklistSize;
    private final Object _lock = new Object();
    private Entry _wrapSave;
    private final Set<Hash> _inProcess = new HashSet<Hash>(4);
    private final File _blocklistFeedFile;
    private boolean _started;
    private final Map<Hash, String> _peerBlocklist = new HashMap<Hash, String>(4);
    private static final String PROP_BLOCKLIST_ENABLED = "router.blocklist.enable";
    private static final String PROP_BLOCKLIST_DETAIL = "router.blocklist.detail";
    private static final String PROP_BLOCKLIST_FILE = "router.blocklist.file";
    public static final String BLOCKLIST_FILE_DEFAULT = "blocklist.txt";
    private static final String BLOCKLIST_FEED_FILE = "docs/feed/blocklist/blocklist.txt";
    public static final String BLOCKLIST_COUNTRY_FILE = "blocklist-country.txt";
    private static final int MAX_IPV4_SINGLES = 8192;
    private static final int MAX_IPV6_SINGLES = 4096;
    private final Set<Integer> _singleIPBlocklist = new ConcurrentHashSet<Integer>(4);
    private final Map<BigInteger, Object> _singleIPv6Blocklist = new LHMCache<BigInteger, Object>(4096);
    private static final Object DUMMY = 0;
    public static final String ID_FEED = "feed";
    private static final String ID_SYSTEM = "system";
    private static final String ID_LOCAL = "local";
    private static final String ID_COUNTRY = "country";
    private static final String ID_USER = "user";
    public static final String ID_SYBIL = "sybil";

    public Blocklist(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(Blocklist.class);
        this._blocklistFeedFile = new File(context.getConfigDir(), BLOCKLIST_FEED_FILE);
    }

    private Blocklist() {
        this._context = null;
        this._log = new Log(Blocklist.class);
        this._blocklistFeedFile = new File(BLOCKLIST_FEED_FILE);
    }

    public synchronized void startup() {
        if (this._started) {
            return;
        }
        this._started = true;
        if (!this._context.getBooleanPropertyDefaultTrue(PROP_BLOCKLIST_ENABLED)) {
            return;
        }
        ArrayList<BLFile> files = new ArrayList<BLFile>(5);
        File blFile = new File(this._context.getBaseDir(), BLOCKLIST_FILE_DEFAULT);
        files.add(new BLFile(blFile, ID_SYSTEM));
        if (!this._context.getConfigDir().equals(this._context.getBaseDir())) {
            blFile = new File(this._context.getConfigDir(), BLOCKLIST_FILE_DEFAULT);
            files.add(new BLFile(blFile, ID_LOCAL));
        }
        files.add(new BLFile(this._blocklistFeedFile, ID_FEED));
        blFile = new File(this._context.getConfigDir(), BLOCKLIST_COUNTRY_FILE);
        files.add(new BLFile(blFile, ID_COUNTRY));
        String file = this._context.getProperty(PROP_BLOCKLIST_FILE);
        if (file != null && !file.equals(BLOCKLIST_FILE_DEFAULT)) {
            blFile = new File(file);
            if (!blFile.isAbsolute()) {
                blFile = new File(this._context.getConfigDir(), file);
            }
            files.add(new BLFile(blFile, ID_USER));
        }
        ReadinJob job = new ReadinJob(files);
        this._context.jobQueue().addJob(job);
    }

    public synchronized void addCountryFile() {
        UpdateManager umgr;
        File blFile = new File(this._context.getConfigDir(), BLOCKLIST_COUNTRY_FILE);
        BLFile blf = new BLFile(blFile, ID_COUNTRY);
        List<BLFile> c = Collections.singletonList(blf);
        long[] cb = this.allocate(c);
        if (cb == null) {
            return;
        }
        int count = this.readBlocklistFile(blf, cb, 0);
        if (count <= 0) {
            return;
        }
        ClientAppManager cmgr = this._context.clientAppManager();
        if (cmgr != null && (umgr = (UpdateManager)((Object)cmgr.getRegisteredApp("update"))) != null) {
            umgr.notifyInstalled(UpdateType.BLOCKLIST, ID_COUNTRY, Long.toString(blFile.lastModified()));
        }
        this._countryBlocklistSize = count = this.merge(cb, count);
        this._countryBlocklist = cb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Object object = this._lock;
        synchronized (object) {
            this._blocklistSize = 0;
            this._blocklist = null;
        }
    }

    private long[] allocate(List<BLFile> files) {
        int maxSize = 0;
        for (BLFile blf : files) {
            maxSize += this.getSize(blf.file);
        }
        try {
            return new long[maxSize + files.size()];
        }
        catch (OutOfMemoryError oom) {
            this._log.log(50, "OOM creating the blocklist");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readBlocklistFile(BLFile blf, long[] blocklist, int count) {
        int read;
        File blFile = blf.file;
        if (blFile == null || !blFile.exists() || blFile.length() <= 0L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Blocklist file not found: " + blFile);
            }
            return count;
        }
        long start = this._context.clock().now();
        int oldcount = count;
        int badcount = 0;
        int peercount = 0;
        int feedcount = 0;
        long ipcount = 0L;
        boolean isFeedFile = blFile.equals(this._blocklistFeedFile);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(blFile), "UTF-8"));
            String buf = null;
            while ((buf = br.readLine()) != null) {
                Entry e = this.parse(buf, true);
                if (e == null) {
                    ++badcount;
                    continue;
                }
                if (e.peer != null) {
                    this._peerBlocklist.put(e.peer, e.comment);
                    ++peercount;
                    continue;
                }
                byte[] ip1 = e.ip1;
                if (ip1.length == 4) {
                    if (isFeedFile) {
                        this.add(ip1);
                        ++feedcount;
                        continue;
                    }
                    byte[] ip2 = e.ip2;
                    Blocklist.store(ip1, ip2, blocklist, count++);
                    ipcount += (long)(1 + Blocklist.toInt(ip2) - Blocklist.toInt(ip1));
                    continue;
                }
                this.add(ip1);
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the blocklist file", ioe);
            }
            int n = count;
            return n;
        }
        catch (OutOfMemoryError oom) {
            this.disable();
            this._log.log(50, "OOM reading the blocklist");
            int n = 0;
            return n;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this._wrapSave != null) {
            Blocklist.store(this._wrapSave.ip1, this._wrapSave.ip2, blocklist, count++);
            ipcount += (long)(1 + Blocklist.toInt(this._wrapSave.ip2) - Blocklist.toInt(this._wrapSave.ip1));
            this._wrapSave = null;
        }
        int n = read = isFeedFile ? feedcount : count - oldcount;
        if (read > 0) {
            blf.version = blFile.lastModified();
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Stats for " + blFile);
            this._log.info("Removed " + badcount + " bad entries and comment lines");
            this._log.info("Read " + read + " valid entries from the blocklist " + blFile);
            this._log.info("Blocking " + (isFeedFile ? (long)feedcount : ipcount) + " IPs and " + peercount + " hashes");
            this._log.info("Blocklist processing finished, time: " + (this._context.clock().now() - start));
        }
        return count;
    }

    private int merge(long[] blocklist, int count) {
        long start = this._context.clock().now();
        int removed = 0;
        try {
            Arrays.sort(blocklist, 0, count);
            removed = this.removeOverlap(blocklist, count);
            if (removed > 0) {
                Arrays.sort(blocklist, 0, count);
            }
        }
        catch (OutOfMemoryError oom) {
            this.disable();
            this._log.log(50, "OOM sorting the blocklist");
            return 0;
        }
        int blocklistSize = count - removed;
        if (this._log.shouldLog(20)) {
            this._log.info("Merged Stats:\nRead " + count + " total entries from the blocklists\nMerged " + removed + " overlapping entries\nResult is " + blocklistSize + " entries\nBlocklist processing finished, time: " + (this._context.clock().now() - start));
        }
        return blocklistSize;
    }

    private Entry parse(String buf, boolean shouldLog) {
        byte[] ip2;
        byte[] ip1;
        byte[] b;
        int start1 = 0;
        int end1 = buf.length();
        if (end1 <= 0) {
            return null;
        }
        int start2 = -1;
        int mask = -1;
        String comment = null;
        int index = buf.indexOf(35);
        if (index == 0) {
            return null;
        }
        index = buf.lastIndexOf(58);
        if (index >= 0) {
            comment = buf.substring(0, index);
            start1 = index + 1;
        }
        if (end1 - start1 == 44 && buf.substring(start1).indexOf(46) < 0 && (b = Base64.decode(buf.substring(start1))) != null) {
            return new Entry(comment, Hash.create(b), null, null);
        }
        index = buf.indexOf(45, start1);
        if (index >= 0) {
            end1 = index;
            start2 = index + 1;
        } else {
            index = buf.indexOf(47, start1);
            if (index >= 0) {
                end1 = index;
                mask = index + 1;
            }
        }
        if (end1 - start1 <= 0) {
            return null;
        }
        try {
            String sip = buf.substring(start1, end1);
            sip = sip.replace(';', ':');
            InetAddress pi = InetAddress.getByName(sip);
            if (pi == null) {
                return null;
            }
            ip1 = pi.getAddress();
            if (start2 >= 0) {
                pi = InetAddress.getByName(buf.substring(start2));
                if (pi == null) {
                    return null;
                }
                ip2 = pi.getAddress();
                if (ip2.length != 4) {
                    throw new UnknownHostException();
                }
                if ((ip1[0] & 0xFF) < 128 && (ip2[0] & 0xFF) >= 128) {
                    if (this._wrapSave == null) {
                        this._wrapSave = new Entry(comment, null, new byte[]{-128, 0, 0, 0}, new byte[]{ip2[0], ip2[1], ip2[2], ip2[3]});
                        ip2 = new byte[]{127, -1, -1, -1};
                    } else {
                        throw new NumberFormatException();
                    }
                }
                for (int i = 0; i < 4 && (ip2[i] & 0xFF) <= (ip1[i] & 0xFF); ++i) {
                    if ((ip2[i] & 0xFF) >= (ip1[i] & 0xFF)) continue;
                    throw new NumberFormatException();
                }
            } else if (mask >= 0) {
                int i;
                int m = Integer.parseInt(buf.substring(mask));
                if (m < 3 || m > 32) {
                    throw new NumberFormatException();
                }
                ip2 = new byte[4];
                for (i = 0; i < 4; ++i) {
                    ip2[i] = ip1[i];
                }
                for (i = 0; i < 32 - m; ++i) {
                    int n = (31 - i) / 8;
                    ip2[n] = (byte)(ip2[n] | 1 << i % 8);
                }
            } else {
                ip2 = ip1;
            }
        }
        catch (UnknownHostException uhe) {
            if (shouldLog) {
                this._log.logAlways(30, "Format error in the blocklist file: " + buf);
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            if (shouldLog) {
                this._log.logAlways(30, "Format error in the blocklist file: " + buf);
            }
            return null;
        }
        catch (IndexOutOfBoundsException ioobe) {
            if (shouldLog) {
                this._log.logAlways(30, "Format error in the blocklist file: " + buf);
            }
            return null;
        }
        return new Entry(comment, null, ip1, ip2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSize(File blFile) {
        if (!blFile.exists() || blFile.length() <= 0L) {
            return 0;
        }
        int lines = 0;
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(blFile), "ISO-8859-1"));
            while ((s = br.readLine()) != null) {
                if (s.length() <= 0 || s.startsWith("#")) continue;
                ++lines;
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error reading the blocklist file", ioe);
            }
            int n = 0;
            return n;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lines;
    }

    private int removeOverlap(long[] blist, int count) {
        int removed;
        if (count <= 0) {
            return 0;
        }
        int lines = 0;
        for (int i = 0; i < count - 1; i += removed + 1) {
            removed = 0;
            int to = Blocklist.getTo(blist[i]);
            for (int next = i + 1; next < count && to >= Blocklist.getFrom(blist[next]); ++next) {
                int nextTo;
                if (this._log.shouldInfo()) {
                    this._log.info("Combining entries " + Blocklist.toStr(blist[i]) + " and " + Blocklist.toStr(blist[next]));
                }
                if ((nextTo = Blocklist.getTo(blist[next])) > to) {
                    Blocklist.store(Blocklist.getFrom(blist[i]), nextTo, blist, i);
                }
                blist[next] = Long.MAX_VALUE;
                ++lines;
                ++removed;
            }
        }
        return lines;
    }

    public void add(String ip) {
        byte[] pib = Addresses.getIP(ip);
        if (pib == null) {
            return;
        }
        this.add(pib);
    }

    public void add(byte[] ip) {
        boolean rv = ip.length == 4 ? this.add(Blocklist.toInt(ip)) : (ip.length == 16 ? this.add(new BigInteger(1, ip)) : false);
        if (rv && this._log.shouldInfo()) {
            this._log.info("Adding IP to blocklist: " + Addresses.toString(ip));
        }
    }

    public void remove(byte[] ip) {
        if (ip.length == 4) {
            this.remove(Blocklist.toInt(ip));
        } else if (ip.length == 16) {
            this.remove(new BigInteger(1, ip));
        }
    }

    private boolean add(int ip) {
        if (this._singleIPBlocklist.size() >= 8192) {
            return false;
        }
        return this._singleIPBlocklist.add(ip);
    }

    private void remove(int ip) {
        this._singleIPBlocklist.remove(ip);
    }

    private boolean isOnSingleList(int ip) {
        return this._singleIPBlocklist.contains(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(BigInteger ip) {
        Map<BigInteger, Object> map = this._singleIPv6Blocklist;
        synchronized (map) {
            return this._singleIPv6Blocklist.put(ip, DUMMY) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(BigInteger ip) {
        Map<BigInteger, Object> map = this._singleIPv6Blocklist;
        synchronized (map) {
            this._singleIPv6Blocklist.remove(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOnSingleList(BigInteger ip) {
        Map<BigInteger, Object> map = this._singleIPv6Blocklist;
        synchronized (map) {
            return this._singleIPv6Blocklist.get(ip) != null;
        }
    }

    private List<byte[]> getAddresses(Hash peer) {
        RouterInfo pinfo = this._context.netDb().lookupRouterInfoLocally(peer);
        if (pinfo == null) {
            return Collections.emptyList();
        }
        return Blocklist.getAddresses(pinfo);
    }

    private static List<byte[]> getAddresses(RouterInfo pinfo) {
        ArrayList<byte[]> rv = new ArrayList<byte[]>(4);
        for (RouterAddress pa : pinfo.getAddresses()) {
            byte[] pib = pa.getIP();
            if (pib == null) continue;
            boolean dup = false;
            for (int i = 0; i < rv.size(); ++i) {
                if (!DataHelper.eq((byte[])rv.get(i), pib)) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            rv.add(pib);
        }
        return rv;
    }

    public boolean isBlocklisted(Hash peer) {
        List<byte[]> ips = this.getAddresses(peer);
        if (ips.isEmpty()) {
            return false;
        }
        for (byte[] ip : ips) {
            if (!this.isBlocklisted(ip)) continue;
            if (!this._context.banlist().isBanlisted(peer)) {
                this.banlist(peer, ip);
            }
            return true;
        }
        return false;
    }

    public boolean isBlocklisted(RouterInfo pinfo) {
        List<byte[]> ips = Blocklist.getAddresses(pinfo);
        if (ips.isEmpty()) {
            return false;
        }
        for (byte[] ip : ips) {
            if (!this.isBlocklisted(ip)) continue;
            Hash peer = pinfo.getHash();
            if (!this._context.banlist().isBanlisted(peer)) {
                this.banlist(peer, ip);
            }
            return true;
        }
        return false;
    }

    public boolean isBlocklisted(String ip) {
        byte[] pib = Addresses.getIP(ip);
        if (pib == null) {
            return false;
        }
        return this.isBlocklisted(pib);
    }

    public boolean isBlocklisted(byte[] ip) {
        if (ip.length == 4) {
            return this.isBlocklisted(Blocklist.toInt(ip));
        }
        if (ip.length == 16) {
            return this.isOnSingleList(new BigInteger(1, ip));
        }
        return false;
    }

    private boolean isBlocklisted(int ip) {
        if (this.isOnSingleList(ip)) {
            return true;
        }
        if (this._countryBlocklist != null && Blocklist.isPermanentlyBlocklisted(ip, this._countryBlocklist, this._countryBlocklistSize)) {
            return true;
        }
        return this.isPermanentlyBlocklisted(ip);
    }

    public boolean isPermanentlyBlocklisted(int ip) {
        return Blocklist.isPermanentlyBlocklisted(ip, this._blocklist, this._blocklistSize);
    }

    private static boolean isPermanentlyBlocklisted(int ip, long[] blocklist, int blocklistSize) {
        int hi = blocklistSize - 1;
        if (hi <= 0) {
            return false;
        }
        int lo = 0;
        int cur = hi / 2;
        while (!Blocklist.match(ip, blocklist[cur])) {
            if (Blocklist.isHigher(ip, blocklist[cur])) {
                lo = cur;
            } else {
                hi = cur;
            }
            if (hi - lo <= 1) {
                if (lo == cur) {
                    cur = hi;
                    break;
                }
                cur = lo;
                break;
            }
            cur = lo + (hi - lo) / 2;
        }
        return Blocklist.match(ip, blocklist[cur]);
    }

    private static boolean match(int ip, long entry) {
        if (Blocklist.getFrom(entry) > ip) {
            return false;
        }
        return ip <= Blocklist.getTo(entry);
    }

    private static boolean isHigher(int ip, long entry) {
        return ip > Blocklist.getFrom(entry);
    }

    public static int getFrom(long entry) {
        return (int)(entry >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    public static int getTo(long entry) {
        return (int)(entry & 0xFFFFFFFFFFFFFFFFL);
    }

    private static long toEntry(byte[] ip1, byte[] ip2) {
        int i;
        long entry = 0L;
        for (i = 0; i < 4; ++i) {
            entry |= (long)(ip2[i] & 0xFF) << (3 - i) * 8;
        }
        for (i = 0; i < 4; ++i) {
            entry |= (long)(ip1[i] & 0xFF) << 32 + (3 - i) * 8;
        }
        return entry;
    }

    private static void store(byte[] ip1, byte[] ip2, long[] blocklist, int idx) {
        blocklist[idx] = Blocklist.toEntry(ip1, ip2);
    }

    private static void store(int ip1, int ip2, long[] blocklist, int idx) {
        long entry = (long)ip1 << 32;
        blocklist[idx] = entry |= (long)ip2 & 0xFFFFFFFFFFFFFFFFL;
    }

    private static int toInt(byte[] ip) {
        int rv = 0;
        for (int i = 0; i < 4; ++i) {
            rv |= (ip[i] & 0xFF) << (3 - i) * 8;
        }
        return rv;
    }

    private static String toStr(long entry) {
        StringBuilder buf = new StringBuilder(32);
        for (int i = 7; i >= 0; --i) {
            buf.append(entry >> 8 * i & 0xFFL);
            if (i == 4) {
                buf.append('-');
                continue;
            }
            if (i <= 0) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    public static String toStr(int ip) {
        StringBuilder buf = new StringBuilder(16);
        for (int i = 3; i >= 0; --i) {
            buf.append(ip >> 8 * i & 0xFF);
            if (i <= 0) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void banlist(Hash peer, byte[] ip) {
        boolean shouldRunJob;
        int number;
        String reason = Blocklist._x("IP banned by blocklist.txt entry {0}");
        String sip = Addresses.toString(ip);
        if ("127.0.0.1".equals(sip) || "0:0:0:0:0:0:0:1".equals(sip) || sip.startsWith("192.168.")) {
            this._context.banlist().banlistRouter(peer, reason, sip, null, this._context.clock().now() + 0x6DDD00L);
            return;
        }
        this._context.banlist().banlistRouterForever(peer, reason, sip);
        if (!this._context.getBooleanPropertyDefaultTrue(PROP_BLOCKLIST_DETAIL)) {
            return;
        }
        Set<Hash> set = this._inProcess;
        synchronized (set) {
            number = this._inProcess.size();
            shouldRunJob = this._inProcess.add(peer);
        }
        if (!shouldRunJob) {
            return;
        }
        BanlistJob job = new BanlistJob(peer, this.getAddresses(peer));
        if (number > 0) {
            job.getTiming().setStartAfter(this._context.clock().now() + 30000L * (long)number);
        }
        this._context.jobQueue().addJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void banlistForever(Hash peer, List<byte[]> ips) {
        File blFile = null;
        String file = this._context.getProperty(PROP_BLOCKLIST_FILE);
        if (file != null) {
            blFile = new File(file);
            if (!blFile.isAbsolute()) {
                blFile = new File(this._context.getConfigDir(), file);
            }
            if (!blFile.exists()) {
                blFile = null;
            }
        }
        if (blFile == null) {
            blFile = new File(this._context.getBaseDir(), BLOCKLIST_FILE_DEFAULT);
        }
        if (!blFile.exists() || blFile.length() <= 0L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Banlisting " + peer);
            }
            this._context.banlist().banlistRouterForever(peer, "Banned");
            return;
        }
        for (byte[] ip : ips) {
            int ipint = Blocklist.toInt(ip);
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(blFile), "UTF-8"));
                String buf = null;
                while ((buf = br.readLine()) != null) {
                    Entry e = this.parse(buf, false);
                    if (e == null || e.peer != null) continue;
                    if (!Blocklist.match(ipint, Blocklist.toEntry(e.ip1, e.ip2))) continue;
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String reason = Blocklist._x("IP banned by blocklist.txt entry {0}");
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Banlisting " + peer + " " + reason);
                    }
                    this._context.banlist().banlistRouterForever(peer, reason, buf.toString());
                    return;
                }
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Error reading the blocklist file", ioe);
            }
            finally {
                if (br == null) continue;
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public List<Integer> getTransientIPv4Blocks() {
        return new ArrayList<Integer>(this._singleIPBlocklist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BigInteger> getTransientIPv6Blocks() {
        Map<BigInteger, Object> map = this._singleIPv6Blocklist;
        synchronized (map) {
            return new ArrayList<BigInteger>(this._singleIPv6Blocklist.keySet());
        }
    }

    public synchronized long[] getPermanentBlocks(int max) {
        long[] rv;
        if (this._blocklistSize <= max) {
            rv = new long[this._blocklistSize];
            System.arraycopy(this._blocklist, 0, rv, 0, this._blocklistSize);
        } else {
            int from;
            int i;
            for (i = 0; i < this._blocklistSize && (from = Blocklist.getFrom(this._blocklist[i])) < 0; ++i) {
            }
            int sz = Math.min(this._blocklistSize - i, max);
            rv = new long[sz];
            System.arraycopy(this._blocklist, i, rv, 0, sz);
        }
        return rv;
    }

    public synchronized int getBlocklistSize() {
        return this._blocklistSize;
    }

    @Deprecated
    public void renderStatusHTML(Writer out) throws IOException {
    }

    private static final String _x(String s) {
        return s;
    }

    static /* synthetic */ long[] access$302(Blocklist x0, long[] x1) {
        x0._blocklist = x1;
        return x1;
    }

    private class BanlistJob
    extends JobImpl {
        private final Hash _peer;
        private final List<byte[]> _ips;

        public BanlistJob(Hash p, List<byte[]> ips) {
            super(Blocklist.this._context);
            this._peer = p;
            this._ips = ips;
        }

        @Override
        public String getName() {
            return "Ban Peer by IP";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            Blocklist.this.banlistForever(this._peer, this._ips);
            Set set = Blocklist.this._inProcess;
            synchronized (set) {
                Blocklist.this._inProcess.remove(this._peer);
            }
        }
    }

    private static class Entry {
        final String comment;
        final byte[] ip1;
        final byte[] ip2;
        final Hash peer;

        public Entry(String c, Hash h, byte[] i1, byte[] i2) {
            this.comment = c;
            this.peer = h;
            this.ip1 = i1;
            this.ip2 = i2;
        }
    }

    private class ReadinJob
    extends JobImpl {
        private final List<BLFile> _files;

        public ReadinJob(List<BLFile> files) {
            super(Blocklist.this._context);
            this._files = files;
        }

        @Override
        public String getName() {
            return "Read Blocklist";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            Object object = Blocklist.this._lock;
            synchronized (object) {
                Blocklist.access$302(Blocklist.this, Blocklist.this.allocate(this._files));
                if (Blocklist.this._blocklist == null) {
                    return;
                }
                int ccount = this.process();
                if (Blocklist.this._blocklist == null) {
                    return;
                }
                if (ccount <= 0) {
                    Blocklist.this.disable();
                    return;
                }
                Blocklist.this._blocklistSize = Blocklist.this.merge(Blocklist.this._blocklist, ccount);
            }
            new VersionNotifier(this._files);
        }

        private int process() {
            int count = 0;
            try {
                for (BLFile blf : this._files) {
                    count = Blocklist.this.readBlocklistFile(blf, Blocklist.this._blocklist, count);
                }
            }
            catch (OutOfMemoryError oom) {
                Blocklist.this._log.log(50, "OOM processing the blocklist");
                Blocklist.this.disable();
                return 0;
            }
            for (Hash peer : Blocklist.this._peerBlocklist.keySet()) {
                String comment = (String)Blocklist.this._peerBlocklist.get(peer);
                String reason = comment != null ? Blocklist._x("Banned by router hash: {0}") : Blocklist._x("Banned by router hash");
                Blocklist.this._context.banlist().banlistRouterForever(peer, reason, comment);
            }
            Blocklist.this._peerBlocklist.clear();
            return count;
        }
    }

    private class VersionNotifier
    extends SimpleTimer2.TimedEvent {
        public final List<BLFile> blfs;

        public VersionNotifier(List<BLFile> bf) {
            super(Blocklist.this._context.simpleTimer2(), 120000L);
            this.blfs = bf;
        }

        @Override
        public void timeReached() {
            ClientAppManager cmgr = Blocklist.this._context.clientAppManager();
            if (cmgr != null) {
                UpdateManager umgr = (UpdateManager)((Object)cmgr.getRegisteredApp("update"));
                if (umgr != null) {
                    for (BLFile blf : this.blfs) {
                        if (blf.version <= 0L) continue;
                        umgr.notifyInstalled(UpdateType.BLOCKLIST, blf.id, Long.toString(blf.version));
                    }
                } else {
                    Blocklist.this._log.warn("No update manager");
                }
            }
        }
    }

    private static class BLFile {
        public final File file;
        public final String id;
        public long version;

        public BLFile(File f, String s) {
            this.file = f;
            this.id = s;
        }
    }
}

