/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.swing.filechooser.FileSystemView;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.io.FreeColSavegameFile;

public class FreeColDirectories {
    private static final String AUTOSAVE_DIRECTORY = "autosave";
    private static final String BASE_DIRECTORY = "base";
    private static final String CLASSIC_DIRECTORY = "classic";
    private static final String[] CONFIG_DIRS = new String[]{"classic", "freecol"};
    private static final String DATA_DIRECTORY = "data";
    private static final String FREECOL_DIRECTORY = "freecol";
    private static final String HIGH_SCORE_FILE = "HighScores.xml";
    private static final String I18N_DIRECTORY = "strings";
    private static final String LOG_FILE = "FreeCol.log";
    private static final String MAPS_DIRECTORY = "maps";
    private static final String MODS_DIRECTORY = "mods";
    private static final String RULES_DIRECTORY = "rules";
    private static final String SAVE_DIRECTORY = "save";
    private static final String START_MAP_NAME = "startMap.fsg";
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String XDG_CONFIG_HOME_ENV = "XDG_CONFIG_HOME";
    private static final String XDG_CONFIG_HOME_DEFAULT = ".config";
    private static final String XDG_DATA_HOME_ENV = "XDG_DATA_HOME";
    private static final String XDG_DATA_HOME_DEFAULT = ".local/share";
    private static final String XDG_CACHE_HOME_ENV = "XDG_CACHE_HOME";
    private static final String XDG_CACHE_HOME_DEFAULT = ".cache";
    public static final String BASE_CLIENT_OPTIONS_FILE_NAME = "client-options.xml";
    public static final String CLIENT_OPTIONS_FILE_NAME = "options.xml";
    public static final String CUSTOM_DIFFICULTY_FILE_NAME = "custom.xml";
    public static final String GAME_OPTIONS_FILE_NAME = "game_options.xml";
    public static final String MAP_FILE_NAME = "my_map.fsg";
    public static final String MAP_GENERATOR_OPTIONS_FILE_NAME = "map_generator_options.xml";
    private static File autosaveDirectory = null;
    private static File clientOptionsFile = null;
    private static File dataDirectory = new File("data");
    private static String logFilePath = null;
    private static File saveDirectory = null;
    private static File savegameFile = null;
    private static File userCacheDirectory = null;
    private static File userConfigDirectory = null;
    private static File userDataDirectory = null;
    private static File userModsDirectory = null;

    public static boolean onMacOSX() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    public static boolean onUnix() {
        return "/".equals(SEPARATOR);
    }

    public static boolean onWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static File getUserDefaultDirectory() {
        return FileSystemView.getFileSystemView().getDefaultDirectory();
    }

    public static String checkDir(File dir) {
        return dir == null || !dir.exists() ? "cli.error.home.notExists" : (!dir.isDirectory() ? "cli.error.home.notDir" : (!dir.canRead() ? "cli.error.home.noRead" : (!dir.canWrite() ? "cli.error.home.noWrite" : null)));
    }

    private static int getXDGDirs(File[] dirs) {
        int i;
        if (FreeColDirectories.onMacOSX() || FreeColDirectories.onWindows() || !FreeColDirectories.onUnix()) {
            return -1;
        }
        int ret = -1;
        File home = FreeColDirectories.getUserDefaultDirectory();
        if (home == null) {
            return -1;
        }
        String[][] xdg = new String[][]{{XDG_CONFIG_HOME_ENV, XDG_CONFIG_HOME_DEFAULT}, {XDG_DATA_HOME_ENV, XDG_DATA_HOME_DEFAULT}, {XDG_CACHE_HOME_ENV, XDG_CACHE_HOME_DEFAULT}};
        File[] todo = new File[xdg.length];
        for (i = 0; i < xdg.length; ++i) {
            File d;
            String env = System.getenv(xdg[i][0]);
            File file = d = env != null ? new File(env) : new File(home, xdg[i][1]);
            if (d.exists()) {
                if (!d.isDirectory() || !d.canWrite()) {
                    return -1;
                }
                ret = Math.max(ret, 0);
                File f = new File(d, FREECOL_DIRECTORY);
                if (f.exists()) {
                    if (!f.isDirectory() || !f.canWrite()) {
                        return -1;
                    }
                    dirs[i] = f;
                    todo[i] = null;
                    ++ret;
                    continue;
                }
                dirs[i] = d;
                todo[i] = f;
                continue;
            }
            dirs[i] = null;
            todo[i] = d;
        }
        if (ret < 0) {
            return -1;
        }
        if (ret == xdg.length) {
            return 1;
        }
        for (i = 0; i < xdg.length; ++i) {
            if (todo[i] == null) continue;
            if (!todo[i].getPath().endsWith(FREECOL_DIRECTORY)) {
                if (!todo[i].mkdir()) {
                    return -1;
                }
                todo[i] = new File(todo[i], FREECOL_DIRECTORY);
            }
            if (!todo[i].mkdir()) {
                return -1;
            }
            dirs[i] = todo[i];
        }
        return 0;
    }

    private static boolean isGoodDirectory(File f) {
        return f.exists() && f.isDirectory() && f.canWrite();
    }

    private static File requireDir(File dir) {
        if (dir.exists() ? dir.isDirectory() && dir.canWrite() : dir.mkdir()) {
            return dir;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getMacOSXDirs(File[] dirs) {
        File d;
        if (!FreeColDirectories.onMacOSX()) {
            return -1;
        }
        int ret = 0;
        File homeDir = FreeColDirectories.getUserDefaultDirectory();
        if (homeDir == null) {
            return -1;
        }
        File libDir = new File(homeDir, "Library");
        if (!FreeColDirectories.isGoodDirectory(libDir)) {
            return -1;
        }
        if (dirs[0] == null) {
            File prefsDir = new File(libDir, "Preferences");
            if (!FreeColDirectories.isGoodDirectory(prefsDir)) return -1;
            dirs[0] = prefsDir;
            d = new File(prefsDir, FREECOL_DIRECTORY);
            if (d.exists()) {
                if (!d.isDirectory() || !d.canWrite()) return -1;
                dirs[0] = d;
                ++ret;
            }
        }
        if (dirs[1] == null) {
            File appsDir = new File(libDir, "Application Support");
            if (!FreeColDirectories.isGoodDirectory(appsDir)) return -1;
            dirs[1] = appsDir;
            d = new File(appsDir, FREECOL_DIRECTORY);
            if (d.exists()) {
                if (!d.isDirectory() || !d.canWrite()) return -1;
                dirs[1] = d;
                ++ret;
            }
        }
        if (dirs[2] == null) {
            dirs[2] = dirs[1];
        }
        if (ret == 2) {
            return 1;
        }
        File d2 = FreeColDirectories.requireDir(new File(dirs[0], FREECOL_DIRECTORY));
        if (d2 == null) {
            return -1;
        }
        dirs[0] = d2;
        d2 = FreeColDirectories.requireDir(new File(dirs[1], FREECOL_DIRECTORY));
        if (d2 == null) {
            return -1;
        }
        dirs[1] = d2;
        return 0;
    }

    private static int getWindowsDirs(File[] dirs) {
        if (FreeColDirectories.onMacOSX() || !FreeColDirectories.onWindows() || FreeColDirectories.onUnix()) {
            return -1;
        }
        File home = FreeColDirectories.getUserDefaultDirectory();
        if (home == null) {
            return -1;
        }
        File d = FreeColDirectories.requireDir(new File(home, FREECOL_DIRECTORY));
        if (d == null) {
            return -1;
        }
        dirs[1] = dirs[2] = d;
        dirs[0] = dirs[2];
        return 1;
    }

    private static File getOldUserDirectory() {
        File home = FreeColDirectories.getUserDefaultDirectory();
        File old = new File(home, "FreeCol");
        if (old.exists() && old.isDirectory() && old.canRead()) {
            return old;
        }
        old = new File(home, ".freecol");
        if (old.exists() && old.isDirectory() && old.canRead()) {
            return old;
        }
        old = new File(home, "Library");
        if (old.exists() && old.isDirectory() && old.canRead() && (old = new File(old, "FreeCol")).exists() && old.isDirectory() && old.canRead()) {
            return old;
        }
        return null;
    }

    private static void copyIfFound(File oldDir, String name, File newDir) {
        File src = new File(oldDir, name);
        File dst = new File(newDir, name);
        if (src.exists() && src.isDirectory() && !dst.exists()) {
            try {
                Files.copy(src.toPath(), dst.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (IOException ioe) {
                System.err.println("Could not copy " + src.toString() + " to " + dst.toString() + ": " + ioe.getMessage());
            }
        }
    }

    private static boolean insistDirectory(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            System.err.println("Could not create directory " + file.getPath() + " because a non-directory with that name is already there.");
            return false;
        }
        try {
            return file.mkdir();
        }
        catch (Exception e) {
            System.err.println("Could not make directory " + file.getPath() + ": " + e.getMessage());
            return false;
        }
    }

    private static void deriveAutosaveDirectory() {
        if (autosaveDirectory == null && saveDirectory != null && !FreeColDirectories.insistDirectory(autosaveDirectory = new File(saveDirectory, AUTOSAVE_DIRECTORY))) {
            autosaveDirectory = null;
        }
    }

    public static String setDataDirectory(String path) {
        File dir;
        if (path == null) {
            path = DATA_DIRECTORY;
        }
        if (!(dir = new File(path)).isDirectory()) {
            return "Not a directory: " + path;
        }
        if (!dir.canRead()) {
            return "Can not read directory: " + path;
        }
        dataDirectory = dir;
        if (FreeColDirectories.getBaseDirectory() == null) {
            return "Can not find base resources directory: " + path + SEPARATOR + BASE_DIRECTORY;
        }
        if (FreeColDirectories.getI18nDirectory() == null) {
            return "Can not find I18n resources directory: " + path + SEPARATOR + I18N_DIRECTORY;
        }
        return null;
    }

    public static synchronized String setUserDirectories() {
        File[] dirs;
        if (userConfigDirectory != null && !FreeColDirectories.isGoodDirectory(userConfigDirectory)) {
            userConfigDirectory = null;
        }
        if (userDataDirectory != null && !FreeColDirectories.isGoodDirectory(userDataDirectory)) {
            userDataDirectory = null;
        }
        if (userCacheDirectory != null && !FreeColDirectories.isGoodDirectory(userCacheDirectory)) {
            userCacheDirectory = null;
        }
        int migrate = (dirs = new File[]{userConfigDirectory, userDataDirectory, userCacheDirectory})[0] != null && FreeColDirectories.isGoodDirectory(dirs[0]) && dirs[1] != null && FreeColDirectories.isGoodDirectory(dirs[1]) && dirs[2] != null && FreeColDirectories.isGoodDirectory(dirs[2]) ? 1 : (FreeColDirectories.onMacOSX() ? FreeColDirectories.getMacOSXDirs(dirs) : (FreeColDirectories.onUnix() ? FreeColDirectories.getXDGDirs(dirs) : (FreeColDirectories.onWindows() ? FreeColDirectories.getWindowsDirs(dirs) : -1)));
        File oldDir = FreeColDirectories.getOldUserDirectory();
        if (migrate < 0) {
            if (oldDir == null) {
                return "main.userDir.fail";
            }
            dirs[1] = dirs[2] = oldDir;
            dirs[0] = dirs[2];
            migrate = 1;
        }
        if (userConfigDirectory == null) {
            userConfigDirectory = dirs[0];
        } else {
            migrate = 1;
        }
        if (userDataDirectory == null) {
            userDataDirectory = dirs[1];
        } else {
            migrate = 1;
        }
        if (userCacheDirectory == null) {
            userCacheDirectory = dirs[2];
        } else {
            migrate = 1;
        }
        if (migrate == 0 && oldDir != null) {
            FreeColDirectories.copyIfFound(oldDir, CLASSIC_DIRECTORY, userConfigDirectory);
            FreeColDirectories.copyIfFound(oldDir, FREECOL_DIRECTORY, userConfigDirectory);
            FreeColDirectories.copyIfFound(oldDir, SAVE_DIRECTORY, userDataDirectory);
            FreeColDirectories.copyIfFound(oldDir, MODS_DIRECTORY, userDataDirectory);
        }
        if (logFilePath == null) {
            logFilePath = FreeColDirectories.getUserCacheDirectory() + SEPARATOR + LOG_FILE;
        }
        if (saveDirectory == null && !FreeColDirectories.insistDirectory(saveDirectory = new File(FreeColDirectories.getUserDataDirectory(), SAVE_DIRECTORY))) {
            return "main.userDir.fail";
        }
        FreeColDirectories.deriveAutosaveDirectory();
        userModsDirectory = new File(FreeColDirectories.getUserDataDirectory(), MODS_DIRECTORY);
        if (!FreeColDirectories.insistDirectory(userModsDirectory)) {
            userModsDirectory = null;
        }
        return migrate > 0 ? null : (FreeColDirectories.onMacOSX() ? "main.userDir.macosx" : (FreeColDirectories.onUnix() ? "main.userDir.unix" : (FreeColDirectories.onWindows() ? "main.userDir.windows" : null)));
    }

    public static File getAutosaveDirectory() {
        return autosaveDirectory;
    }

    public static File getBaseDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), BASE_DIRECTORY);
    }

    public static File getBaseClientOptionsFile() {
        return new File(FreeColDirectories.getBaseDirectory(), BASE_CLIENT_OPTIONS_FILE_NAME);
    }

    public static File getClientOptionsFile() {
        return clientOptionsFile != null ? clientOptionsFile : FreeColDirectories.getOptionsFile(CLIENT_OPTIONS_FILE_NAME);
    }

    public static boolean setClientOptionsFile(String path) {
        File file = new File(path);
        if (file.exists() && file.isFile() && file.canRead()) {
            clientOptionsFile = file;
            return true;
        }
        return false;
    }

    public static File getDataDirectory() {
        return dataDirectory;
    }

    public static File getHighScoreFile() {
        return new File(FreeColDirectories.getUserDataDirectory(), HIGH_SCORE_FILE);
    }

    public static File getI18nDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), I18N_DIRECTORY);
    }

    public static String getLogFilePath() {
        return logFilePath;
    }

    public static void setLogFilePath(String path) {
        logFilePath = path;
    }

    public static File getMapsDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), MAPS_DIRECTORY);
    }

    public static File getOptionsDirectory() {
        File dir = new File(FreeColDirectories.getUserConfigDirectory(), FreeCol.getTC());
        return FreeColDirectories.insistDirectory(dir) ? dir : null;
    }

    public static File getOptionsFile(String name) {
        File dir = FreeColDirectories.getOptionsDirectory();
        return dir == null ? null : new File(dir, name);
    }

    public static File getRulesClassicDirectory() {
        return new File(FreeColDirectories.getRulesDirectory(), CLASSIC_DIRECTORY);
    }

    public static File getRulesDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), RULES_DIRECTORY);
    }

    public static File getSaveDirectory() {
        return saveDirectory;
    }

    public static File getSavegameFile() {
        return savegameFile;
    }

    public static boolean setSavegameFile(String path) {
        File file = new File(path);
        if (!(file.exists() && file.isFile() && file.canRead() || (file = new File(FreeColDirectories.getSaveDirectory(), path)).exists() && file.isFile() && file.canRead())) {
            return false;
        }
        savegameFile = file;
        File parent = file.getParentFile();
        if (parent == null) {
            parent = new File(".");
        }
        saveDirectory = parent;
        FreeColDirectories.deriveAutosaveDirectory();
        return true;
    }

    public static File getLastSaveGameFile() {
        File lastSave = null;
        for (File directory : new File[]{FreeColDirectories.getSaveDirectory(), FreeColDirectories.getAutosaveDirectory()}) {
            for (File savegame : directory.listFiles(FreeColSavegameFile.getFileFilter())) {
                if (lastSave != null && savegame.lastModified() <= lastSave.lastModified()) continue;
                lastSave = savegame;
            }
        }
        return lastSave;
    }

    public static File getStandardModsDirectory() {
        return new File(FreeColDirectories.getDataDirectory(), MODS_DIRECTORY);
    }

    public static File getStartMapFile() {
        return new File(FreeColDirectories.getAutosaveDirectory(), START_MAP_NAME);
    }

    public static File getUserCacheDirectory() {
        return userCacheDirectory;
    }

    public static String setUserCacheDirectory(String path) {
        File dir = new File(path);
        String ret = FreeColDirectories.checkDir(dir);
        if (ret == null) {
            userCacheDirectory = dir;
        }
        return ret;
    }

    public static File getUserConfigDirectory() {
        return userConfigDirectory;
    }

    public static String setUserConfigDirectory(String path) {
        File dir = new File(path);
        String ret = FreeColDirectories.checkDir(dir);
        if (ret == null) {
            userConfigDirectory = dir;
        }
        return ret;
    }

    public static File getUserDataDirectory() {
        return userDataDirectory;
    }

    public static String setUserDataDirectory(String path) {
        File dir = new File(path);
        String ret = FreeColDirectories.checkDir(dir);
        if (ret == null) {
            userDataDirectory = dir;
        }
        return ret;
    }

    public static File getUserModsDirectory() {
        return userModsDirectory;
    }
}

