/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.DraggablePlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenComponentUI;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPLabel;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.swingui.ColourScheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.List;

public class PlayPenLabel
extends DraggablePlayPenComponent {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(SPLabel.class);
    private final SPLabel label;

    @Constructor
    public PlayPenLabel(@ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="label") SPLabel label, @ConstructorParameter(propertyName="name") String name) {
        super(name);
        label.setParent((SPObject)this);
        this.label = label;
        label.addSPListener((SPListener)new AbstractSPListener(){

            public void propertyChanged(PropertyChangeEvent evt) {
                PlayPenLabel.this.revalidate();
            }
        });
    }

    @Override
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    public List<SPLabel> getChildren() {
        return Collections.singletonList(this.label);
    }

    @Override
    public Object getModel() {
        return null;
    }

    @Override
    public String getModelName() {
        return null;
    }

    @Override
    public void handleMouseEvent(MouseEvent evt) {
        PlayPen pp = this.getPlayPen();
        Point p = evt.getPoint();
        pp.unzoomPoint(p);
        p.translate(-this.getX(), -this.getY());
        if (evt.getID() == 500) {
            if (evt.getClickCount() == 1 && evt.getButton() == 1 && !evt.isControlDown()) {
                pp.selectNone();
            }
            if ((evt.getModifiers() & 0x10) != 0) {
                if (evt.getClickCount() == 2) {
                    if (this.isSelected()) {
                        ArchitectFrame af = pp.getSession().getArchitectFrame();
                        af.getEditLabelAction().actionPerformed(new ActionEvent(this, 1001, "PlayPen"));
                    }
                } else {
                    this.setSelected(true, 4);
                }
            }
        } else if (evt.getID() == 501) {
            if (this.isSelected()) {
                this.componentPreviouslySelected = true;
            } else {
                if (!evt.isControlDown()) {
                    pp.selectNone();
                }
                this.componentPreviouslySelected = false;
                this.setSelected(true, 4);
            }
            if (!pp.getSession().getArchitectFrame().createRelationshipIsActive()) {
                this.setupDrag(p);
            }
        } else if (evt.getID() == 503 || evt.getID() == 506) {
            this.setSelected(pp.rubberBand.intersects(this.getBounds(new Rectangle())), 4);
        }
    }

    @Override
    public PlayPenComponentUI getUI() {
        return new LabelUI();
    }

    @Override
    @NonBound
    public Font getFont() {
        Font font = this.label.getFont();
        if (font != null) {
            return font;
        }
        return this.getPlayPen().getFont();
    }

    @NonProperty
    public SPLabel getLabel() {
        return this.label;
    }

    private final class LabelUI
    implements PlayPenComponentUI {
        Insets insets = new Insets(1, 3, 3, 3);

        private LabelUI() {
        }

        @Override
        public boolean contains(Point p) {
            return PlayPenLabel.this.getBounds().contains(p);
        }

        @Override
        public Point getPointForModelObject(Object modelObject) {
            return PlayPenLabel.this.getLocation();
        }

        @Override
        public Dimension getPreferredSize() {
            if (PlayPenLabel.this.label.getText() == null) {
                return new Dimension(0, 0);
            }
            String[] textToRender = PlayPenLabel.this.label.getText().split("\n");
            FontMetrics fm = PlayPenLabel.this.getPlayPen().getFontMetrics(PlayPenLabel.this.getPlayPen().getFont());
            int textHeight = fm.getHeight() * textToRender.length;
            int textWidth = 0;
            for (String line : textToRender) {
                int lineWidth = fm.stringWidth(line);
                if (lineWidth <= textWidth) continue;
                textWidth = lineWidth;
            }
            return new Dimension(textWidth + this.insets.left + this.insets.right, textHeight + this.insets.top + this.insets.bottom);
        }

        @Override
        public void installUI(PlayPenComponent c) {
        }

        @Override
        public void paint(Graphics2D g2) {
            if (PlayPenLabel.this.label.getBackgroundColour() != null) {
                g2.setColor(PlayPenLabel.this.label.getBackgroundColour());
                g2.fillRect(0, 0, PlayPenLabel.this.getWidth(), PlayPenLabel.this.getHeight());
            }
            if (PlayPenLabel.this.isSelected()) {
                g2.setColor((Color)ColourScheme.SQLPOWER_ORANGE);
            } else {
                g2.setColor(PlayPenLabel.this.label.getBorderColour());
            }
            g2.drawRect(0, 0, PlayPenLabel.this.getWidth(), PlayPenLabel.this.getHeight());
            g2.translate(this.insets.left, this.insets.top);
            g2.setColor(Color.BLACK);
            if (PlayPenLabel.this.label.getText() == null) {
                return;
            }
            String[] textToRender = PlayPenLabel.this.label.getText().split("\n");
            g2.setFont(PlayPenLabel.this.getPlayPen().getFont());
            FontMetrics fm = g2.getFontMetrics();
            int textHeight = fm.getHeight() * textToRender.length;
            if (PlayPenLabel.this.label.getForegroundColour() == null) {
                g2.setColor(Color.BLACK);
            } else {
                g2.setColor(PlayPenLabel.this.label.getForegroundColour());
            }
            double y = PlayPenLabel.this.label.getVerticalAlignment().calculateStartY((double)PlayPenLabel.this.getHeight(), (double)textHeight, fm);
            for (String text : textToRender) {
                int textWidth = (int)fm.getStringBounds(text, g2).getWidth();
                double x = PlayPenLabel.this.label.getHorizontalAlignment().computeStartX((double)(PlayPenLabel.this.getWidth() - (this.insets.left + this.insets.right)), (double)textWidth);
                g2.drawString(text, (int)x, (int)y);
                y += (double)fm.getHeight();
            }
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void uninstallUI(PlayPenComponent c) {
        }
    }
}

