"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var chart_types_1 = require("../../chart_types");
var constants_1 = require("../../specs/constants");
var utils_1 = require("../utils");
var get_chart_id_1 = require("./get_chart_id");
var getSpecs = function (state) { return state.specs; };
exports.getSettingsSpecSelector = re_reselect_1.default([getSpecs], function (specs) {
    var settingsSpecs = utils_1.getSpecsFromStore(specs, chart_types_1.ChartTypes.Global, constants_1.SpecTypes.Settings);
    if (settingsSpecs.length === 1) {
        return settingsSpecs[0];
    }
    return constants_1.DEFAULT_SETTINGS_SPEC;
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_settings_specs.js.map