"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../../../utils/commons");
var color_library_wrappers_1 = require("../../../../partition_chart/layout/utils/color_library_wrappers");
function buildPointStyles(baseColor, themePointStyle, geometryStateStyle, pointRadius, overrides) {
    var _a;
    var pointStyle = commons_1.mergePartial(themePointStyle, overrides);
    var fillOpacity = function (opacity) { return opacity * pointStyle.opacity * geometryStateStyle.opacity; };
    var fillColor = color_library_wrappers_1.stringToRGB(commons_1.getColorFromVariant(baseColor, pointStyle.fill), fillOpacity);
    var fill = {
        color: fillColor,
    };
    var strokeOpacity = function (opacity) { return opacity * pointStyle.opacity * geometryStateStyle.opacity; };
    var strokeColor = color_library_wrappers_1.stringToRGB(commons_1.getColorFromVariant(baseColor, pointStyle.stroke), strokeOpacity);
    var stroke = {
        color: strokeColor,
        width: pointStyle.strokeWidth,
    };
    var radius = getRadius(pointRadius, themePointStyle.radius, (_a = overrides) === null || _a === void 0 ? void 0 : _a.radius);
    return { fill: fill, stroke: stroke, radius: radius };
}
exports.buildPointStyles = buildPointStyles;
function getRadius(pointRadius, themeRadius, overrideRadius) {
    if (overrideRadius !== undefined) {
        return overrideRadius;
    }
    return Math.max(pointRadius, themeRadius);
}
exports.getRadius = getRadius;
//# sourceMappingURL=point.js.map