'\"
'\" Generated from file '' by tcllib/doctools with format 'nroff'
'\"
.TH "tcllib" n 1\&.19  "Tcl Standard Library"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
tcllib \- Tcl Standard Library
.SH DESCRIPTION
A collection of pure-Tcl utility modules for Tcl that provide a wide
variety of functionality, from implementations of standard data
structures to implementations of common networking protocols\&.
The intent is to collect commonly used functions into a single
library which users can rely on to be available and stable\&.
.SH MODULES
.TP
\fBaes\fR 1\&.2\&.1
Advanced Encryption Standard (AES) - Implementation of the AES block cipher
.TP
\fBascii85\fR 1\&.0
Text encoding & decoding binary data - ascii85-encode/decode binary data
.TP
\fBasn\fR 0\&.8
ASN\&.1 processing - ASN\&.1 BER encoder/decoder
.TP
\fBautoproxy\fR 1\&.7
HTTP protocol helper modules - Automatic HTTP proxy usage and authentication
.TP
\fBbase32\fR 0\&.1
Base32 encoding - base32 standard encoding
.TP
\fBbase32::core\fR 0\&.1
Base32 encoding - Expanding basic base32 maps
.TP
\fBbase32::hex\fR 0\&.1
Base32 encoding - base32 extended hex encoding
.TP
\fBbase64\fR 2\&.4\&.2
Text encoding & decoding binary data - base64-encode/decode binary data
.TP
\fBbee\fR 0\&.1
BitTorrent - BitTorrent Serialization Format Encoder/Decoder
.TP
\fBbench\fR 0\&.4
Benchmarking/Performance tools - bench - Processing benchmark suites
.TP
\fBbench::in\fR 0\&.1
Benchmarking/Performance tools - bench::in - Reading benchmark results
.TP
\fBbench::out::csv\fR 0\&.1\&.2
Benchmarking/Performance tools - bench::out::csv - Formatting benchmark results as CSV
.TP
\fBbench::out::text\fR 0\&.1\&.2
Benchmarking/Performance tools - bench::out::text - Formatting benchmark results as human readable text
.TP
\fBbench_intro\fR 1\&.0
Benchmarking/Performance tools - bench introduction
.TP
\fBbench_lang_intro\fR 1\&.0
Benchmarking/Performance tools - bench language introduction
.TP
\fBbench_lang_spec\fR 1\&.0
Documentation tools - bench language specification
.TP
\fBbibtex\fR 0\&.6
bibtex - Parse bibtex files
.TP
\fBblowfish\fR 1\&.0\&.3
Blowfish Block Cipher - Implementation of the Blowfish block cipher
.TP
\fBcache::async\fR 0\&.3
In-memory caches - Asynchronous in-memory cache
.TP
\fBcksum\fR 1\&.1\&.4
Cyclic Redundancy Checks - Calculate a cksum(1) compatible checksum
.TP
\fBclock_iso8601\fR 0\&.1
Date/Time Utilities - Parsing ISO 8601 dates/times
.TP
\fBclock_rfc2822\fR 0\&.1
Date/Time Utilities - Parsing ISO 8601 dates/times
.TP
\fBcmdline\fR 1\&.5
Command line and option processing - Procedures to process command lines and options\&.
.TP
\fBcomm\fR 4\&.6\&.3
Remote communication - A remote communication facility for Tcl (8\&.3 and later)
.TP
\fBcomm_wire\fR 3
Remote communication - The comm wire protocol
.TP
\fBcontrol\fR 0\&.1\&.3
Tcl Control Flow Commands - Procedures for control flow structures\&.
.TP
\fBcoroutine\fR 1\&.2
Coroutine utilities - Coroutine based event and IO handling
.TP
\fBcoroutine::auto\fR 1\&.1\&.3
Coroutine utilities - Automatic event and IO coroutine awareness
.TP
\fBcounter\fR 2\&.0\&.4
Counters and Histograms - Procedures for counters and histograms
.TP
\fBcrc16\fR 1\&.1\&.3
Cyclic Redundancy Checks - Perform a 16bit Cyclic Redundancy Check
.TP
\fBcrc32\fR 1\&.3\&.2
Cyclic Redundancy Checks - Perform a 32bit Cyclic Redundancy Check
.TP
\fBcron\fR 2\&.1
cron - Tool for automating the period callback of commands
.TP
\fBcsv\fR 0\&.8\&.1
CSV processing - Procedures to handle CSV data\&.
.TP
\fBdebug\fR 1\&.0\&.6
debug narrative - debug narrative - core
.TP
\fBdebug::caller\fR 1\&.1
debug narrative - debug narrative - caller
.TP
\fBdebug::heartbeat\fR 1
debug narrative - debug narrative - heartbeat
.TP
\fBdebug::timestamp\fR 1
debug narrative - debug narrative - timestamping
.TP
\fBdefer\fR 1
Defered execution ala Go - Defered execution
.TP
\fBdeleg_method\fR 0\&.2
Interpreter utilities - Creation of comm delegates (snit methods)
.TP
\fBdeleg_proc\fR 0\&.2
Interpreter utilities - Creation of comm delegates (procedures)
.TP
\fBdes\fR 1\&.1
Data Encryption Standard (DES) - Implementation of the DES and triple-DES ciphers
.TP
\fBdicttool\fR 1\&.0
Extensions to the standard "dict" command - Dictionary Tools
.TP
\fBdns\fR 1\&.4\&.0
Domain Name Service - Tcl Domain Name Service Client
.TP
\fBdocidx_intro\fR 1\&.0
Documentation tools - docidx introduction
.TP
\fBdocidx_lang_cmdref\fR 1\&.0
Documentation tools - docidx language command reference
.TP
\fBdocidx_lang_faq\fR 1\&.0
Documentation tools - docidx language faq
.TP
\fBdocidx_lang_intro\fR 1\&.0
Documentation tools - docidx language introduction
.TP
\fBdocidx_lang_syntax\fR 1\&.0
Documentation tools - docidx language syntax
.TP
\fBdocidx_plugin_apiref\fR 1\&.0
Documentation tools - docidx plugin API reference
.TP
\fBdocstrip\fR 1\&.2
Literate programming tool - Docstrip style source code extraction
.TP
\fBdocstrip_util\fR 1\&.3\&.1
Literate programming tool - Docstrip-related utilities
.TP
\fBdoctoc_intro\fR 1\&.0
Documentation tools - doctoc introduction
.TP
\fBdoctoc_lang_cmdref\fR 1\&.0
Documentation tools - doctoc language command reference
.TP
\fBdoctoc_lang_faq\fR 1\&.0
Documentation tools - doctoc language faq
.TP
\fBdoctoc_lang_intro\fR 1\&.0
Documentation tools - doctoc language introduction
.TP
\fBdoctoc_lang_syntax\fR 1\&.0
Documentation tools - doctoc language syntax
.TP
\fBdoctoc_plugin_apiref\fR 1\&.0
Documentation tools - doctoc plugin API reference
.TP
\fBdoctools\fR 1\&.4\&.21
Documentation tools - doctools - Processing documents
.TP
\fBdoctools2idx_introduction\fR 2\&.0
Documentation tools - DocTools - Keyword indices
.TP
\fBdoctools2toc_introduction\fR 2\&.0
Documentation tools - DocTools - Tables of Contents
.TP
\fBdoctools::changelog\fR 1\&.1
Documentation tools - Processing text in Emacs ChangeLog format
.TP
\fBdoctools::cvs\fR 1
Documentation tools - Processing text in 'cvs log' format
.TP
\fBdoctools::html::cssdefaults\fR 0\&.1
Documentation tools - Default CSS style for HTML export plugins
.TP
\fBdoctools::idx\fR 1\&.0\&.7
Documentation tools - docidx - Processing indices
.TP
\fBdoctools::idx\fR 2
Documentation tools - Holding keyword indices
.TP
\fBdoctools::idx::export\fR 0\&.2
Documentation tools - Exporting keyword indices
.TP
\fBdoctools::idx::export::docidx\fR 0\&.1
Documentation tools - docidx export plugin
.TP
\fBdoctools::idx::export::html\fR 0\&.2
Documentation tools - HTML export plugin
.TP
\fBdoctools::idx::export::json\fR 0\&.1
Documentation tools - JSON export plugin
.TP
\fBdoctools::idx::export::nroff\fR 0\&.3
Documentation tools - nroff export plugin
.TP
\fBdoctools::idx::export::text\fR 0\&.2
Documentation tools - plain text export plugin
.TP
\fBdoctools::idx::export::wiki\fR 0\&.2
Documentation tools - wiki export plugin
.TP
\fBdoctools::idx::import\fR 0\&.2
Documentation tools - Importing keyword indices
.TP
\fBdoctools::idx::import::docidx\fR 0\&.1
Documentation tools - docidx import plugin
.TP
\fBdoctools::idx::import::json\fR 0\&.1
Documentation tools - JSON import plugin
.TP
\fBdoctools::idx::parse\fR 1
Documentation tools - Parsing text in docidx format
.TP
\fBdoctools::idx::structure\fR 0\&.1
Documentation tools - Docidx serialization utilities
.TP
\fBdoctools::msgcat\fR 0\&.1
Documentation tools - Message catalog management for the various document parsers
.TP
\fBdoctools::msgcat::idx::c\fR 0\&.1
Documentation tools - Message catalog for the docidx parser (C)
.TP
\fBdoctools::msgcat::idx::de\fR 0\&.1
Documentation tools - Message catalog for the docidx parser (DE)
.TP
\fBdoctools::msgcat::idx::en\fR 0\&.1
Documentation tools - Message catalog for the docidx parser (EN)
.TP
\fBdoctools::msgcat::idx::fr\fR 0\&.1
Documentation tools - Message catalog for the docidx parser (FR)
.TP
\fBdoctools::msgcat::toc::c\fR 0\&.1
Documentation tools - Message catalog for the doctoc parser (C)
.TP
\fBdoctools::msgcat::toc::de\fR 0\&.1
Documentation tools - Message catalog for the doctoc parser (DE)
.TP
\fBdoctools::msgcat::toc::en\fR 0\&.1
Documentation tools - Message catalog for the doctoc parser (EN)
.TP
\fBdoctools::msgcat::toc::fr\fR 0\&.1
Documentation tools - Message catalog for the doctoc parser (FR)
.TP
\fBdoctools::nroff::man_macros\fR 0\&.1
Documentation tools - Default CSS style for NROFF export plugins
.TP
\fBdoctools::tcl::parse\fR 1
Documentation tools - Processing text in 'subst -novariables' format
.TP
\fBdoctools::toc\fR 1\&.1\&.6
Documentation tools - doctoc - Processing tables of contents
.TP
\fBdoctools::toc\fR 2
Documentation tools - Holding tables of contents
.TP
\fBdoctools::toc::export\fR 0\&.2
Documentation tools - Exporting tables of contents
.TP
\fBdoctools::toc::export::doctoc\fR 0\&.1
Documentation tools - doctoc export plugin
.TP
\fBdoctools::toc::export::html\fR 0\&.1
Documentation tools - HTML export plugin
.TP
\fBdoctools::toc::export::json\fR 0\&.1
Documentation tools - JSON export plugin
.TP
\fBdoctools::toc::export::nroff\fR 0\&.2
Documentation tools - nroff export plugin
.TP
\fBdoctools::toc::export::text\fR 0\&.1
Documentation tools - plain text export plugin
.TP
\fBdoctools::toc::export::wiki\fR 0\&.1
Documentation tools - wiki export plugin
.TP
\fBdoctools::toc::import\fR 0\&.2
Documentation tools - Importing keyword indices
.TP
\fBdoctools::toc::import::doctoc\fR 0\&.1
Documentation tools - doctoc import plugin
.TP
\fBdoctools::toc::import::json\fR 0\&.1
Documentation tools - JSON import plugin
.TP
\fBdoctools::toc::parse\fR 1
Documentation tools - Parsing text in doctoc format
.TP
\fBdoctools::toc::structure\fR 0\&.1
Documentation tools - Doctoc serialization utilities
.TP
\fBdoctools_intro\fR 1\&.0
Documentation tools - doctools introduction
.TP
\fBdoctools_lang_cmdref\fR 1\&.0
Documentation tools - doctools language command reference
.TP
\fBdoctools_lang_faq\fR 1\&.0
Documentation tools - doctools language faq
.TP
\fBdoctools_lang_intro\fR 1\&.0
Documentation tools - doctools language introduction
.TP
\fBdoctools_lang_syntax\fR 1\&.0
Documentation tools - doctools language syntax
.TP
\fBdoctools_plugin_apiref\fR 1\&.1
Documentation tools - doctools plugin API reference
.TP
\fBdtplite\fR 1\&.3
Documentation toolbox - Lightweight DocTools Markup Processor
.TP
\fBdtplite\fR 1\&.0\&.5
Documentation toolbox - Lightweight DocTools Markup Processor
.TP
\fBfileutil\fR 1\&.16
file utilities - Procedures implementing some file utilities
.TP
\fBfileutil::magic::cfront\fR 1\&.2\&.0
file utilities - Generator core for compiler of magic(5) files
.TP
\fBfileutil::magic::cgen\fR 1\&.2\&.0
file utilities - Generator core for compiler of magic(5) files
.TP
\fBfileutil::magic::filetype\fR 2\&.0
file utilities - Procedures implementing file-type recognition
.TP
\fBfileutil::magic::rt\fR 2\&.0
file utilities - Runtime core for file type recognition engines written in pure Tcl
.TP
\fBfileutil::multi\fR 0\&.1
file utilities - Multi-file operation, scatter/gather, standard object
.TP
\fBfileutil::multi::op\fR 0\&.5\&.3
file utilities - Multi-file operation, scatter/gather
.TP
\fBfileutil_traverse\fR 0\&.6
file utilities - Iterative directory traversal
.TP
\fBftp\fR 2\&.4\&.13
ftp client - Client-side tcl implementation of the ftp protocol
.TP
\fBftp::geturl\fR 0\&.2\&.2
ftp client - Uri handler for ftp urls
.TP
\fBftpd\fR 1\&.3
Tcl FTP Server Package - Tcl FTP server implementation
.TP
\fBgenerator\fR 0\&.1
Tcl Generator Commands - Procedures for creating and using generators\&.
.TP
\fBgpx\fR 0\&.9
GPS eXchange Format (GPX) - Extracts waypoints, tracks and routes from GPX files
.TP
\fBgrammar::aycock\fR 1\&.0
Aycock-Horspool-Earley parser generator for Tcl - Aycock-Horspool-Earley parser generator for Tcl
.TP
\fBgrammar::fa\fR 0\&.4
Finite automaton operations and usage - Create and manipulate finite automatons
.TP
\fBgrammar::fa::dacceptor\fR 0\&.1\&.1
Finite automaton operations and usage - Create and use deterministic acceptors
.TP
\fBgrammar::fa::dexec\fR 0\&.2
Finite automaton operations and usage - Execute deterministic finite automatons
.TP
\fBgrammar::fa::op\fR 0\&.4
Finite automaton operations and usage - Operations on finite automatons
.TP
\fBgrammar::me::cpu\fR 0\&.2
Grammar operations and usage - Virtual machine implementation II for parsing token streams
.TP
\fBgrammar::me::cpu::core\fR 0\&.2
Grammar operations and usage - ME virtual machine state manipulation
.TP
\fBgrammar::me::cpu::gasm\fR 0\&.1
Grammar operations and usage - ME assembler
.TP
\fBgrammar::me::tcl\fR 0\&.1
Grammar operations and usage - Virtual machine implementation I for parsing token streams
.TP
\fBgrammar::me::util\fR 0\&.1
Grammar operations and usage - AST utilities
.TP
\fBgrammar::me_ast\fR 0\&.1
Grammar operations and usage - Various representations of ASTs
.TP
\fBgrammar::me_intro\fR 0\&.1
Grammar operations and usage - Introduction to virtual machines for parsing token streams
.TP
\fBgrammar::me_vm\fR 0\&.1
Grammar operations and usage - Virtual machine for parsing token streams
.TP
\fBgrammar::peg\fR 0\&.1
Grammar operations and usage - Create and manipulate parsing expression grammars
.TP
\fBgrammar::peg::interp\fR 0\&.1\&.1
Grammar operations and usage - Interpreter for parsing expression grammars
.TP
\fBhook\fR 0\&.1
Hooks - Hooks
.TP
\fBhtml\fR 1\&.4\&.4
HTML Generation - Procedures to generate HTML structures
.TP
\fBhtmlparse\fR 1\&.2\&.2
HTML Parser - Procedures to parse HTML strings
.TP
\fBhuddle\fR 0\&.3
HUDDLE - Create and manipulate huddle object
.TP
\fBident\fR 0\&.42
Identification protocol client - Ident protocol client
.TP
\fBimap4\fR 0\&.5\&.3
imap client - imap client-side tcl implementation of imap protocol
.TP
\fBinifile\fR 0\&.3\&.1
Parsing of Windows INI files - Parsing of Windows INI files
.TP
\fBinterp\fR 0\&.1\&.2
Interpreter utilities - Interp creation and aliasing
.TP
\fBirc\fR 0\&.6\&.2
Low Level Tcl IRC Interface - Create IRC connection and interface\&.
.TP
\fBjavascript\fR 1\&.0\&.2
HTML and Java Script Generation - Procedures to generate HTML and Java Script structures\&.
.TP
\fBjpeg\fR 0\&.5
JPEG image manipulation - JPEG querying and manipulation of meta data
.TP
\fBjson\fR 1\&.3\&.4
JSON - JSON parser
.TP
\fBjson::write\fR 1\&.0\&.3
JSON - JSON generation
.TP
\fBlambda\fR 1
Utility commands for anonymous procedures - Utility commands for anonymous procedures
.TP
\fBldap\fR 1\&.9\&.2
LDAP client - LDAP client
.TP
\fBldapx\fR 1\&.1
LDAP extended object interface - LDAP extended object interface
.TP
\fBlog\fR 1\&.4
Logging facility - Procedures to log messages of libraries and applications\&.
.TP
\fBlogger\fR 0\&.9\&.4
Object Oriented logging facility - System to control logging of events\&.
.TP
\fBlogger::appender\fR 1\&.2
Object Oriented logging facility - Collection of predefined appenders for logger
.TP
\fBlogger::utils\fR 1\&.3
Object Oriented logging facility - Utilities for logger
.TP
\fBmap::geocode::nominatim\fR 0\&.1
Mapping utilities - Resolving geographical names with a Nominatim service
.TP
\fBmap::slippy\fR 0\&.5
Mapping utilities - Common code for slippy based map packages
.TP
\fBmap::slippy::cache\fR 0\&.2
Mapping utilities - Management of a tile cache in the local filesystem
.TP
\fBmap::slippy::fetcher\fR 0\&.4
Mapping utilities - Accessing a server providing tiles for slippy-based maps
.TP
\fBmapproj\fR 0\&.1
Tcl Library - Map projection routines
.TP
\fBmarkdown\fR 1\&.1
Markdown to HTML Converter - Converts Markdown text to HTML
.TP
\fBmath\fR 1\&.2\&.5
Tcl Math Library - Tcl Math Library
.TP
\fBmath::bigfloat\fR 2\&.0\&.1
Tcl Math Library - Arbitrary precision floating-point numbers
.TP
\fBmath::bignum\fR 3\&.1
Tcl Math Library - Arbitrary precision integer numbers
.TP
\fBmath::calculus\fR 0\&.8\&.2
Tcl Math Library - Integration and ordinary differential equations
.TP
\fBmath::calculus::romberg\fR 0\&.6
Tcl Math Library - Romberg integration
.TP
\fBmath::calculus::symdiff\fR 1\&.0\&.1
Symbolic differentiation for Tcl - Symbolic differentiation for Tcl
.TP
\fBmath::combinatorics\fR 1\&.2\&.3
Tcl Math Library - Combinatorial functions in the Tcl Math Library
.TP
\fBmath::complexnumbers\fR 1\&.0\&.2
Tcl Math Library - Straightforward complex number package
.TP
\fBmath::constants\fR 1\&.0\&.2
Tcl Math Library - Mathematical and numerical constants
.TP
\fBmath::decimal\fR 1\&.0\&.3
Tcl Decimal Arithmetic Library - General decimal arithmetic
.TP
\fBmath::exact\fR 1\&.0\&.1
Tcl Math Library - Exact Real Arithmetic
.TP
\fBmath::fourier\fR 1\&.0\&.2
Tcl Math Library - Discrete and fast fourier transforms
.TP
\fBmath::fuzzy\fR 0\&.2
Tcl Math Library - Fuzzy comparison of floating-point numbers
.TP
\fBmath::geometry\fR 1\&.2\&.2
Tcl Math Library - Geometrical computations
.TP
\fBmath::interpolate\fR 1\&.1
Tcl Math Library - Interpolation routines
.TP
\fBmath::linearalgebra\fR 1\&.1\&.5
Tcl Math Library - Linear Algebra
.TP
\fBmath::numtheory\fR 1\&.0
Tcl Math Library - Number Theory
.TP
\fBmath::optimize\fR 1\&.0
Tcl Math Library - Optimisation routines
.TP
\fBmath::PCA\fR 1\&.0
Principal Components Analysis - Package for Principal Component Analysis
.TP
\fBmath::polynomials\fR 1\&.0\&.1
Tcl Math Library - Polynomial functions
.TP
\fBmath::rationalfunctions\fR 1\&.0\&.1
Math - Polynomial functions
.TP
\fBmath::roman\fR tcllib
- Tools for creating and manipulating roman numerals
.TP
\fBmath::special\fR 0\&.3
Tcl Math Library - Special mathematical functions
.TP
\fBmath::statistics\fR 1
Tcl Math Library - Basic statistical functions and procedures
.TP
\fBmd4\fR 1\&.0\&.7
MD4 Message-Digest Algorithm - MD4 Message-Digest Algorithm
.TP
\fBmd5\fR 2\&.0\&.7
MD5 Message-Digest Algorithm - MD5 Message-Digest Algorithm
.TP
\fBmd5crypt\fR 1\&.1\&.0
MD5-based password encryption - MD5-based password encryption
.TP
\fBmime\fR 1\&.6
Mime - Manipulation of MIME body parts
.TP
\fBmpexpand\fR 1\&.0
Documentation toolbox - Markup processor
.TP
\fBmultiplexer\fR 0\&.2
One-to-many communication with sockets\&. - One-to-many communication with sockets\&.
.TP
\fBnameserv\fR 0\&.4\&.2
Name service facility - Name service facility, Client
.TP
\fBnameserv::auto\fR 0\&.3
Name service facility - Name service facility, Client Extension
.TP
\fBnameserv::common\fR 0\&.1
Name service facility - Name service facility, shared definitions
.TP
\fBnameserv::protocol\fR 0\&.1
Name service facility - Name service facility, client/server protocol
.TP
\fBnameserv::server\fR 0\&.3\&.2
Name service facility - Name service facility, Server
.TP
\fBnamespacex\fR 0\&.1
Namespace utility commands - Namespace utility commands
.TP
\fBncgi\fR 1\&.4\&.3
CGI Support - Procedures to manipulate CGI values\&.
.TP
\fBnettool\fR 0\&.5\&.2
nettool - Tools for networked applications
.TP
\fBnmea\fR 1\&.0\&.0
NMEA protocol implementation - Process NMEA data
.TP
\fBnns\fR 1\&.1
Name service facility - Name service facility, Commandline Client Application
.TP
\fBnns_intro\fR 1\&.0
Name service facility - Name service facility, introduction
.TP
\fBnnsd\fR 1\&.0\&.1
Name service facility - Name service facility, Commandline Server Application
.TP
\fBnnslog\fR 1\&.0
Name service facility - Name service facility, Commandline Logging Client Application
.TP
\fBnntp\fR 1\&.5\&.1
Tcl NNTP Client Library - Tcl client for the NNTP protocol
.TP
\fBntp_time\fR 1\&.2\&.1
Network Time Facilities - Tcl Time Service Client
.TP
\fBoauth\fR 1\&.0\&.1
oauth - oauth API base signature
.TP
\fBoo::util\fR 1\&.2\&.2
Utility commands for TclOO - Utility commands for TclOO
.TP
\fBoo::util\fR 1\&.2\&.2
Utility commands for TclOO - Utility commands for TclOO
.TP
\fBoometa\fR 0\&.7\&.1
Data registry for TclOO frameworks - oo::meta A data registry for classess
.TP
\fBotp\fR 1\&.0\&.0
RFC 2289 A One-Time Password System - One-Time Passwords
.TP
\fBpage\fR 1\&.0
Development Tools - Parser Generator
.TP
\fBpage_intro\fR 1\&.0
Parser generator tools - page introduction
.TP
\fBpage_pluginmgr\fR 1\&.0
Parser generator tools - page plugin manager
.TP
\fBpage_util_flow\fR 1\&.0
Parser generator tools - page dataflow/treewalker utility
.TP
\fBpage_util_norm_lemon\fR 1\&.0
Parser generator tools - page AST normalization, LEMON
.TP
\fBpage_util_norm_peg\fR 1\&.0
Parser generator tools - page AST normalization, PEG
.TP
\fBpage_util_peg\fR 1\&.0
Parser generator tools - page PEG transformation utilities
.TP
\fBpage_util_quote\fR 1\&.0
Parser generator tools - page character quoting utilities
.TP
\fBpicoirc\fR 0\&.5\&.2
Simple embeddable IRC interface - Small and simple embeddable IRC client\&.
.TP
\fBpki\fR 0\&.10
public key encryption - Implementation of the public key cipher
.TP
\fBpluginmgr\fR 0\&.3
Plugin management - Manage a plugin
.TP
\fBpng\fR 0\&.1\&.2
Image manipulation - PNG querying and manipulation of meta data
.TP
\fBpop3\fR 1\&.9
Tcl POP3 Client Library - Tcl client for POP3 email protocol
.TP
\fBpop3d\fR 1\&.1\&.0
Tcl POP3 Server Package - Tcl POP3 server implementation
.TP
\fBpop3d::dbox\fR 1\&.0\&.2
Tcl POP3 Server Package - Simple mailbox database for pop3d
.TP
\fBpop3d::udb\fR 1\&.0\&.1
Tcl POP3 Server Package - Simple user database for pop3d
.TP
\fBpractcl\fR 0\&.11
The The Proper Rational API for C to Tool Command Language Module - The Practcl Module
.TP
\fBprofiler\fR 0\&.3
Tcl Profiler - Tcl source code profiler
.TP
\fBpt\fR 1
Parser Tools - Parser Tools Application
.TP
\fBpt::ast\fR 1\&.1
Parser Tools - Abstract Syntax Tree Serialization
.TP
\fBpt::cparam::configuration::critcl\fR 1\&.0\&.2
Parser Tools - C/PARAM, Canned configuration, Critcl
.TP
\fBpt::cparam::configuration::tea\fR 0\&.1
Parser Tools - C/PARAM, Canned configuration, TEA
.TP
\fBpt::json_language\fR 1
Parser Tools - The JSON Grammar Exchange Format
.TP
\fBpt::param\fR 1
Parser Tools - PackRat Machine Specification
.TP
\fBpt::pe\fR 1\&.0\&.1
Parser Tools - Parsing Expression Serialization
.TP
\fBpt::pe::op\fR 1\&.0\&.1
Parser Tools - Parsing Expression Utilities
.TP
\fBpt::peg\fR 1
Parser Tools - Parsing Expression Grammar Serialization
.TP
\fBpt::peg::container\fR 1
Parser Tools - PEG Storage
.TP
\fBpt::peg::container::peg\fR 1
Parser Tools - PEG Storage\&. Canned PEG grammar specification
.TP
\fBpt::peg::export\fR 1
Parser Tools - PEG Export
.TP
\fBpt::peg::export::container\fR 1
Parser Tools - PEG Export Plugin\&. Write CONTAINER format
.TP
\fBpt::peg::export::json\fR 1
Parser Tools - PEG Export Plugin\&. Write JSON format
.TP
\fBpt::peg::export::peg\fR 1
Parser Tools - PEG Export Plugin\&. Write PEG format
.TP
\fBpt::peg::from::container\fR 0
Parser Tools - PEG Conversion\&. From CONTAINER format
.TP
\fBpt::peg::from::json\fR 1
Parser Tools - PEG Conversion\&. Read JSON format
.TP
\fBpt::peg::from::peg\fR 1\&.0\&.3
Parser Tools - PEG Conversion\&. Read PEG format
.TP
\fBpt::peg::import\fR 1
Parser Tools - PEG Import
.TP
\fBpt::peg::import::container\fR 0
Parser Tools - PEG Import Plugin\&. From CONTAINER format
.TP
\fBpt::peg::import::json\fR 1
Parser Tools - PEG Import Plugin\&. Read JSON format
.TP
\fBpt::peg::import::peg\fR 1
Parser Tools - PEG Import Plugin\&. Read PEG format
.TP
\fBpt::peg::interp\fR 1\&.0\&.1
Parser Tools - Interpreter for parsing expression grammars
.TP
\fBpt::peg::to::container\fR 1
Parser Tools - PEG Conversion\&. Write CONTAINER format
.TP
\fBpt::peg::to::cparam\fR 1\&.1\&.2
Parser Tools - PEG Conversion\&. Write CPARAM format
.TP
\fBpt::peg::to::json\fR 1
Parser Tools - PEG Conversion\&. Write JSON format
.TP
\fBpt::peg::to::param\fR 1
Parser Tools - PEG Conversion\&. Write PARAM format
.TP
\fBpt::peg::to::peg\fR 1\&.0\&.2
Parser Tools - PEG Conversion\&. Write PEG format
.TP
\fBpt::peg::to::tclparam\fR 1\&.0\&.3
Parser Tools - PEG Conversion\&. Write TCLPARAM format
.TP
\fBpt::peg_language\fR 1
Parser Tools - PEG Language Tutorial
.TP
\fBpt::pegrammar\fR 1
Parser Tools - Introduction to Parsing Expression Grammars
.TP
\fBpt::pgen\fR 1\&.1
Parser Tools - Parser Generator
.TP
\fBpt::rde\fR 1\&.1
Parser Tools - Parsing Runtime Support, PARAM based
.TP
\fBpt::tclparam::configuration::nx\fR 1\&.0\&.1
Parser Tools - Tcl/PARAM, Canned configuration, NX
.TP
\fBpt::tclparam::configuration::snit\fR 1\&.0\&.2
Parser Tools - Tcl/PARAM, Canned configuration, Snit
.TP
\fBpt::tclparam::configuration::tcloo\fR 1\&.0\&.4
Parser Tools - Tcl/PARAM, Canned configuration, Tcloo
.TP
\fBpt::util\fR 1\&.1
Parser Tools - General utilities
.TP
\fBpt_export_api\fR 1
Parser Tools - Parser Tools Export API
.TP
\fBpt_import_api\fR 1
Parser Tools - Parser Tools Import API
.TP
\fBpt_introduction\fR 1
Parser Tools - Introduction to Parser Tools
.TP
\fBpt_parse_peg\fR 1
Parser Tools - Parser Tools PEG Parser
.TP
\fBpt_parser_api\fR 1
Parser Tools - Parser API
.TP
\fBpt_peg_op\fR 1\&.0\&.1
Parser Tools - Parser Tools PE Grammar Utility Operations
.TP
\fBrc4\fR 1\&.1\&.0
RC4 Stream Cipher - Implementation of the RC4 stream cipher
.TP
\fBrcs\fR 2\&.0\&.2
RCS low level utilities - RCS low level utilities
.TP
\fBreport\fR 0\&.3\&.2
Matrix reports - Create and manipulate report objects
.TP
\fBripemd128\fR 1\&.0\&.5
RIPEMD Message-Digest Algorithm - RIPEMD-128 Message-Digest Algorithm
.TP
\fBripemd160\fR 1\&.0\&.5
RIPEMD Message-Digest Algorithm - RIPEMD-160 Message-Digest Algorithm
.TP
\fBS3\fR 1\&.0\&.3
Amazon S3 Web Service Utilities - Amazon S3 Web Service Interface
.TP
\fBSASL\fR 1\&.3\&.3
Simple Authentication and Security Layer (SASL) - Implementation of SASL mechanisms for Tcl
.TP
\fBSASL::NTLM\fR 1\&.1\&.2
Simple Authentication and Security Layer (SASL) - Implementation of SASL NTLM mechanism for Tcl
.TP
\fBSASL::SCRAM\fR 0\&.1
Simple Authentication and Security Layer (SASL) - Implementation of SASL SCRAM mechanism for Tcl
.TP
\fBSASL::XGoogleToken\fR 1\&.0\&.1
Simple Authentication and Security Layer (SASL) - Implementation of SASL NTLM mechanism for Tcl
.TP
\fBsha1\fR 2\&.0\&.3
SHA-x Message-Digest Algorithm - SHA1 Message-Digest Algorithm
.TP
\fBsha256\fR 1\&.0\&.3
SHA-x Message-Digest Algorithm - SHA256 Message-Digest Algorithm
.TP
\fBsimulation::annealing\fR 0\&.2
Tcl Simulation Tools - Simulated annealing
.TP
\fBsimulation::montecarlo\fR 0\&.1
Tcl Simulation Tools - Monte Carlo simulations
.TP
\fBsimulation::random\fR 0\&.1
Tcl Simulation Tools - Pseudo-random number generators
.TP
\fBsmtp\fR 1\&.4\&.5
smtp client - Client-side tcl implementation of the smtp protocol
.TP
\fBsmtpd\fR 1\&.5
Tcl SMTP Server Package - Tcl SMTP server implementation
.TP
\fBsnit\fR 2\&.3\&.2
Snit's Not Incr Tcl, OO system - Snit's Not Incr Tcl
.TP
\fBsnitfaq\fR 2\&.2
Snit's Not Incr Tcl, OO system - Snit Frequently Asked Questions
.TP
\fBsoundex\fR 1\&.0
Soundex - Soundex
.TP
\fBstooop\fR 4\&.4\&.1
Simple Tcl Only Object Oriented Programming - Object oriented extension\&.
.TP
\fBstring::token\fR 1
Text and string utilities - Regex based iterative lexing
.TP
\fBstring::token::shell\fR 1\&.2
Text and string utilities - Parsing of shell command line
.TP
\fBstringprep\fR 1\&.0\&.1
Preparation of Internationalized Strings - Implementation of stringprep
.TP
\fBstringprep::data\fR 1\&.0\&.1
Preparation of Internationalized Strings - stringprep data tables, generated, internal
.TP
\fBstruct::disjointset\fR 1\&.0
Tcl Data Structures - Disjoint set data structure
.TP
\fBstruct::graph\fR 2\&.4\&.1
Tcl Data Structures - Create and manipulate directed graph objects
.TP
\fBstruct::graph::op\fR 0\&.11\&.3
Tcl Data Structures - Operation for (un)directed graph objects
.TP
\fBstruct::graph_v1\fR 1\&.2\&.1
Tcl Data Structures - Create and manipulate directed graph objects
.TP
\fBstruct::list\fR 1\&.8\&.3
Tcl Data Structures - Procedures for manipulating lists
.TP
\fBstruct::matrix\fR 2\&.0\&.3
Tcl Data Structures - Create and manipulate matrix objects
.TP
\fBstruct::matrix_v1\fR 1\&.2\&.1
Tcl Data Structures - Create and manipulate matrix objects
.TP
\fBstruct::pool\fR 1\&.2\&.3
Tcl Data Structures - Create and manipulate pool objects (of discrete items)
.TP
\fBstruct::prioqueue\fR 1\&.4
Tcl Data Structures - Create and manipulate prioqueue objects
.TP
\fBstruct::queue\fR 1\&.4\&.5
Tcl Data Structures - Create and manipulate queue objects
.TP
\fBstruct::record\fR 1\&.2\&.1
Tcl Data Structures - Define and create records (similar to 'C' structures)
.TP
\fBstruct::set\fR 2\&.2\&.3
Tcl Data Structures - Procedures for manipulating sets
.TP
\fBstruct::skiplist\fR 1\&.3
Tcl Data Structures - Create and manipulate skiplists
.TP
\fBstruct::stack\fR 1\&.5\&.3
Tcl Data Structures - Create and manipulate stack objects
.TP
\fBstruct::tree\fR 2\&.1\&.1
Tcl Data Structures - Create and manipulate tree objects
.TP
\fBstruct::tree_v1\fR 1\&.2\&.2
Tcl Data Structures - Create and manipulate tree objects
.TP
\fBsum\fR 1\&.1\&.2
Cyclic Redundancy Checks - Calculate a sum(1) compatible checksum
.TP
\fBswitched\fR 2\&.2\&.1
Simple Tcl Only Object Oriented Programming - switch/option management\&.
.TP
\fBtar\fR 0\&.11
Tar file handling - Tar file creation, extraction & manipulation
.TP
\fBtcl::chan::cat\fR 1
Reflected/virtual channel support - Concatenation channel
.TP
\fBtcl::chan::core\fR 1
Reflected/virtual channel support - Basic reflected/virtual channel support
.TP
\fBtcl::chan::events\fR 1
Reflected/virtual channel support - Event support for reflected/virtual channels
.TP
\fBtcl::chan::facade\fR 1
Reflected/virtual channel support - Facade channel
.TP
\fBtcl::chan::fifo\fR 1
Reflected/virtual channel support - In-memory fifo channel
.TP
\fBtcl::chan::fifo2\fR 1
Reflected/virtual channel support - In-memory interconnected fifo channels
.TP
\fBtcl::chan::halfpipe\fR 1
Reflected/virtual channel support - In-memory channel, half of a fifo2
.TP
\fBtcl::chan::memchan\fR 1\&.0\&.4
Reflected/virtual channel support - In-memory channel
.TP
\fBtcl::chan::null\fR 1
Reflected/virtual channel support - Null channel
.TP
\fBtcl::chan::nullzero\fR 1
Reflected/virtual channel support - Null/Zero channel combination
.TP
\fBtcl::chan::random\fR 1
Reflected/virtual channel support - Random channel
.TP
\fBtcl::chan::std\fR 1
Reflected/virtual channel support - Standard I/O, unification of stdin and stdout
.TP
\fBtcl::chan::string\fR 1\&.0\&.3
Reflected/virtual channel support - Read-only in-memory channel
.TP
\fBtcl::chan::textwindow\fR 1
Reflected/virtual channel support - Textwindow channel
.TP
\fBtcl::chan::variable\fR 1\&.0\&.4
Reflected/virtual channel support - In-memory channel using variable for storage
.TP
\fBtcl::chan::zero\fR 1
Reflected/virtual channel support - Zero channel
.TP
\fBtcl::randomseed\fR 1
Reflected/virtual channel support - Utilities for random channels
.TP
\fBtcl::transform::adler32\fR 1
Reflected/virtual channel support - Adler32 transformation
.TP
\fBtcl::transform::base64\fR 1
Reflected/virtual channel support - Base64 encoding transformation
.TP
\fBtcl::transform::core\fR 1
Reflected/virtual channel support - Basic reflected/virtual channel transform support
.TP
\fBtcl::transform::counter\fR 1
Reflected/virtual channel support - Counter transformation
.TP
\fBtcl::transform::crc32\fR 1
Reflected/virtual channel support - Crc32 transformation
.TP
\fBtcl::transform::hex\fR 1
Reflected/virtual channel support - Hexadecimal encoding transformation
.TP
\fBtcl::transform::identity\fR 1
Reflected/virtual channel support - Identity transformation
.TP
\fBtcl::transform::limitsize\fR 1
Reflected/virtual channel support - limiting input
.TP
\fBtcl::transform::observe\fR 1
Reflected/virtual channel support - Observer transformation, stream copy
.TP
\fBtcl::transform::otp\fR 1
Reflected/virtual channel support - Encryption via one-time pad
.TP
\fBtcl::transform::rot\fR 1
Reflected/virtual channel support - rot-encryption
.TP
\fBtcl::transform::spacer\fR 1
Reflected/virtual channel support - Space insertation and removal
.TP
\fBtcl::transform::zlib\fR 1
Reflected/virtual channel support - zlib (de)compression
.TP
\fBtclDES\fR 1\&.1
Data Encryption Standard (DES) - Implementation of the DES and triple-DES ciphers
.TP
\fBtclDESjr\fR 1\&.1
Data Encryption Standard (DES) - Implementation of the DES and triple-DES ciphers
.TP
\fBtcldocstrip\fR 1\&.0
Textprocessing toolbox - Tcl-based Docstrip Processor
.TP
\fBtcllib_ip\fR 1\&.4
Domain Name Service - IPv4 and IPv6 address manipulation
.TP
\fBtclrep/machineparameters\fR 1\&.0
tclrep - Compute double precision machine parameters\&.
.TP
\fBtepam\fR 0\&.5\&.0
Tcl's Enhanced Procedure and Argument Manager - An introduction into TEPAM, Tcl's Enhanced Procedure and Argument Manager
.TP
\fBtepam::argument_dialogbox\fR 0\&.5\&.0
Tcl's Enhanced Procedure and Argument Manager - TEPAM argument_dialogbox, reference manual
.TP
\fBtepam::doc_gen\fR 0\&.5\&.0
Tcl's Enhanced Procedure and Argument Manager - TEPAM DOC Generation, reference manual
.TP
\fBtepam::procedure\fR 0\&.5\&.0
Tcl's Enhanced Procedure and Argument Manager - TEPAM procedure, reference manual
.TP
\fBterm\fR 0\&.1
Terminal control - General terminal control
.TP
\fBterm::ansi::code\fR 0\&.2
Terminal control - Helper for control sequences
.TP
\fBterm::ansi::code::attr\fR 0\&.1
Terminal control - ANSI attribute sequences
.TP
\fBterm::ansi::code::ctrl\fR 0\&.2
Terminal control - ANSI control sequences
.TP
\fBterm::ansi::code::macros\fR 0\&.1
Terminal control - Macro sequences
.TP
\fBterm::ansi::ctrl::unix\fR 0\&.1\&.1
Terminal control - Control operations and queries
.TP
\fBterm::ansi::send\fR 0\&.2
Terminal control - Output of ANSI control sequences to terminals
.TP
\fBterm::interact::menu\fR 0\&.1
Terminal control - Terminal widget, menu
.TP
\fBterm::interact::pager\fR 0\&.1
Terminal control - Terminal widget, paging
.TP
\fBterm::receive\fR 0\&.1
Terminal control - General input from terminals
.TP
\fBterm::receive::bind\fR 0\&.1
Terminal control - Keyboard dispatch from terminals
.TP
\fBterm::send\fR 0\&.1
Terminal control - General output to terminals
.TP
\fBtextutil\fR 0\&.8
Text and string utilities, macro processing - Procedures to manipulate texts and strings\&.
.TP
\fBtextutil::adjust\fR 0\&.7\&.3
Text and string utilities, macro processing - Procedures to adjust, indent, and undent paragraphs
.TP
\fBtextutil::expander\fR 1\&.3\&.1
Text and string utilities, macro processing - Procedures to process templates and expand text\&.
.TP
\fBtextutil::repeat\fR 0\&.7\&.1
Text and string utilities, macro processing - Procedures to repeat strings\&.
.TP
\fBtextutil::split\fR 0\&.8
Text and string utilities, macro processing - Procedures to split texts
.TP
\fBtextutil::string\fR 0\&.8
Text and string utilities, macro processing - Procedures to manipulate texts and strings\&.
.TP
\fBtextutil::tabify\fR 0\&.7
Text and string utilities, macro processing - Procedures to (un)tabify strings
.TP
\fBtextutil::trim\fR 0\&.7
Text and string utilities, macro processing - Procedures to trim strings
.TP
\fBthrow\fR 1
Forward compatibility implementation of [throw] - throw - Throw an error exception with a message
.TP
\fBtie\fR 1\&.1
Tcl Data Structures - Array persistence
.TP
\fBtie\fR 1\&.1
Tcl Data Structures - Array persistence, standard data sources
.TP
\fBtiff\fR 0\&.2\&.1
TIFF image manipulation - TIFF reading, writing, and querying and manipulation of meta data
.TP
\fBtool\fR 4\&.1\&.1
Tcl Web Server - A TclOO and coroutine based web server
.TP
\fBtool\fR 0\&.4\&.2
Standardized OO Framework for development - TclOO Library (TOOL) Framework
.TP
\fBtool-ui\fR 0\&.2\&.1
Tao User Interface (TaoUI) - Abstractions to allow Tao to express Native Tk, HTML5, and Tao-Layout interfaces
.TP
\fBtool::dict_ensemble\fR 0\&.4\&.2
Standardized OO Framework for development - Dictionary Tools
.TP
\fBtransfer::connect\fR 0\&.2
Data transfer facilities - Connection setup
.TP
\fBtransfer::copy\fR 0\&.2
Data transfer facilities - Data transfer foundation
.TP
\fBtransfer::copy::queue\fR 0\&.1
Data transfer facilities - Queued transfers
.TP
\fBtransfer::data::destination\fR 0\&.2
Data transfer facilities - Data destination
.TP
\fBtransfer::data::source\fR 0\&.2
Data transfer facilities - Data source
.TP
\fBtransfer::receiver\fR 0\&.2
Data transfer facilities - Data source
.TP
\fBtransfer::transmitter\fR 0\&.2
Data transfer facilities - Data source
.TP
\fBtreeql\fR 1\&.3\&.1
Tree Query Language - Query tree objects
.TP
\fBtry\fR 1
Forward compatibility implementation of [try] - try - Trap and process errors and exceptions
.TP
\fBudpcluster\fR 0\&.3\&.3
Lightweight UDP based tool for cluster node discovery - UDP Peer-to-Peer cluster
.TP
\fBuevent\fR 0\&.3\&.1
User events - User events
.TP
\fBuevent::onidle\fR 0\&.1
User events - Request merging and deferal to idle time
.TP
\fBunicode\fR 1\&.0\&.0
Unicode normalization - Implementation of Unicode normalization
.TP
\fBunicode::data\fR 1\&.0\&.0
Preparation of Internationalized Strings - unicode data tables, generated, internal
.TP
\fBunits\fR 1\&.2
Convert and manipulate quantities with units - unit conversion
.TP
\fBuri\fR 1\&.2\&.7
Tcl Uniform Resource Identifier Management - URI utilities
.TP
\fBuri_urn\fR 1\&.0\&.3
Tcl Uniform Resource Identifier Management - URI utilities, URN scheme
.TP
\fBuuencode\fR 1\&.1\&.4
Text encoding & decoding binary data - UU-encode/decode binary data
.TP
\fBuuid\fR 1\&.0\&.6
uuid - UUID generation and comparison
.TP
\fBvaltype::common\fR 1
Validation types - Validation, common code
.TP
\fBvaltype::creditcard::amex\fR 1
Validation types - Validation for AMEX creditcard number
.TP
\fBvaltype::creditcard::discover\fR 1
Validation types - Validation for Discover creditcard number
.TP
\fBvaltype::creditcard::mastercard\fR 1
Validation types - Validation for Mastercard creditcard number
.TP
\fBvaltype::creditcard::visa\fR 1
Validation types - Validation for VISA creditcard number
.TP
\fBvaltype::gs1::ean13\fR 1
Validation types - Validation for EAN13
.TP
\fBvaltype::iban\fR 1\&.7
Validation types - Validation for IBAN
.TP
\fBvaltype::imei\fR 1
Validation types - Validation for IMEI
.TP
\fBvaltype::isbn\fR 1
Validation types - Validation for ISBN
.TP
\fBvaltype::luhn\fR 1
Validation types - Validation for plain number with a LUHN checkdigit
.TP
\fBvaltype::luhn5\fR 1
Validation types - Validation for plain number with a LUHN5 checkdigit
.TP
\fBvaltype::usnpi\fR 1
Validation types - Validation for USNPI
.TP
\fBvaltype::verhoeff\fR 1
Validation types - Validation for plain number with a VERHOEFF checkdigit
.TP
\fBwebsocket\fR 1\&.3\&.1
websocket client and server - Tcl implementation of the websocket protocol
.TP
\fBwip\fR 2\&.2
Word Interpreter - Word Interpreter
.TP
\fBxsxp\fR 1\&.0
Amazon S3 Web Service Utilities - eXtremely Simple Xml Parser
.TP
\fByaml\fR 0\&.4\&.1
YAML processing - YAML Format Encoder/Decoder
.TP
\fByencode\fR 1\&.1\&.2
Text encoding & decoding binary data - Y-encode/decode binary data
.PP