/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.schedule;

import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.traccar.Context;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;

public class TaskDeviceInactivityCheck
implements Runnable {
    public static final String ATTRIBUTE_DEVICE_INACTIVITY_START = "deviceInactivityStart";
    public static final String ATTRIBUTE_DEVICE_INACTIVITY_PERIOD = "deviceInactivityPeriod";
    public static final String ATTRIBUTE_LAST_UPDATE = "lastUpdate";
    private static final long CHECK_PERIOD_MINUTES = 15L;

    public void schedule(ScheduledExecutorService executor) {
        executor.scheduleAtFixedRate(this, 15L, 15L, TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        long currentTime = System.currentTimeMillis();
        long checkPeriod = TimeUnit.MINUTES.toMillis(15L);
        HashMap<Event, Position> events = new HashMap<Event, Position>();
        for (Device device : Context.getDeviceManager().getAllDevices()) {
            if (device.getLastUpdate() == null || !this.checkDevice(device, currentTime, checkPeriod)) continue;
            Event event = new Event("deviceInactive", device.getId());
            event.set(ATTRIBUTE_LAST_UPDATE, device.getLastUpdate().getTime());
            events.put(event, null);
        }
        Context.getNotificationManager().updateEvents(events);
    }

    private boolean checkDevice(Device device, long currentTime, long checkPeriod) {
        long timeThreshold;
        long deviceInactivityStart = device.getLong(ATTRIBUTE_DEVICE_INACTIVITY_START);
        if (deviceInactivityStart > 0L && currentTime >= (timeThreshold = device.getLastUpdate().getTime() + deviceInactivityStart)) {
            if (currentTime - checkPeriod < timeThreshold) {
                return true;
            }
            long deviceInactivityPeriod = device.getLong(ATTRIBUTE_DEVICE_INACTIVITY_PERIOD);
            if (deviceInactivityPeriod > 0L) {
                long count;
                return currentTime - checkPeriod < (timeThreshold += (count = (currentTime - timeThreshold - 1L) / deviceInactivityPeriod) * deviceInactivityPeriod);
            }
        }
        return false;
    }
}

