/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.sql.SQLException;
import javax.annotation.security.PermitAll;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.traccar.Context;
import org.traccar.api.BaseResource;
import org.traccar.helper.LogAction;
import org.traccar.model.Server;

@Path(value="server")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ServerResource
extends BaseResource {
    @PermitAll
    @GET
    public Server get(@QueryParam(value="force") boolean force) throws SQLException {
        if (force) {
            return Context.getDataManager().getServer();
        }
        return Context.getPermissionsManager().getServer();
    }

    @PUT
    public Response update(Server entity) throws SQLException {
        Context.getPermissionsManager().checkAdmin(this.getUserId());
        Context.getPermissionsManager().updateServer(entity);
        LogAction.edit(this.getUserId(), entity);
        return Response.ok((Object)entity).build();
    }

    @Path(value="geocode")
    @GET
    public String geocode(@QueryParam(value="latitude") double latitude, @QueryParam(value="longitude") double longitude) {
        if (Context.getGeocoder() != null) {
            return Context.getGeocoder().getAddress(latitude, longitude, null);
        }
        throw new RuntimeException("Reverse geocoding is not enabled");
    }
}

