/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.util.Collection;
import java.util.HashSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.traccar.Context;
import org.traccar.api.ExtendedObjectResource;
import org.traccar.database.CommandsManager;
import org.traccar.model.Command;
import org.traccar.model.Typed;

@Path(value="commands")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CommandResource
extends ExtendedObjectResource<Command> {
    public CommandResource() {
        super(Command.class);
    }

    @GET
    @Path(value="send")
    public Collection<Command> get(@QueryParam(value="deviceId") long deviceId) {
        Context.getPermissionsManager().checkDevice(this.getUserId(), deviceId);
        CommandsManager commandsManager = Context.getCommandsManager();
        HashSet<Long> result = new HashSet<Long>(commandsManager.getUserItems(this.getUserId()));
        result.retainAll(commandsManager.getSupportedCommands(deviceId));
        return commandsManager.getItems(result);
    }

    @POST
    @Path(value="send")
    public Response send(Command entity) throws Exception {
        Context.getPermissionsManager().checkReadonly(this.getUserId());
        long deviceId = entity.getDeviceId();
        long id = entity.getId();
        Context.getPermissionsManager().checkDevice(this.getUserId(), deviceId);
        if (id != 0L) {
            Context.getPermissionsManager().checkPermission(Command.class, this.getUserId(), id);
            Context.getPermissionsManager().checkUserDeviceCommand(this.getUserId(), deviceId, id);
        } else {
            Context.getPermissionsManager().checkLimitCommands(this.getUserId());
        }
        if (!Context.getCommandsManager().sendCommand(entity)) {
            return Response.accepted((Object)entity).build();
        }
        return Response.ok((Object)entity).build();
    }

    @GET
    @Path(value="types")
    public Collection<Typed> get(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="protocol") String protocol, @QueryParam(value="textChannel") boolean textChannel) {
        if (deviceId != 0L) {
            Context.getPermissionsManager().checkDevice(this.getUserId(), deviceId);
            return Context.getCommandsManager().getCommandTypes(deviceId, textChannel);
        }
        if (protocol != null) {
            return Context.getCommandsManager().getCommandTypes(protocol, textChannel);
        }
        return Context.getCommandsManager().getAllCommandTypes();
    }
}

