/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import java.util.Vector;

public class Rights
implements Cloneable {
    private boolean[] rights = new boolean[128];

    public Rights() {
    }

    public Rights(Rights rights) {
        System.arraycopy(rights.rights, 0, this.rights, 0, this.rights.length);
    }

    public Rights(String string) {
        int n = 0;
        while (n < string.length()) {
            this.add(Right.getInstance(string.charAt(n)));
            ++n;
        }
    }

    public Rights(Right right) {
        this.rights[right.right] = true;
    }

    public void add(Right right) {
        this.rights[right.right] = true;
    }

    public void add(Rights rights) {
        int n = 0;
        while (n < rights.rights.length) {
            if (rights.rights[n]) {
                this.rights[n] = true;
            }
            ++n;
        }
    }

    public void remove(Right right) {
        this.rights[right.right] = false;
    }

    public void remove(Rights rights) {
        int n = 0;
        while (n < rights.rights.length) {
            if (rights.rights[n]) {
                this.rights[n] = false;
            }
            ++n;
        }
    }

    public boolean contains(Right right) {
        return this.rights[right.right];
    }

    public boolean contains(Rights rights) {
        int n = 0;
        while (n < rights.rights.length) {
            if (rights.rights[n] && !this.rights[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rights)) {
            return false;
        }
        Rights rights = (Rights)object;
        int n = 0;
        while (n < rights.rights.length) {
            if (rights.rights[n] != this.rights[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.rights.length) {
            if (this.rights[n2]) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public Right[] getRights() {
        Vector<Right> vector = new Vector<Right>();
        int n = 0;
        while (n < this.rights.length) {
            if (this.rights[n]) {
                vector.addElement(Right.getInstance((char)n));
            }
            ++n;
        }
        Object[] objectArray = new Right[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object clone() {
        Rights rights = null;
        try {
            rights = (Rights)super.clone();
            rights.rights = new boolean[128];
            System.arraycopy(this.rights, 0, rights.rights, 0, this.rights.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return rights;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.rights.length) {
            if (this.rights[n]) {
                stringBuffer.append((char)n);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final class Right {
        private static Right[] cache = new Right[128];
        public static final Right LOOKUP = Right.getInstance('l');
        public static final Right READ = Right.getInstance('r');
        public static final Right KEEP_SEEN = Right.getInstance('s');
        public static final Right WRITE = Right.getInstance('w');
        public static final Right INSERT = Right.getInstance('i');
        public static final Right POST = Right.getInstance('p');
        public static final Right CREATE = Right.getInstance('c');
        public static final Right DELETE = Right.getInstance('d');
        public static final Right ADMINISTER = Right.getInstance('a');
        char right;

        private Right(char c) {
            if (c >= '\u0080') {
                throw new IllegalArgumentException("Right must be ASCII");
            }
            this.right = c;
        }

        public static synchronized Right getInstance(char c) {
            if (c >= '\u0080') {
                throw new IllegalArgumentException("Right must be ASCII");
            }
            if (cache[c] == null) {
                Right.cache[c] = new Right(c);
            }
            return cache[c];
        }

        public String toString() {
            return String.valueOf(this.right);
        }
    }
}

