/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfHandlerZk
extends SecurityConfHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public SecurityConfHandlerZk(CoreContainer coreContainer) {
        super(coreContainer);
    }

    @Override
    public SecurityConfHandler.SecurityConfig getSecurityConfig(boolean getFresh) {
        ZkStateReader.ConfigData configDataFromZk = this.cores.getZkController().getZkStateReader().getSecurityProps(getFresh);
        return configDataFromZk == null ? new SecurityConfHandler.SecurityConfig() : new SecurityConfHandler.SecurityConfig().setData(configDataFromZk.data).setVersion(configDataFromZk.version);
    }

    @Override
    protected void getConf(SolrQueryResponse rsp, String key) {
        Object o;
        ZkStateReader.ConfigData map = this.cores.getZkController().getZkStateReader().getSecurityProps(false);
        Object v0 = o = map == null ? null : map.data.get(key);
        if (o == null) {
            rsp.add("errorMessages", Collections.singletonList("No " + key + " configured"));
        } else {
            rsp.add(key + ".enabled", this.getPlugin(key) != null);
            rsp.add(key, o);
        }
    }

    @Override
    protected boolean persistConf(SecurityConfHandler.SecurityConfig securityConfig) throws IOException {
        try {
            this.cores.getZkController().getZkClient().setData("/security.json", Utils.toJSON(securityConfig.getData()), securityConfig.getVersion(), true);
            log.debug("Persisted security.json to {}", (Object)"/security.json");
            return true;
        }
        catch (KeeperException.BadVersionException bdve) {
            log.warn("Failed persisting security.json to {}", (Object)"/security.json", (Object)bdve);
            return false;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to persist security.json", (Throwable)e);
        }
    }

    @Override
    public String getDescription() {
        return "Edit or read security configuration from Zookeeper";
    }
}

