/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.data.i2np.UnknownI2NPMessage;

public class TunnelGatewayMessage
extends FastI2NPMessageImpl {
    private TunnelId _tunnelId;
    private I2NPMessage _msg;
    private byte[] _msgData;
    public static final int MESSAGE_TYPE = 19;
    private static final int EXPIRATION_PERIOD = 10000;

    public TunnelGatewayMessage(I2PAppContext context) {
        super(context);
        this.setMessageExpiration(context.clock().now() + 10000L);
    }

    public TunnelId getTunnelId() {
        return this._tunnelId;
    }

    public void setTunnelId(TunnelId id) {
        if (this._tunnelId != null) {
            throw new IllegalStateException();
        }
        this._tunnelId = id;
    }

    public I2NPMessage getMessage() {
        return this._msg;
    }

    public void setMessage(I2NPMessage msg) {
        if (this._msg != null) {
            throw new IllegalStateException();
        }
        if (msg == null) {
            throw new IllegalArgumentException("dont set me to null!");
        }
        this._msg = msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int calculateWrittenLength() {
        TunnelGatewayMessage tunnelGatewayMessage = this;
        synchronized (tunnelGatewayMessage) {
            if (this._msgData == null) {
                this._msgData = this._msg.toByteArray();
                this._msg = null;
            }
        }
        return this._msgData.length + 4 + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._tunnelId == null || this._msg == null && this._msgData == null) {
            this._log.log(50, "failing to write out gateway message");
            throw new I2NPMessageException("Not enough data to write out (id=" + this._tunnelId + " data=" + this._msg + ")");
        }
        DataHelper.toLong(out, curIndex, 4, this._tunnelId.getTunnelId());
        curIndex += 4;
        TunnelGatewayMessage tunnelGatewayMessage = this;
        synchronized (tunnelGatewayMessage) {
            if (this._msgData == null) {
                this._msgData = this._msg.toByteArray();
                this._msg = null;
            }
        }
        DataHelper.toLong(out, curIndex, 2, this._msgData.length);
        if ((curIndex += 2) + this._msgData.length > out.length) {
            String txt = "output buffer too small idx: " + curIndex + " len: " + this._msgData.length + " outlen: " + out.length;
            this._log.error(txt);
            throw new I2NPMessageException(txt);
        }
        System.arraycopy(this._msgData, 0, out, curIndex, this._msgData.length);
        return curIndex += this._msgData.length;
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        this.readMessage(data, offset, dataSize, type, null);
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type, I2NPMessageHandler handler) throws I2NPMessageException {
        if (type != 19) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        this._tunnelId = new TunnelId(DataHelper.fromLong(data, curIndex, 4));
        curIndex += 4;
        if (this._tunnelId.getTunnelId() <= 0L) {
            throw new I2NPMessageException("Invalid tunnel Id " + this._tunnelId);
        }
        int len = (int)DataHelper.fromLong(data, curIndex, 2);
        if (len <= 1 || (curIndex += 2) + len > data.length || len > dataSize - 6) {
            throw new I2NPMessageException("I2NP length in TGM: " + len + " but remaining bytes: " + Math.min(data.length - curIndex, dataSize - 6));
        }
        int utype = data[curIndex++] & 0xFF;
        UnknownI2NPMessage umsg = new UnknownI2NPMessage(this._context, utype);
        umsg.readBytes(data, utype, curIndex);
        this._msg = umsg;
    }

    @Override
    public int getType() {
        return 19;
    }

    public int hashCode() {
        return DataHelper.hashCode(this.getTunnelId()) + DataHelper.hashCode(this._msg);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TunnelGatewayMessage) {
            TunnelGatewayMessage msg = (TunnelGatewayMessage)object;
            return DataHelper.eq(this.getTunnelId(), msg.getTunnelId()) && DataHelper.eq(this._msgData, msg._msgData) && DataHelper.eq(this.getMessage(), msg.getMessage());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[TunnelGatewayMessage:");
        buf.append(" Tunnel ID: ").append(this.getTunnelId());
        buf.append(" Message: ").append(this._msg);
        buf.append("]");
        return buf.toString();
    }
}

