/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.SummaryRenderer;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.stat.RateSummaryListener;
import net.i2p.util.Log;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.Archive;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdException;
import org.rrd4j.core.RrdMemoryBackendFactory;
import org.rrd4j.core.Sample;

public class SummaryListener
implements RateSummaryListener {
    public static final String PROP_PERSISTENT = "routerconsole.graphPersistent";
    static final String RRD_DIR = "rrd";
    static final String RRD_PREFIX = "rrd-";
    static final String RRD_SUFFIX = ".jrb";
    static final ConsolFun CF = ConsolFun.AVERAGE;
    static final DsType DS = DsType.GAUGE;
    private static final double XFF = 0.9;
    private static final int STEPS = 1;
    private final I2PAppContext _context = I2PAppContext.getGlobalContext();
    private final Log _log;
    private final Rate _rate;
    private final boolean _isPersistent;
    private String _name;
    private String _eventName;
    private RrdDb _db;
    private Sample _sample;
    private SummaryRenderer _renderer;
    private int _rows;
    static final int PERIODS = 1440;
    private static final int MIN_ROWS = 1440;
    public static final int MAX_ROWS = 131040;
    private static final long THREE_MONTHS = 7862400000L;

    public SummaryListener(Rate r) {
        this._rate = r;
        this._log = this._context.logManager().getLog(SummaryListener.class);
        this._isPersistent = this._context.getBooleanPropertyDefaultTrue(PROP_PERSISTENT);
    }

    @Override
    public void add(double totalValue, long eventCount, double totalEventTime, long period) {
        long now = this.now();
        long when = now / 1000L;
        if (this._db != null) {
            try {
                this._sample.setTime(when);
                double val = eventCount > 0L ? totalValue / (double)eventCount : 0.0;
                this._sample.setValue(this._name, val);
                this._sample.setValue(this._eventName, (double)eventCount);
                this._sample.update();
            }
            catch (IllegalArgumentException iae) {
                this._log.error("Error adding", iae);
                String path = this._isPersistent ? this._db.getPath() : null;
                this.stopListening();
                if (path != null) {
                    new File(path).delete();
                }
            }
            catch (RrdException re) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error adding", re);
                }
            }
            catch (IOException ioe) {
                this._log.error("Error adding", ioe);
                this.stopListening();
            }
        }
    }

    static String createName(I2PAppContext ctx, String wanted) {
        return ctx.sha().calculateHash(DataHelper.getUTF8(wanted)).toBase64().substring(0, 20);
    }

    public Rate getRate() {
        return this._rate;
    }

    public boolean startListening() {
        RateStat rs = this._rate.getRateStat();
        long period = this._rate.getPeriod();
        String baseName = rs.getName() + "." + period;
        this._name = SummaryListener.createName(this._context, baseName);
        this._eventName = SummaryListener.createName(this._context, baseName + ".events");
        File rrdFile = null;
        try {
            String rrdDefName;
            RrdBackendFactory factory = this.getBackendFactory();
            if (this._isPersistent) {
                SecureFile rrdDir = new SecureFile(this._context.getRouterDir(), RRD_DIR);
                rrdFile = new File(rrdDir, RRD_PREFIX + this._name + RRD_SUFFIX);
                rrdDefName = rrdFile.getAbsolutePath();
                if (rrdFile.exists()) {
                    this._db = RrdDb.getBuilder().setPath(rrdDefName).setBackendFactory(factory).build();
                    Archive arch = this._db.getArchive(CF, 1);
                    if (arch == null) {
                        throw new IOException("No average CF in " + rrdDefName);
                    }
                    this._rows = arch.getRows();
                    if (this._log.shouldLog(20)) {
                        this._log.info("Existing RRD " + baseName + " (" + rrdDefName + ") with " + this._rows + " rows consuming " + this._db.getRrdBackend().getLength() + " bytes");
                    }
                } else {
                    ((File)rrdDir).mkdir();
                }
            } else {
                rrdDefName = this._name;
            }
            if (this._db == null) {
                RrdDef def = new RrdDef(rrdDefName, this.now() / 1000L, period / 1000L);
                long heartbeat = period * 10L / 1000L;
                def.addDatasource(this._name, DS, heartbeat, Double.NaN, Double.NaN);
                def.addDatasource(this._eventName, DS, heartbeat, 0.0, Double.NaN);
                this._rows = this._isPersistent ? (int)Math.max(1440L, Math.min(131040L, 7862400000L / period)) : 1440;
                def.addArchive(CF, 0.9, 1, this._rows);
                this._db = RrdDb.getBuilder().setRrdDef(def).setBackendFactory(factory).build();
                if (this._isPersistent) {
                    SecureFileOutputStream.setPerms(new File(rrdDefName));
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("New RRD " + baseName + " (" + rrdDefName + ") with " + this._rows + " rows consuming " + this._db.getRrdBackend().getLength() + " bytes");
                }
            }
            this._sample = this._db.createSample();
            this._renderer = new SummaryRenderer(this._context, this);
            this._rate.setSummaryListener(this);
            return true;
        }
        catch (OutOfMemoryError oom) {
            this._log.error("Error starting RRD for stat " + baseName, oom);
        }
        catch (RrdException re) {
            this._log.error("Error starting RRD for stat " + baseName, re);
            if (this._isPersistent && rrdFile != null) {
                rrdFile.delete();
            }
        }
        catch (IOException ioe) {
            this._log.error("Error starting RRD for stat " + baseName, ioe);
        }
        catch (IllegalArgumentException iae) {
            this._log.error("Error starting RRD for stat " + baseName, iae);
            this._log.log(50, "rrd4j backend error, graphs disabled");
            System.out.println("rrd4j backend error, graphs disabled");
            StatSummarizer.setDisabled(this._context);
        }
        catch (NoSuchMethodError nsme) {
            this._log.error("Error starting RRD for stat " + baseName, nsme);
            String s = "Error:\nCompiler JDK mismatch with JRE version " + System.getProperty("java.version") + " and no bootclasspath specified when building.\nContact packager.";
            this._log.log(50, s);
            System.out.println(s);
            StatSummarizer.setDisabled(this._context);
        }
        catch (Throwable t) {
            this._log.error("Error starting RRD for stat " + baseName, t);
        }
        return false;
    }

    public void stopListening() {
        if (this._db == null) {
            return;
        }
        try {
            this._db.close();
        }
        catch (IOException ioe) {
            this._log.error("Error closing", ioe);
        }
        this._rate.setSummaryListener(null);
        if (!this._isPersistent) {
            ((RrdMemoryBackendFactory)SummaryListener.getBackendFactory(false)).delete(this._db.getPath());
        }
        this._db = null;
    }

    public void renderPng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        this.renderPng(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit, null, null);
    }

    public void renderPng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit, SummaryListener lsnr2, String titleOverride) throws IOException {
        if (this._renderer == null || this._db == null) {
            throw new IOException("No RRD, check logs for previous errors");
        }
        this._renderer.render(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit, lsnr2, titleOverride);
    }

    public void renderPng(OutputStream out) throws IOException {
        if (this._renderer == null || this._db == null) {
            throw new IOException("No RRD, check logs for previous errors");
        }
        this._renderer.render(out);
    }

    String getName() {
        return this._name;
    }

    String getEventName() {
        return this._eventName;
    }

    RrdDb getData() {
        return this._db;
    }

    long now() {
        return this._context.clock().now();
    }

    RrdBackendFactory getBackendFactory() {
        return SummaryListener.getBackendFactory(this._isPersistent);
    }

    private static RrdBackendFactory getBackendFactory(boolean isPersistent) {
        return isPersistent ? RrdBackendFactory.getDefaultFactory() : RrdBackendFactory.getFactory("MEMORY");
    }

    int getRows() {
        return this._rows;
    }

    public boolean equals(Object obj) {
        return obj instanceof SummaryListener && ((SummaryListener)obj)._rate.equals(this._rate);
    }

    public int hashCode() {
        return this._rate.hashCode();
    }
}

