/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.processing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResourceSerializer;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.InterningStringSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.SetSerializer;

public class AnnotationProcessingData {
    private final Map<String, Set<String>> generatedTypesByOrigin;
    private final Set<String> aggregatedTypes;
    private final Set<String> generatedTypesDependingOnAllOthers;
    private final Map<String, Set<GeneratedResource>> generatedResourcesByOrigin;
    private final Set<GeneratedResource> generatedResourcesDependingOnAllOthers;
    private final String fullRebuildCause;

    public AnnotationProcessingData() {
        this((Map<String, Set<String>>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Map<String, Set<GeneratedResource>>)ImmutableMap.of(), (Set<GeneratedResource>)ImmutableSet.of(), null);
    }

    public AnnotationProcessingData(Map<String, Set<String>> generatedTypesByOrigin, Set<String> aggregatedTypes, Set<String> generatedTypesDependingOnAllOthers, Map<String, Set<GeneratedResource>> generatedResourcesByOrigin, Set<GeneratedResource> generatedResourcesDependingOnAllOthers, String fullRebuildCause) {
        this.generatedTypesByOrigin = ImmutableMap.copyOf(generatedTypesByOrigin);
        this.aggregatedTypes = ImmutableSet.copyOf(aggregatedTypes);
        this.generatedTypesDependingOnAllOthers = ImmutableSet.copyOf(generatedTypesDependingOnAllOthers);
        this.generatedResourcesByOrigin = ImmutableMap.copyOf(generatedResourcesByOrigin);
        this.generatedResourcesDependingOnAllOthers = ImmutableSet.copyOf(generatedResourcesDependingOnAllOthers);
        this.fullRebuildCause = fullRebuildCause;
    }

    public boolean participatesInClassGeneration(String clazzName) {
        return this.aggregatedTypes.contains(clazzName) || this.generatedTypesByOrigin.containsKey(clazzName);
    }

    public boolean participatesInResourceGeneration(String clazzName) {
        return this.aggregatedTypes.contains(clazzName) || this.generatedResourcesByOrigin.containsKey(clazzName);
    }

    public Map<String, Set<String>> getGeneratedTypesByOrigin() {
        return this.generatedTypesByOrigin;
    }

    public Set<String> getAggregatedTypes() {
        return this.aggregatedTypes;
    }

    public Set<String> getGeneratedTypesDependingOnAllOthers() {
        return this.generatedTypesDependingOnAllOthers;
    }

    public Map<String, Set<GeneratedResource>> getGeneratedResourcesByOrigin() {
        return this.generatedResourcesByOrigin;
    }

    public Set<GeneratedResource> getGeneratedResourcesDependingOnAllOthers() {
        return this.generatedResourcesDependingOnAllOthers;
    }

    public String getFullRebuildCause() {
        return this.fullRebuildCause;
    }

    public static final class Serializer
    extends AbstractSerializer<AnnotationProcessingData> {
        private final SetSerializer<String> typesSerializer;
        private final MapSerializer<String, Set<String>> generatedTypesSerializer;
        private final SetSerializer<GeneratedResource> resourcesSerializer;
        private final MapSerializer<String, Set<GeneratedResource>> generatedResourcesSerializer;

        public Serializer(StringInterner interner) {
            InterningStringSerializer stringSerializer = new InterningStringSerializer(interner);
            this.typesSerializer = new SetSerializer((org.gradle.internal.serialize.Serializer)stringSerializer);
            this.generatedTypesSerializer = new MapSerializer((org.gradle.internal.serialize.Serializer)stringSerializer, this.typesSerializer);
            GeneratedResourceSerializer resourceSerializer = new GeneratedResourceSerializer((org.gradle.internal.serialize.Serializer<String>)stringSerializer);
            this.resourcesSerializer = new SetSerializer((org.gradle.internal.serialize.Serializer)resourceSerializer);
            this.generatedResourcesSerializer = new MapSerializer((org.gradle.internal.serialize.Serializer)stringSerializer, this.resourcesSerializer);
        }

        public AnnotationProcessingData read(Decoder decoder) throws Exception {
            Map generatedTypes = this.generatedTypesSerializer.read(decoder);
            Set aggregatedTypes = (Set)this.typesSerializer.read(decoder);
            Set generatedTypesDependingOnAllOthers = (Set)this.typesSerializer.read(decoder);
            String fullRebuildCause = decoder.readNullableString();
            Map generatedResources = this.generatedResourcesSerializer.read(decoder);
            Set generatedResourcesDependingOnAllOthers = (Set)this.resourcesSerializer.read(decoder);
            return new AnnotationProcessingData(generatedTypes, aggregatedTypes, generatedTypesDependingOnAllOthers, generatedResources, generatedResourcesDependingOnAllOthers, fullRebuildCause);
        }

        public void write(Encoder encoder, AnnotationProcessingData value) throws Exception {
            this.generatedTypesSerializer.write(encoder, value.generatedTypesByOrigin);
            this.typesSerializer.write(encoder, (Collection)value.aggregatedTypes);
            this.typesSerializer.write(encoder, (Collection)value.generatedTypesDependingOnAllOthers);
            encoder.writeNullableString((CharSequence)value.fullRebuildCause);
            this.generatedResourcesSerializer.write(encoder, value.generatedResourcesByOrigin);
            this.resourcesSerializer.write(encoder, (Collection)value.generatedResourcesDependingOnAllOthers);
        }
    }
}

