'''OpenGL extension NV.register_combiners2

This module customises the behaviour of the 
OpenGL.raw.GL.NV.register_combiners2 to provide a more 
Python-friendly API

Overview (from the spec)
	
	The NV_register_combiners extension provides a powerful fragment
	coloring mechanism.  This specification extends the register combiners
	functionality to support more color constant values that are unique
	for each general combiner stage.
	
	The base register combiners functionality supports only two color
	constants.  These two constants are available in every general
	combiner stage and in the final combiner.
	
	When many general combiner stages are supported, more than two
	unique color constants is often required.  The obvious way to extend
	the register combiners is to add several more color constant
	registers.  But adding new unique color constant registers is
	expensive for hardware implementation because every color constant
	register must be available as an input to any stage.
	
	In practice however, it is the total set of general combiner stages
	that requires more color constants, not each and every individual
	general combiner stage.  Each individual general combiner stage
	typically requires only one or two color constants.
	
	By keeping two color constant registers but making these two registers
	contain two unique color constant values for each general combiner
	stage, the hardware expense of supporting multiple color constants
	is minimized.  Additionally, this scheme scales appropriately as
	more general combiner stages are added.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/register_combiners2.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.register_combiners2 import *
from OpenGL.raw.GL.NV.register_combiners2 import _EXTENSION_NAME

def glInitRegisterCombiners2NV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glCombinerStageParameterfvNV.params size not checked against 'pname'
glCombinerStageParameterfvNV=wrapper.wrapper(glCombinerStageParameterfvNV).setInputArraySize(
    'params', None
)
glGetCombinerStageParameterfvNV=wrapper.wrapper(glGetCombinerStageParameterfvNV).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
### END AUTOGENERATED SECTION