/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Logger;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidateExtendedType;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.ServerReflexiveCandidate;
import org.ice4j.ice.harvest.AbstractCandidateHarvester;
import org.ice4j.ice.harvest.StunCandidateHarvester;

public class MappingCandidateHarvester
extends AbstractCandidateHarvester {
    private static final Logger logger = Logger.getLogger(StunCandidateHarvester.class.getName());
    protected TransportAddress mask;
    protected TransportAddress face;

    public MappingCandidateHarvester(TransportAddress mask, TransportAddress face) {
        this.mask = Objects.requireNonNull(mask);
        this.face = Objects.requireNonNull(face);
    }

    protected MappingCandidateHarvester() {
    }

    @Override
    public Collection<LocalCandidate> harvest(Component component) {
        TransportAddress mask = this.getMask();
        TransportAddress face = this.getFace();
        if (face == null || mask == null) {
            logger.warning("Harvester not configured: face=" + face + ", mask=" + mask);
            return null;
        }
        HashSet<LocalCandidate> candidates = new HashSet<LocalCandidate>();
        for (Candidate candidate : component.getLocalCandidates()) {
            if (!(candidate instanceof HostCandidate) || !candidate.getTransportAddress().getHostAddress().equals(face.getHostAddress()) || candidate.getTransport() != face.getTransport()) continue;
            HostCandidate hostCandidate = (HostCandidate)candidate;
            TransportAddress mappedAddress = new TransportAddress(mask.getHostAddress(), hostCandidate.getHostAddress().getPort(), hostCandidate.getHostAddress().getTransport());
            ServerReflexiveCandidate mappedCandidate = new ServerReflexiveCandidate(mappedAddress, hostCandidate, hostCandidate.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
            if (hostCandidate.isSSL()) {
                mappedCandidate.setSSL(true);
            }
            if (candidates.contains(mappedCandidate) || !component.addLocalCandidate(mappedCandidate)) continue;
            candidates.add(mappedCandidate);
        }
        return candidates;
    }

    public TransportAddress getMask() {
        return this.mask;
    }

    public TransportAddress getFace() {
        return this.face;
    }

    public String toString() {
        TransportAddress face = this.getFace();
        TransportAddress mask = this.getMask();
        return this.getClass().getName() + ", face=" + (face == null ? "null" : face.getAddress()) + ", mask=" + (mask == null ? "null" : mask.getAddress());
    }
}

