/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class TechtoCruzProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$$A").number("d+,").number("(d+),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").expression("([AV]),").expression("[^,]+,").expression("([^,]+),").number("(d+.d+),").number("(d+),").number("(-?d+.d+),[NS],").number("(-?d+.d+),[WE],").number("(-?d+.d+),").number("(d+.d+),").number("(d+),").number("(d+),").number("(d+.d+),").number("(d+.d+),").number("([01]),").number("[01],").number("[01],").number("([01]),").number("([01]),").any().compile();

    public TechtoCruzProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("A"));
        position.set("registration", parser.next());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.set("odometer", parser.nextInt());
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setAltitude(parser.nextDouble());
        position.setCourse(parser.nextDouble());
        position.set("sat", parser.nextInt());
        position.set("rssi", parser.nextInt());
        position.set("power", parser.nextDouble());
        position.set("battery", parser.nextDouble());
        position.set("charge", parser.nextInt() > 0);
        position.set("ignition", parser.nextInt() > 0);
        if (parser.nextInt() > 0) {
            position.set("alarm", "overspeed");
        }
        return position;
    }
}

