/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import javax.json.JsonObject;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class GeocodeXyzGeocoder
extends JsonGeocoder {
    private static String formatUrl(String key) {
        Object url = "https://geocode.xyz/%f,%f?geoit=JSON";
        if (key != null) {
            url = (String)url + "&key=" + key;
        }
        return url;
    }

    public GeocodeXyzGeocoder(String key, int cacheSize, AddressFormat addressFormat) {
        super(GeocodeXyzGeocoder.formatUrl(key), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        Address address = new Address();
        if (json.containsKey((Object)"stnumber")) {
            address.setHouse(json.getString("stnumber"));
        }
        if (json.containsKey((Object)"staddress")) {
            address.setStreet(json.getString("staddress"));
        }
        if (json.containsKey((Object)"city")) {
            address.setSettlement(json.getString("city"));
        }
        if (json.containsKey((Object)"region")) {
            address.setState(json.getString("region"));
        }
        if (json.containsKey((Object)"prov")) {
            address.setCountry(json.getString("prov"));
        }
        if (json.containsKey((Object)"postal")) {
            address.setPostcode(json.getString("postal"));
        }
        return address;
    }
}

