/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class VersionBucket {
    public long highest;

    public void updateHighest(long val) {
        if (this.highest != 0L) {
            this.highest = Math.max(this.highest, Math.abs(val));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> R runWithLock(int lockTimeoutMs, CheckedFunction<T, R> function) throws IOException {
        VersionBucket versionBucket = this;
        synchronized (versionBucket) {
            return function.apply();
        }
    }

    public void unlock() {
    }

    public void signalAll() {
        this.notifyAll();
    }

    public void awaitNanos(long nanosTimeout) {
        try {
            long millis = TimeUnit.NANOSECONDS.toMillis(nanosTimeout);
            if (millis > 0L) {
                this.wait(millis);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply() throws IOException;
    }
}

