/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSemaphoreTypeCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SEMAPHORETYPE;
    public static final int INITIALVALUE;

    public VkSemaphoreTypeCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSemaphoreTypeCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSemaphoreTypeCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSemaphoreTypeCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkSemaphoreType")
    public int semaphoreType() {
        return VkSemaphoreTypeCreateInfo.nsemaphoreType(this.address());
    }

    @NativeType(value="uint64_t")
    public long initialValue() {
        return VkSemaphoreTypeCreateInfo.ninitialValue(this.address());
    }

    public VkSemaphoreTypeCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSemaphoreTypeCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkSemaphoreTypeCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkSemaphoreTypeCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkSemaphoreTypeCreateInfo semaphoreType(@NativeType(value="VkSemaphoreType") int value) {
        VkSemaphoreTypeCreateInfo.nsemaphoreType(this.address(), value);
        return this;
    }

    public VkSemaphoreTypeCreateInfo initialValue(@NativeType(value="uint64_t") long value) {
        VkSemaphoreTypeCreateInfo.ninitialValue(this.address(), value);
        return this;
    }

    public VkSemaphoreTypeCreateInfo set(int sType, long pNext, int semaphoreType, long initialValue) {
        this.sType(sType);
        this.pNext(pNext);
        this.semaphoreType(semaphoreType);
        this.initialValue(initialValue);
        return this;
    }

    public VkSemaphoreTypeCreateInfo set(VkSemaphoreTypeCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSemaphoreTypeCreateInfo malloc() {
        return (VkSemaphoreTypeCreateInfo)VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSemaphoreTypeCreateInfo calloc() {
        return (VkSemaphoreTypeCreateInfo)VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSemaphoreTypeCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSemaphoreTypeCreateInfo)VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSemaphoreTypeCreateInfo create(long address) {
        return (VkSemaphoreTypeCreateInfo)VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkSemaphoreTypeCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkSemaphoreTypeCreateInfo)VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSemaphoreTypeCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSemaphoreTypeCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSemaphoreTypeCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSemaphoreTypeCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSemaphoreTypeCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSemaphoreTypeCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSemaphoreTypeCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSemaphoreTypeCreateInfo mallocStack() {
        return VkSemaphoreTypeCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSemaphoreTypeCreateInfo callocStack() {
        return VkSemaphoreTypeCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSemaphoreTypeCreateInfo mallocStack(MemoryStack stack) {
        return (VkSemaphoreTypeCreateInfo)VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSemaphoreTypeCreateInfo callocStack(MemoryStack stack) {
        return (VkSemaphoreTypeCreateInfo)VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSemaphoreTypeCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSemaphoreTypeCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSemaphoreTypeCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSemaphoreTypeCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nsemaphoreType(long struct) {
        return UNSAFE.getInt(null, struct + (long)SEMAPHORETYPE);
    }

    public static long ninitialValue(long struct) {
        return UNSAFE.getLong(null, struct + (long)INITIALVALUE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsemaphoreType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SEMAPHORETYPE, value);
    }

    public static void ninitialValue(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)INITIALVALUE, value);
    }

    static {
        Struct.Layout layout = VkSemaphoreTypeCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkSemaphoreTypeCreateInfo.__member((int)4), VkSemaphoreTypeCreateInfo.__member((int)POINTER_SIZE), VkSemaphoreTypeCreateInfo.__member((int)4), VkSemaphoreTypeCreateInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SEMAPHORETYPE = layout.offsetof(2);
        INITIALVALUE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkSemaphoreTypeCreateInfo, Buffer>
    implements NativeResource {
        private static final VkSemaphoreTypeCreateInfo ELEMENT_FACTORY = VkSemaphoreTypeCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSemaphoreTypeCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSemaphoreTypeCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSemaphoreTypeCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkSemaphoreType")
        public int semaphoreType() {
            return VkSemaphoreTypeCreateInfo.nsemaphoreType(this.address());
        }

        @NativeType(value="uint64_t")
        public long initialValue() {
            return VkSemaphoreTypeCreateInfo.ninitialValue(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSemaphoreTypeCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSemaphoreTypeCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer semaphoreType(@NativeType(value="VkSemaphoreType") int value) {
            VkSemaphoreTypeCreateInfo.nsemaphoreType(this.address(), value);
            return this;
        }

        public Buffer initialValue(@NativeType(value="uint64_t") long value) {
            VkSemaphoreTypeCreateInfo.ninitialValue(this.address(), value);
            return this;
        }
    }
}

