/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.BatchOptions;
import com.microsoft.azure.eventhubs.ConnectionStringBuilder;
import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventDataBatch;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.EventHubRuntimeInformation;
import com.microsoft.azure.eventhubs.EventPosition;
import com.microsoft.azure.eventhubs.OperationCancelledException;
import com.microsoft.azure.eventhubs.PartitionReceiver;
import com.microsoft.azure.eventhubs.PartitionRuntimeInformation;
import com.microsoft.azure.eventhubs.PartitionSender;
import com.microsoft.azure.eventhubs.ReceiverOptions;
import com.microsoft.azure.eventhubs.RetryPolicy;
import com.microsoft.azure.eventhubs.impl.AmqpException;
import com.microsoft.azure.eventhubs.impl.ClientConstants;
import com.microsoft.azure.eventhubs.impl.ClientEntity;
import com.microsoft.azure.eventhubs.impl.EventDataBatchImpl;
import com.microsoft.azure.eventhubs.impl.EventDataImpl;
import com.microsoft.azure.eventhubs.impl.EventDataUtil;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import com.microsoft.azure.eventhubs.impl.IteratorUtil;
import com.microsoft.azure.eventhubs.impl.MessageSender;
import com.microsoft.azure.eventhubs.impl.MessagingFactory;
import com.microsoft.azure.eventhubs.impl.PartitionReceiverImpl;
import com.microsoft.azure.eventhubs.impl.PartitionSenderImpl;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import com.microsoft.azure.eventhubs.impl.TimeoutTracker;
import com.microsoft.azure.eventhubs.impl.Timer;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;

public final class EventHubClientImpl
extends ClientEntity
implements EventHubClient {
    public static String USER_AGENT = null;
    private final String eventHubName;
    private final Object senderCreateSync;
    private volatile boolean isSenderCreateStarted;
    private volatile MessagingFactory underlyingFactory;
    private volatile MessageSender sender;
    private volatile Timer timer;
    private CompletableFuture<Void> createSender;

    private EventHubClientImpl(ConnectionStringBuilder connectionString, ScheduledExecutorService executor) {
        super("EventHubClientImpl".concat(StringUtil.getRandomString()), null, executor);
        this.eventHubName = connectionString.getEventHubName();
        this.senderCreateSync = new Object();
    }

    public static CompletableFuture<EventHubClient> create(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor) throws EventHubException, IOException {
        ConnectionStringBuilder connStr = new ConnectionStringBuilder(connectionString);
        final EventHubClientImpl eventHubClient = new EventHubClientImpl(connStr, executor);
        return MessagingFactory.createFromConnectionString(connectionString.toString(), retryPolicy, executor).thenApplyAsync(new Function<MessagingFactory, EventHubClient>(){

            @Override
            public EventHubClient apply(MessagingFactory factory) {
                eventHubClient.underlyingFactory = factory;
                eventHubClient.timer = new Timer(factory);
                return eventHubClient;
            }
        }, (Executor)executor);
    }

    @Override
    public String getEventHubName() {
        return this.eventHubName;
    }

    @Override
    public final EventDataBatch createBatch(BatchOptions options) throws EventHubException {
        return ExceptionUtil.sync(() -> {
            int maxSize = (Integer)((CompletableFuture)this.createInternalSender().thenApplyAsync(aVoid -> this.sender.getMaxMessageSize(), (Executor)this.executor)).get();
            if (options.maxMessageSize == null) {
                return new EventDataBatchImpl(maxSize, options.partitionKey);
            }
            if (options.maxMessageSize > maxSize) {
                throw new IllegalArgumentException("The maxMessageSize set in BatchOptions is too large. You set a maxMessageSize of " + options.maxMessageSize + ". The maximum allowed size is " + maxSize + ".");
            }
            return new EventDataBatchImpl(options.maxMessageSize, options.partitionKey);
        });
    }

    @Override
    public final CompletableFuture<Void> send(final EventData data) {
        if (data == null) {
            throw new IllegalArgumentException("EventData cannot be empty.");
        }
        return this.createInternalSender().thenComposeAsync(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClientImpl.this.sender.send(((EventDataImpl)data).toAmqpMessage());
            }
        }, (Executor)this.executor);
    }

    @Override
    public final CompletableFuture<Void> send(final Iterable<EventData> eventDatas) {
        if (eventDatas == null || IteratorUtil.sizeEquals(eventDatas, 0)) {
            throw new IllegalArgumentException("Empty batch of EventData cannot be sent.");
        }
        return this.createInternalSender().thenComposeAsync(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClientImpl.this.sender.send(EventDataUtil.toAmqpMessages(eventDatas));
            }
        }, (Executor)this.executor);
    }

    @Override
    public final CompletableFuture<Void> send(EventDataBatch eventDatas) {
        if (eventDatas == null || Integer.compare(eventDatas.getSize(), 0) == 0) {
            throw new IllegalArgumentException("Empty batch of EventData cannot be sent.");
        }
        EventDataBatchImpl eventDataBatch = (EventDataBatchImpl)eventDatas;
        return eventDataBatch.getPartitionKey() != null ? this.send(eventDataBatch.getInternalIterable(), eventDataBatch.getPartitionKey()) : this.send(eventDataBatch.getInternalIterable());
    }

    @Override
    public final CompletableFuture<Void> send(final EventData eventData, final String partitionKey) {
        if (eventData == null) {
            throw new IllegalArgumentException("EventData cannot be null.");
        }
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey cannot be null");
        }
        return this.createInternalSender().thenComposeAsync(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClientImpl.this.sender.send(((EventDataImpl)eventData).toAmqpMessage(partitionKey));
            }
        }, (Executor)this.executor);
    }

    @Override
    public final CompletableFuture<Void> send(final Iterable<EventData> eventDatas, final String partitionKey) {
        if (eventDatas == null || IteratorUtil.sizeEquals(eventDatas, 0)) {
            throw new IllegalArgumentException("Empty batch of EventData cannot be sent.");
        }
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey cannot be null");
        }
        if (partitionKey.length() > 128) {
            throw new IllegalArgumentException(String.format(Locale.US, "PartitionKey exceeds the maximum allowed length of partitionKey: %s", 128));
        }
        return this.createInternalSender().thenComposeAsync(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClientImpl.this.sender.send(EventDataUtil.toAmqpMessages(eventDatas, partitionKey));
            }
        }, (Executor)this.executor);
    }

    @Override
    public final CompletableFuture<PartitionSender> createPartitionSender(String partitionId) throws EventHubException {
        return PartitionSenderImpl.Create(this.underlyingFactory, this.eventHubName, partitionId, this.executor);
    }

    @Override
    public final CompletableFuture<PartitionReceiver> createReceiver(String consumerGroupName, String partitionId, EventPosition eventPosition) throws EventHubException {
        return this.createReceiver(consumerGroupName, partitionId, eventPosition, null);
    }

    @Override
    public final CompletableFuture<PartitionReceiver> createReceiver(String consumerGroupName, String partitionId, EventPosition eventPosition, ReceiverOptions receiverOptions) throws EventHubException {
        return PartitionReceiverImpl.create(this.underlyingFactory, this.eventHubName, consumerGroupName, partitionId, eventPosition, 0L, false, receiverOptions, this.executor);
    }

    @Override
    public final CompletableFuture<PartitionReceiver> createEpochReceiver(String consumerGroupName, String partitionId, EventPosition eventPosition, long epoch) throws EventHubException {
        return this.createEpochReceiver(consumerGroupName, partitionId, eventPosition, epoch, null);
    }

    @Override
    public final CompletableFuture<PartitionReceiver> createEpochReceiver(String consumerGroupName, String partitionId, EventPosition eventPosition, long epoch, ReceiverOptions receiverOptions) throws EventHubException {
        return PartitionReceiverImpl.create(this.underlyingFactory, this.eventHubName, consumerGroupName, partitionId, eventPosition, epoch, true, receiverOptions, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> onClose() {
        if (this.underlyingFactory != null) {
            Object object = this.senderCreateSync;
            synchronized (object) {
                CompletableFuture<Void> internalSenderClose = this.sender != null ? this.sender.close().thenComposeAsync(new Function<Void, CompletableFuture<Void>>(){

                    @Override
                    public CompletableFuture<Void> apply(Void voidArg) {
                        return EventHubClientImpl.this.underlyingFactory.close();
                    }
                }, (Executor)this.executor) : this.underlyingFactory.close();
                return internalSenderClose;
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> createInternalSender() {
        if (!this.isSenderCreateStarted) {
            Object object = this.senderCreateSync;
            synchronized (object) {
                if (!this.isSenderCreateStarted) {
                    this.createSender = MessageSender.create(this.underlyingFactory, this.getClientId().concat("-InternalSender"), this.eventHubName).thenAcceptAsync((Consumer)new Consumer<MessageSender>(){

                        @Override
                        public void accept(MessageSender a) {
                            EventHubClientImpl.this.sender = a;
                        }
                    }, (Executor)this.executor);
                    this.isSenderCreateStarted = true;
                }
            }
        }
        return this.createSender;
    }

    @Override
    public CompletableFuture<EventHubRuntimeInformation> getRuntimeInformation() {
        CompletionStage<EventHubRuntimeInformation> future1 = null;
        this.throwIfClosed();
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("type", "com.microsoft:eventhub");
        request.put("name", this.eventHubName);
        request.put("operation", "READ");
        future1 = this.addManagementToken(request);
        if (future1 == null) {
            future1 = this.managementWithRetry(request).thenComposeAsync(new Function<Map<String, Object>, CompletableFuture<EventHubRuntimeInformation>>(){

                @Override
                public CompletableFuture<EventHubRuntimeInformation> apply(Map<String, Object> rawdata) {
                    CompletableFuture<EventHubRuntimeInformation> future2 = new CompletableFuture<EventHubRuntimeInformation>();
                    future2.complete(new EventHubRuntimeInformation((String)rawdata.get("name"), ((Date)rawdata.get("created_at")).toInstant(), (Integer)rawdata.get("partition_count"), (String[])rawdata.get("partition_ids")));
                    return future2;
                }
            }, (Executor)this.executor);
        }
        return future1;
    }

    @Override
    public CompletableFuture<PartitionRuntimeInformation> getPartitionRuntimeInformation(String partitionId) {
        CompletionStage<PartitionRuntimeInformation> future1 = null;
        this.throwIfClosed();
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("type", "com.microsoft:partition");
        request.put("name", this.eventHubName);
        request.put("partition", partitionId);
        request.put("operation", "READ");
        future1 = this.addManagementToken(request);
        if (future1 == null) {
            future1 = this.managementWithRetry(request).thenComposeAsync(new Function<Map<String, Object>, CompletableFuture<PartitionRuntimeInformation>>(){

                @Override
                public CompletableFuture<PartitionRuntimeInformation> apply(Map<String, Object> rawData) {
                    CompletableFuture<PartitionRuntimeInformation> future2 = new CompletableFuture<PartitionRuntimeInformation>();
                    future2.complete(new PartitionRuntimeInformation((String)rawData.get("name"), (String)rawData.get("partition"), (Long)rawData.get("begin_sequence_number"), (Long)rawData.get("last_enqueued_sequence_number"), (String)rawData.get("last_enqueued_offset"), ((Date)rawData.get("last_enqueued_time_utc")).toInstant(), (Boolean)rawData.get("is_partition_empty")));
                    return future2;
                }
            }, (Executor)this.executor);
        }
        return future1;
    }

    private <T> CompletableFuture<T> addManagementToken(Map<String, Object> request) {
        CompletableFuture retval = null;
        try {
            String audience = String.format("amqp://%s/%s", this.underlyingFactory.getHostName(), this.eventHubName);
            String token = this.underlyingFactory.getTokenProvider().getToken(audience, ClientConstants.TOKEN_REFRESH_INTERVAL);
            request.put("security_token", token);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            retval = new CompletableFuture();
            retval.completeExceptionally(e);
        }
        return retval;
    }

    private CompletableFuture<Map<String, Object>> managementWithRetry(Map<String, Object> request) {
        CompletableFuture<Map<String, Object>> rawdataFuture = new CompletableFuture<Map<String, Object>>();
        ManagementRetry retrier = new ManagementRetry(rawdataFuture, new TimeoutTracker(this.underlyingFactory.getOperationTimeout(), true), this.underlyingFactory, request);
        CompletableFuture<?> scheduledTask = this.timer.schedule(retrier, Duration.ZERO);
        if (scheduledTask.isCompletedExceptionally()) {
            rawdataFuture.completeExceptionally(ExceptionUtil.getExceptionFromCompletedFuture(scheduledTask));
        }
        return rawdataFuture;
    }

    private class ManagementRetry
    implements Runnable {
        private final CompletableFuture<Map<String, Object>> finalFuture;
        private final TimeoutTracker timeoutTracker;
        private final MessagingFactory mf;
        private final Map<String, Object> request;

        ManagementRetry(CompletableFuture<Map<String, Object>> future, TimeoutTracker timeoutTracker, MessagingFactory mf, Map<String, Object> request) {
            this.finalFuture = future;
            this.timeoutTracker = timeoutTracker;
            this.mf = mf;
            this.request = request;
        }

        @Override
        public void run() {
            long timeLeft = this.timeoutTracker.remaining().toMillis();
            CompletableFuture<Map<String, Object>> intermediateFuture = this.mf.getManagementChannel().request(this.mf.getReactorDispatcher(), this.request, timeLeft > 0L ? timeLeft : 0L);
            intermediateFuture.whenComplete((result, error) -> {
                if (result != null && error == null) {
                    this.finalFuture.complete((Map<String, Object>)result);
                } else {
                    Throwable completeWith;
                    Exception lastException;
                    if (error == null) {
                        lastException = new EventHubException(true, "timed out");
                        completeWith = null;
                    } else if (error instanceof Exception) {
                        lastException = error instanceof EventHubException ? (EventHubException)error : (error instanceof AmqpException ? ExceptionUtil.toException(((AmqpException)error).getError()) : (error instanceof CompletionException || error instanceof ExecutionException ? ExceptionUtil.stripOuterException((Exception)error) : (Exception)error));
                        completeWith = lastException;
                    } else {
                        lastException = new Exception("got a throwable: " + error.toString());
                        completeWith = error;
                    }
                    if (this.mf.getIsClosingOrClosed()) {
                        this.finalFuture.completeExceptionally(new OperationCancelledException("OperationCancelled as the underlying client instance was closed.", (Throwable)lastException));
                    } else {
                        Duration waitTime = this.mf.getRetryPolicy().getNextRetryInterval(this.mf.getClientId(), lastException, this.timeoutTracker.remaining());
                        if (waitTime == null) {
                            if (completeWith == null) {
                                this.finalFuture.complete(null);
                            } else {
                                this.finalFuture.completeExceptionally(completeWith);
                            }
                        } else {
                            ManagementRetry retrier = new ManagementRetry(this.finalFuture, this.timeoutTracker, this.mf, this.request);
                            EventHubClientImpl.this.timer.schedule(retrier, waitTime);
                        }
                    }
                }
            });
        }
    }
}

