/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;

public class ResponseHeader
implements AbstractRequestResponse {
    private final ResponseHeaderData data;
    private final short headerVersion;

    public ResponseHeader(Struct struct, short headerVersion) {
        this(new ResponseHeaderData(struct, headerVersion), headerVersion);
    }

    public ResponseHeader(int correlationId, short headerVersion) {
        this(new ResponseHeaderData().setCorrelationId(correlationId), headerVersion);
    }

    public ResponseHeader(ResponseHeaderData data, short headerVersion) {
        this.data = data;
        this.headerVersion = headerVersion;
    }

    public int sizeOf() {
        return this.toStruct().sizeOf();
    }

    public Struct toStruct() {
        return this.data.toStruct(this.headerVersion);
    }

    public int correlationId() {
        return this.data.correlationId();
    }

    public short headerVersion() {
        return this.headerVersion;
    }

    public ResponseHeaderData data() {
        return this.data;
    }

    public static ResponseHeader parse(ByteBuffer buffer, short headerVersion) {
        return new ResponseHeader(new ResponseHeaderData(new ByteBufferAccessor(buffer), headerVersion), headerVersion);
    }
}

