/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.HtmlDocument;
import nokogiri.XmlDocument;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.SaveContextVisitor;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::XML::Attr"}, parent="Nokogiri::XML::Node")
public class XmlAttr
extends XmlNode {
    public static final String[] HTML_BOOLEAN_ATTRS = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"};

    public XmlAttr(Ruby ruby, Node node) {
        super(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Attr"), node);
    }

    public XmlAttr(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public XmlAttr(Ruby ruby, RubyClass rubyClass, Node node) {
        super(ruby, rubyClass, node);
    }

    @Override
    protected void init(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length < 2) {
            throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
        }
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        if (!(iRubyObject instanceof XmlDocument)) {
            throw this.getRuntime().newArgumentError("document must be an instance of Nokogiri::XML::Document");
        }
        XmlDocument xmlDocument = (XmlDocument)iRubyObject;
        String string = NokogiriHelpers.rubyStringToString(iRubyObject2);
        Attr attr = xmlDocument.getDocument().createAttribute(string);
        this.setNode(threadContext, attr);
    }

    void setNamespaceIfNecessary(Ruby ruby) {
        if ("xml".equals(this.node.getPrefix())) {
            XmlNamespace.createDefaultNamespace(ruby, this.node);
        }
    }

    private boolean isHtmlBooleanAttr() {
        String string = this.node.getNodeName().toLowerCase();
        for (String string2 : HTML_BOOLEAN_ATTRS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    @JRubyMethod(name={"content", "value", "to_s"})
    public IRubyObject content(ThreadContext threadContext) {
        if (this.content != null && !this.content.isNil()) {
            return this.content;
        }
        if (this.node == null) {
            return threadContext.getRuntime().getNil();
        }
        String string = ((Attr)this.node).getValue();
        if (string == null) {
            return threadContext.getRuntime().getNil();
        }
        return RubyString.newString((Ruby)threadContext.getRuntime(), (String)string);
    }

    @JRubyMethod(name={"value=", "content="})
    public IRubyObject value_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        Attr attr = (Attr)this.node;
        if (iRubyObject != null && !iRubyObject.isNil()) {
            attr.setValue(NokogiriHelpers.rubyStringToString(XmlNode.encode_special_chars(threadContext, iRubyObject)));
        }
        this.setContent(iRubyObject);
        return iRubyObject;
    }

    @Override
    protected IRubyObject getNodeName(ThreadContext threadContext) {
        if (this.name != null) {
            return this.name;
        }
        String string = ((Attr)this.node).getName();
        if (!(this.doc instanceof HtmlDocument) && this.node.getNamespaceURI() != null) {
            string = NokogiriHelpers.getLocalPart(string);
        }
        return string == null ? threadContext.getRuntime().getNil() : RubyString.newString((Ruby)threadContext.getRuntime(), (String)string);
    }

    @Override
    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        saveContextVisitor.enter((Attr)this.node);
        saveContextVisitor.leave((Attr)this.node);
    }

    private boolean isHtml(ThreadContext threadContext) {
        return this.document(threadContext).getMetaClass().isKindOfModule((RubyModule)NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::HTML::Document"));
    }

    @Override
    public IRubyObject unlink(ThreadContext threadContext) {
        Attr attr = (Attr)this.node;
        Element element = attr.getOwnerElement();
        element.removeAttributeNode(attr);
        return this;
    }
}

