"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.I18nProvider = void 0;

var PropTypes = _interopRequireWildcard(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _reactIntl = require("react-intl");

var i18n = _interopRequireWildcard(require("../core"));

var _pseudo_locale_wrapper = require("./pseudo_locale_wrapper");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * The library uses the provider pattern to scope an i18n context to a tree
 * of components. This component is used to setup the i18n context for a tree.
 * IntlProvider should wrap react app's root component (inside each react render method).
 */
class I18nProvider extends React.PureComponent {
  render() {
    return /*#__PURE__*/React.createElement(_reactIntl.IntlProvider, {
      locale: i18n.getLocale(),
      messages: i18n.getTranslation().messages,
      defaultLocale: i18n.getDefaultLocale(),
      formats: i18n.getFormats(),
      textComponent: React.Fragment
    }, /*#__PURE__*/React.createElement(_pseudo_locale_wrapper.PseudoLocaleWrapper, null, this.props.children));
  }

}

exports.I18nProvider = I18nProvider;

_defineProperty(I18nProvider, "propTypes", {
  children: PropTypes.element.isRequired
});