"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useContainerCallbacks = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _react = require("react");

var _services = require("../../services");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function isMouseEvent(event) {
  return (0, _typeof2.default)(event) === 'object' && 'pageX' in event && 'pageY' in event;
}

var pxToPercent = function pxToPercent(proportion, whole) {
  return proportion / whole * 100;
};

var getPanelMinSize = function getPanelMinSize(panelMinSize, containerSize, resizerSize) {
  var panelMinSizePercent = 0;
  var panelMinSizeInt = parseInt(panelMinSize);

  if (panelMinSize.indexOf('px') > -1) {
    panelMinSizePercent = pxToPercent(panelMinSizeInt, containerSize);
  } else if (panelMinSize.indexOf('%') > -1) {
    panelMinSizePercent = panelMinSizeInt + resizerSize / containerSize * panelMinSizeInt;
  }

  return panelMinSizePercent;
};

var useContainerCallbacks = function useContainerCallbacks(_ref) {
  var isHorizontal = _ref.isHorizontal,
      state = _ref.state,
      setState = _ref.setState,
      containerRef = _ref.containerRef,
      registryRef = _ref.registryRef,
      onPanelWidthChange = _ref.onPanelWidthChange;
  var getContainerSize = (0, _react.useCallback)(function () {
    return isHorizontal ? containerRef.current.getBoundingClientRect().width : containerRef.current.getBoundingClientRect().height;
  }, [containerRef, isHorizontal]);
  var getResizerButtonsSize = (0, _react.useCallback)(function () {
    // get sum of all of resizer button sizes to proper calculate panels ratio
    var allResizers = registryRef.current.getAllResizers();
    return allResizers.reduce(function (size, resizer) {
      return size + (isHorizontal ? resizer.offsetWidth : resizer.offsetHeight);
    }, 0);
  }, [registryRef, isHorizontal]);
  var onMouseDown = (0, _react.useCallback)(function (event) {
    var currentTarget = event.currentTarget;
    var clientX = isMouseEvent(event) ? event.clientX : event.touches[0].clientX;
    var clientY = isMouseEvent(event) ? event.clientY : event.touches[0].clientY;
    setState(function (prevState) {
      return _objectSpread(_objectSpread({}, prevState), {}, {
        isDragging: true,
        currentResizerPos: isHorizontal ? clientX : clientY,
        previousPanelId: currentTarget.previousElementSibling.id,
        nextPanelId: currentTarget.nextElementSibling.id,
        resizersSize: getResizerButtonsSize()
      });
    });
  }, [getResizerButtonsSize, isHorizontal, setState]);
  var onKeyDown = (0, _react.useCallback)(function (event) {
    var key = event.key,
        currentTarget = event.currentTarget;
    var shouldResizeHorizontalPanel = isHorizontal && (key === _services.keys.ARROW_LEFT || key === _services.keys.ARROW_RIGHT);
    var shouldResizeVerticalPanel = !isHorizontal && (key === _services.keys.ARROW_UP || key === _services.keys.ARROW_DOWN);
    var prevPanelId = currentTarget.previousElementSibling.id;
    var nextPanelId = currentTarget.nextElementSibling.id;

    if ((shouldResizeHorizontalPanel || shouldResizeVerticalPanel) && prevPanelId && nextPanelId) {
      event.preventDefault();
      var registry = registryRef.current;

      var _registry$getResizerS = registry.getResizerSiblings(prevPanelId, nextPanelId),
          _registry$getResizerS2 = (0, _slicedToArray2.default)(_registry$getResizerS, 2),
          prevPanel = _registry$getResizerS2[0],
          nextPanel = _registry$getResizerS2[1];

      var resizersSize = getResizerButtonsSize();
      var containerSize = getContainerSize();
      var prevPanelSize = pxToPercent(prevPanel.getSizePx() - (key === _services.keys.ARROW_UP || key === _services.keys.ARROW_LEFT ? 10 : -10), containerSize - resizersSize);
      var nextPanelSize = pxToPercent(nextPanel.getSizePx() - (key === _services.keys.ARROW_DOWN || key === _services.keys.ARROW_RIGHT ? 10 : -10), containerSize - resizersSize);
      setState(_objectSpread(_objectSpread({}, state), {}, {
        isDragging: false
      }));
      var panelObject = registry.fetchAllPanels(prevPanelId, nextPanelId, containerSize - resizersSize);

      if (onPanelWidthChange) {
        var _objectSpread2;

        onPanelWidthChange(_objectSpread(_objectSpread({}, panelObject), {}, (_objectSpread2 = {}, (0, _defineProperty2.default)(_objectSpread2, prevPanelId, prevPanelSize), (0, _defineProperty2.default)(_objectSpread2, nextPanelId, nextPanelSize), _objectSpread2)));
      }

      prevPanel.setSize(prevPanelSize);
      nextPanel.setSize(nextPanelSize);
    }
  }, // `setState` is safe to omit from `useCallback`
  // (https://reactjs.org/docs/hooks-reference.html#usestate)
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [getContainerSize, getResizerButtonsSize, isHorizontal, onPanelWidthChange, registryRef]);
  var onMouseMove = (0, _react.useCallback)(function (event) {
    if (state.isDragging && state.previousPanelId && state.nextPanelId) {
      var clientX = isMouseEvent(event) ? event.clientX : event.touches[0].clientX;
      var clientY = isMouseEvent(event) ? event.clientY : event.touches[0].clientY;
      var x = isHorizontal ? clientX : clientY;
      var registry = registryRef.current;

      var _registry$getResizerS3 = registry.getResizerSiblings(state.previousPanelId, state.nextPanelId),
          _registry$getResizerS4 = (0, _slicedToArray2.default)(_registry$getResizerS3, 2),
          prevPanel = _registry$getResizerS4[0],
          nextPanel = _registry$getResizerS4[1];

      var delta = x - state.currentResizerPos;
      var containerSize = getContainerSize() - state.resizersSize;
      var prevPanelMin = getPanelMinSize(prevPanel.minSize, containerSize, state.resizersSize);
      var nextPanelMin = getPanelMinSize(nextPanel.minSize, containerSize, state.resizersSize);
      var prevPanelSize = pxToPercent(prevPanel.getSizePx() + delta, containerSize);
      var nextPanelSize = pxToPercent(nextPanel.getSizePx() - delta, containerSize);
      var panelObject = registry.fetchAllPanels(state.previousPanelId, state.nextPanelId, containerSize);

      if (prevPanelSize >= prevPanelMin && nextPanelSize >= nextPanelMin) {
        if (onPanelWidthChange) {
          var _objectSpread3;

          onPanelWidthChange(_objectSpread(_objectSpread({}, panelObject), {}, (_objectSpread3 = {}, (0, _defineProperty2.default)(_objectSpread3, state.previousPanelId, prevPanelSize), (0, _defineProperty2.default)(_objectSpread3, state.nextPanelId, nextPanelSize), _objectSpread3)));
        }

        prevPanel.setSize(prevPanelSize);
        nextPanel.setSize(nextPanelSize);
        setState(_objectSpread(_objectSpread({}, state), {}, {
          currentResizerPos: x
        }));
      }
    }
  }, [getContainerSize, isHorizontal, onPanelWidthChange, registryRef, setState, state]);
  return {
    onMouseDown: onMouseDown,
    onKeyDown: onKeyDown,
    onMouseMove: onMouseMove
  };
};

exports.useContainerCallbacks = useContainerCallbacks;