/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import sun.net.httpserver.Code;
import sun.net.httpserver.ContextList;
import sun.net.httpserver.Event;
import sun.net.httpserver.ExchangeImpl;
import sun.net.httpserver.HttpConnection;
import sun.net.httpserver.HttpContextImpl;
import sun.net.httpserver.HttpError;
import sun.net.httpserver.HttpExchangeImpl;
import sun.net.httpserver.HttpsExchangeImpl;
import sun.net.httpserver.LeftOverInputStream;
import sun.net.httpserver.Request;
import sun.net.httpserver.SSLStreams;
import sun.net.httpserver.ServerConfig;
import sun.net.httpserver.TimeSource;
import sun.net.httpserver.WriteFinishedEvent;

class ServerImpl
implements TimeSource {
    private String protocol;
    private boolean https;
    private Executor executor;
    private HttpsConfigurator httpsConfig;
    private SSLContext sslContext;
    private ContextList contexts;
    private InetSocketAddress address;
    private ServerSocketChannel schan;
    private Selector selector;
    private SelectionKey listenerKey;
    private Set<HttpConnection> idleConnections;
    private Set<HttpConnection> allConnections;
    private Set<HttpConnection> reqConnections;
    private Set<HttpConnection> rspConnections;
    private List<Event> events;
    private Object lolock = new Object();
    private volatile boolean finished = false;
    private volatile boolean terminating = false;
    private boolean bound = false;
    private boolean started = false;
    private volatile long time;
    private volatile long subticks = 0L;
    private volatile long ticks;
    private HttpServer wrapper;
    static final int CLOCK_TICK = ServerConfig.getClockTick();
    static final long IDLE_INTERVAL = ServerConfig.getIdleInterval();
    static final int MAX_IDLE_CONNECTIONS = ServerConfig.getMaxIdleConnections();
    static final long TIMER_MILLIS = ServerConfig.getTimerMillis();
    static final long MAX_REQ_TIME = ServerImpl.getTimeMillis(ServerConfig.getMaxReqTime());
    static final long MAX_RSP_TIME = ServerImpl.getTimeMillis(ServerConfig.getMaxRspTime());
    static final boolean timer1Enabled = MAX_REQ_TIME != -1L || MAX_RSP_TIME != -1L;
    private Timer timer;
    private Timer timer1;
    private Logger logger;
    Dispatcher dispatcher;
    static boolean debug = ServerConfig.debugEnabled();
    private int exchangeCount = 0;

    ServerImpl(HttpServer httpServer, String string, InetSocketAddress inetSocketAddress, int n) throws IOException {
        this.protocol = string;
        this.wrapper = httpServer;
        this.logger = Logger.getLogger("com.sun.net.httpserver");
        ServerConfig.checkLegacyProperties(this.logger);
        this.https = string.equalsIgnoreCase("https");
        this.address = inetSocketAddress;
        this.contexts = new ContextList();
        this.schan = ServerSocketChannel.open();
        if (inetSocketAddress != null) {
            ServerSocket serverSocket = this.schan.socket();
            serverSocket.bind(inetSocketAddress, n);
            this.bound = true;
        }
        this.selector = Selector.open();
        this.schan.configureBlocking(false);
        this.listenerKey = this.schan.register(this.selector, 16);
        this.dispatcher = new Dispatcher();
        this.idleConnections = Collections.synchronizedSet(new HashSet());
        this.allConnections = Collections.synchronizedSet(new HashSet());
        this.reqConnections = Collections.synchronizedSet(new HashSet());
        this.rspConnections = Collections.synchronizedSet(new HashSet());
        this.time = System.currentTimeMillis();
        this.timer = new Timer("server-timer", true);
        this.timer.schedule((TimerTask)new ServerTimerTask(), CLOCK_TICK, (long)CLOCK_TICK);
        if (timer1Enabled) {
            this.timer1 = new Timer("server-timer1", true);
            this.timer1.schedule((TimerTask)new ServerTimerTask1(), TIMER_MILLIS, TIMER_MILLIS);
            this.logger.config("HttpServer timer1 enabled period in ms:  " + TIMER_MILLIS);
            this.logger.config("MAX_REQ_TIME:  " + MAX_REQ_TIME);
            this.logger.config("MAX_RSP_TIME:  " + MAX_RSP_TIME);
        }
        this.events = new LinkedList<Event>();
        this.logger.config("HttpServer created " + string + " " + inetSocketAddress);
    }

    public void bind(InetSocketAddress inetSocketAddress, int n) throws IOException {
        if (this.bound) {
            throw new BindException("HttpServer already bound");
        }
        if (inetSocketAddress == null) {
            throw new NullPointerException("null address");
        }
        ServerSocket serverSocket = this.schan.socket();
        serverSocket.bind(inetSocketAddress, n);
        this.bound = true;
    }

    public void start() {
        if (!this.bound || this.started || this.finished) {
            throw new IllegalStateException("server in wrong state");
        }
        if (this.executor == null) {
            this.executor = new DefaultExecutor();
        }
        Thread thread = new Thread(this.dispatcher);
        this.started = true;
        thread.start();
    }

    public void setExecutor(Executor executor) {
        if (this.started) {
            throw new IllegalStateException("server already started");
        }
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setHttpsConfigurator(HttpsConfigurator httpsConfigurator) {
        if (httpsConfigurator == null) {
            throw new NullPointerException("null HttpsConfigurator");
        }
        if (this.started) {
            throw new IllegalStateException("server already started");
        }
        this.httpsConfig = httpsConfigurator;
        this.sslContext = httpsConfigurator.getSSLContext();
    }

    public HttpsConfigurator getHttpsConfigurator() {
        return this.httpsConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative delay parameter");
        }
        this.terminating = true;
        try {
            this.schan.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selector.wakeup();
        long l = System.currentTimeMillis() + (long)(n * 1000);
        while (System.currentTimeMillis() < l) {
            this.delay();
            if (!this.finished) continue;
        }
        this.finished = true;
        this.selector.wakeup();
        Set<HttpConnection> set = this.allConnections;
        synchronized (set) {
            for (HttpConnection httpConnection : this.allConnections) {
                httpConnection.close();
            }
        }
        this.allConnections.clear();
        this.idleConnections.clear();
        this.timer.cancel();
        if (timer1Enabled) {
            this.timer1.cancel();
        }
    }

    public synchronized HttpContextImpl createContext(String string, HttpHandler httpHandler) {
        if (httpHandler == null || string == null) {
            throw new NullPointerException("null handler, or path parameter");
        }
        HttpContextImpl httpContextImpl = new HttpContextImpl(this.protocol, string, httpHandler, this);
        this.contexts.add(httpContextImpl);
        this.logger.config("context created: " + string);
        return httpContextImpl;
    }

    public synchronized HttpContextImpl createContext(String string) {
        if (string == null) {
            throw new NullPointerException("null path parameter");
        }
        HttpContextImpl httpContextImpl = new HttpContextImpl(this.protocol, string, null, this);
        this.contexts.add(httpContextImpl);
        this.logger.config("context created: " + string);
        return httpContextImpl;
    }

    public synchronized void removeContext(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException("null path parameter");
        }
        this.contexts.remove(this.protocol, string);
        this.logger.config("context removed: " + string);
    }

    public synchronized void removeContext(HttpContext httpContext) throws IllegalArgumentException {
        if (!(httpContext instanceof HttpContextImpl)) {
            throw new IllegalArgumentException("wrong HttpContext type");
        }
        this.contexts.remove((HttpContextImpl)httpContext);
        this.logger.config("context removed: " + httpContext.getPath());
    }

    public InetSocketAddress getAddress() {
        return AccessController.doPrivileged(new PrivilegedAction<InetSocketAddress>(){

            @Override
            public InetSocketAddress run() {
                return (InetSocketAddress)ServerImpl.this.schan.socket().getLocalSocketAddress();
            }
        });
    }

    Selector getSelector() {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(Event event) {
        Object object = this.lolock;
        synchronized (object) {
            this.events.add(event);
            this.selector.wakeup();
        }
    }

    static synchronized void dprint(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    static synchronized void dprint(Exception exception) {
        if (debug) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    Logger getLogger() {
        return this.logger;
    }

    private void closeConnection(HttpConnection httpConnection) {
        httpConnection.close();
        this.allConnections.remove(httpConnection);
        switch (httpConnection.getState()) {
            case REQUEST: {
                this.reqConnections.remove(httpConnection);
                break;
            }
            case RESPONSE: {
                this.rspConnections.remove(httpConnection);
                break;
            }
            case IDLE: {
                this.idleConnections.remove(httpConnection);
            }
        }
        assert (!this.reqConnections.remove(httpConnection));
        assert (!this.rspConnections.remove(httpConnection));
        assert (!this.idleConnections.remove(httpConnection));
    }

    void logReply(int n, String string, String string2) {
        if (!this.logger.isLoggable(Level.FINE)) {
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string.length() > 80 ? string.substring(0, 80) + "<TRUNCATED>" : string;
        String string4 = string3 + " [" + n + " " + Code.msg(n) + "] (" + string2 + ")";
        this.logger.fine(string4);
    }

    long getTicks() {
        return this.ticks;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    void delay() {
        Thread.yield();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void startExchange() {
        ++this.exchangeCount;
    }

    synchronized int endExchange() {
        --this.exchangeCount;
        assert (this.exchangeCount >= 0);
        return this.exchangeCount;
    }

    HttpServer getWrapper() {
        return this.wrapper;
    }

    void requestStarted(HttpConnection httpConnection) {
        httpConnection.creationTime = this.getTime();
        httpConnection.setState(HttpConnection.State.REQUEST);
        this.reqConnections.add(httpConnection);
    }

    void requestCompleted(HttpConnection httpConnection) {
        assert (httpConnection.getState() == HttpConnection.State.REQUEST);
        this.reqConnections.remove(httpConnection);
        httpConnection.rspStartedTime = this.getTime();
        this.rspConnections.add(httpConnection);
        httpConnection.setState(HttpConnection.State.RESPONSE);
    }

    void responseCompleted(HttpConnection httpConnection) {
        assert (httpConnection.getState() == HttpConnection.State.RESPONSE);
        this.rspConnections.remove(httpConnection);
        httpConnection.setState(HttpConnection.State.IDLE);
    }

    void logStackTrace(String string) {
        this.logger.finest(string);
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuilder.append(stackTraceElementArray[i].toString()).append("\n");
        }
        this.logger.finest(stringBuilder.toString());
    }

    static long getTimeMillis(long l) {
        if (l == -1L) {
            return -1L;
        }
        return l * 1000L;
    }

    static boolean isValidHeaderKey(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        char[] cArray = string.toCharArray();
        String string2 = "!#$%&'*+-.^_`|~";
        for (char c : cArray) {
            boolean bl;
            boolean bl2 = bl = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
            if (bl || string2.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    class ServerTimerTask1
    extends TimerTask {
        ServerTimerTask1() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList<HttpConnection> linkedList = new LinkedList<HttpConnection>();
            ServerImpl.this.time = System.currentTimeMillis();
            Set set = ServerImpl.this.reqConnections;
            synchronized (set) {
                if (MAX_REQ_TIME != -1L) {
                    for (HttpConnection httpConnection : ServerImpl.this.reqConnections) {
                        if (httpConnection.creationTime + TIMER_MILLIS + MAX_REQ_TIME > ServerImpl.this.time) continue;
                        linkedList.add(httpConnection);
                    }
                    for (HttpConnection httpConnection : linkedList) {
                        ServerImpl.this.logger.log(Level.FINE, "closing: no request: " + httpConnection);
                        ServerImpl.this.reqConnections.remove(httpConnection);
                        ServerImpl.this.allConnections.remove(httpConnection);
                        httpConnection.close();
                    }
                }
            }
            linkedList = new LinkedList();
            set = ServerImpl.this.rspConnections;
            synchronized (set) {
                if (MAX_RSP_TIME != -1L) {
                    for (HttpConnection httpConnection : ServerImpl.this.rspConnections) {
                        if (httpConnection.rspStartedTime + TIMER_MILLIS + MAX_RSP_TIME > ServerImpl.this.time) continue;
                        linkedList.add(httpConnection);
                    }
                    for (HttpConnection httpConnection : linkedList) {
                        ServerImpl.this.logger.log(Level.FINE, "closing: no response: " + httpConnection);
                        ServerImpl.this.rspConnections.remove(httpConnection);
                        ServerImpl.this.allConnections.remove(httpConnection);
                        httpConnection.close();
                    }
                }
            }
        }
    }

    class ServerTimerTask
    extends TimerTask {
        ServerTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList<HttpConnection> linkedList = new LinkedList<HttpConnection>();
            ServerImpl.this.time = System.currentTimeMillis();
            ServerImpl.this.ticks++;
            Set set = ServerImpl.this.idleConnections;
            synchronized (set) {
                for (HttpConnection httpConnection : ServerImpl.this.idleConnections) {
                    if (httpConnection.time > ServerImpl.this.time) continue;
                    linkedList.add(httpConnection);
                }
                for (HttpConnection httpConnection : linkedList) {
                    ServerImpl.this.idleConnections.remove(httpConnection);
                    ServerImpl.this.allConnections.remove(httpConnection);
                    httpConnection.close();
                }
            }
        }
    }

    class Exchange
    implements Runnable {
        SocketChannel chan;
        HttpConnection connection;
        HttpContextImpl context;
        InputStream rawin;
        OutputStream rawout;
        String protocol;
        ExchangeImpl tx;
        HttpContextImpl ctx;
        boolean rejected = false;

        Exchange(SocketChannel socketChannel, String string, HttpConnection httpConnection) throws IOException {
            this.chan = socketChannel;
            this.connection = httpConnection;
            this.protocol = string;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.context = this.connection.getHttpContext();
            SSLEngine sSLEngine = null;
            String string = null;
            SSLStreams sSLStreams = null;
            try {
                String string2;
                Object object;
                long l;
                Headers headers;
                String string3;
                URI uRI;
                String string4;
                Request request;
                boolean bl;
                block31: {
                    if (this.context != null) {
                        this.rawin = this.connection.getInputStream();
                        this.rawout = this.connection.getRawOutputStream();
                        bl = false;
                    } else {
                        bl = true;
                        if (ServerImpl.this.https) {
                            if (ServerImpl.this.sslContext == null) {
                                ServerImpl.this.logger.warning("SSL connection received. No https contxt created");
                                throw new HttpError("No SSL context established");
                            }
                            sSLStreams = new SSLStreams(ServerImpl.this, ServerImpl.this.sslContext, this.chan);
                            this.rawin = sSLStreams.getInputStream();
                            this.rawout = sSLStreams.getOutputStream();
                            sSLEngine = sSLStreams.getSSLEngine();
                            this.connection.sslStreams = sSLStreams;
                        } else {
                            this.rawin = new BufferedInputStream(new Request.ReadStream(ServerImpl.this, this.chan));
                            this.rawout = new Request.WriteStream(ServerImpl.this, this.chan);
                        }
                        this.connection.raw = this.rawin;
                        this.connection.rawout = this.rawout;
                    }
                    request = new Request(this.rawin, this.rawout);
                    string = request.requestLine();
                    if (string == null) {
                        ServerImpl.this.closeConnection(this.connection);
                        return;
                    }
                    int n = string.indexOf(32);
                    if (n == -1) {
                        this.reject(400, string, "Bad request line");
                        return;
                    }
                    string4 = string.substring(0, n);
                    int n2 = n + 1;
                    if ((n = string.indexOf(32, n2)) == -1) {
                        this.reject(400, string, "Bad request line");
                        return;
                    }
                    String string5 = string.substring(n2, n);
                    uRI = new URI(string5);
                    n2 = n + 1;
                    string3 = string.substring(n2);
                    headers = request.headers();
                    for (String string6 : headers.keySet()) {
                        if (ServerImpl.isValidHeaderKey(string6)) continue;
                        this.reject(400, string, "Header key contains illegal characters");
                        return;
                    }
                    if (headers.containsKey("Content-Length") && (headers.containsKey("Transfer-encoding") || headers.get("Content-Length").size() > 1)) {
                        this.reject(400, string, "Conflicting or malformed headers detected");
                        return;
                    }
                    l = 0L;
                    String string7 = null;
                    Object object2 = headers.get("Transfer-encoding");
                    if (object2 != null && !object2.isEmpty()) {
                        string7 = (String)object2.get(0);
                    }
                    if (string7 != null) {
                        if (string7.equalsIgnoreCase("chunked") && object2.size() == 1) {
                            l = -1L;
                            break block31;
                        } else {
                            this.reject(501, string, "Unsupported Transfer-Encoding value");
                            return;
                        }
                    }
                    string7 = headers.getFirst("Content-Length");
                    if (string7 != null && (l = Long.parseLong(string7)) < 0L) {
                        this.reject(400, string, "Illegal Content-Length value");
                        return;
                    }
                    if (l == 0L) {
                        ServerImpl.this.requestCompleted(this.connection);
                    }
                }
                this.ctx = ServerImpl.this.contexts.findContext(this.protocol, uRI.getPath());
                if (this.ctx == null) {
                    this.reject(404, string, "No context found for request");
                    return;
                }
                this.connection.setContext(this.ctx);
                if (this.ctx.getHandler() == null) {
                    this.reject(500, string, "No handler for context");
                    return;
                }
                this.tx = new ExchangeImpl(string4, uRI, request, l, this.connection);
                String string8 = headers.getFirst("Connection");
                Headers headers2 = this.tx.getResponseHeaders();
                if (string8 != null && string8.equalsIgnoreCase("close")) {
                    this.tx.close = true;
                }
                if (string3.equalsIgnoreCase("http/1.0")) {
                    this.tx.http10 = true;
                    if (string8 == null) {
                        this.tx.close = true;
                        headers2.set("Connection", "close");
                    } else if (string8.equalsIgnoreCase("keep-alive")) {
                        headers2.set("Connection", "keep-alive");
                        int n = (int)(ServerConfig.getIdleInterval() / 1000L);
                        int n3 = ServerConfig.getMaxIdleConnections();
                        object = "timeout=" + n + ", max=" + n3;
                        headers2.set("Keep-Alive", (String)object);
                    }
                }
                if (bl) {
                    this.connection.setParameters(this.rawin, this.rawout, this.chan, sSLEngine, sSLStreams, ServerImpl.this.sslContext, this.protocol, this.ctx, this.rawin);
                }
                if ((string2 = headers.getFirst("Expect")) != null && string2.equalsIgnoreCase("100-continue")) {
                    ServerImpl.this.logReply(100, string, null);
                    this.sendReply(100, false, null);
                }
                List<Filter> list = this.ctx.getSystemFilters();
                object = this.ctx.getFilters();
                Filter.Chain chain = new Filter.Chain(list, this.ctx.getHandler());
                Filter.Chain chain2 = new Filter.Chain((List<Filter>)object, new LinkHandler(chain));
                this.tx.getRequestBody();
                this.tx.getResponseBody();
                if (ServerImpl.this.https) {
                    chain2.doFilter(new HttpsExchangeImpl(this.tx));
                    return;
                }
                chain2.doFilter(new HttpExchangeImpl(this.tx));
                return;
            }
            catch (IOException iOException) {
                ServerImpl.this.logger.log(Level.FINER, "ServerImpl.Exchange (1)", iOException);
                ServerImpl.this.closeConnection(this.connection);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.reject(400, string, "NumberFormatException thrown");
                return;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.reject(400, string, "URISyntaxException thrown");
                return;
            }
            catch (Exception exception) {
                ServerImpl.this.logger.log(Level.FINER, "ServerImpl.Exchange (2)", exception);
                ServerImpl.this.closeConnection(this.connection);
            }
        }

        void reject(int n, String string, String string2) {
            this.rejected = true;
            ServerImpl.this.logReply(n, string, string2);
            this.sendReply(n, false, "<h1>" + n + Code.msg(n) + "</h1>" + string2);
            ServerImpl.this.closeConnection(this.connection);
        }

        void sendReply(int n, boolean bl, String string) {
            try {
                StringBuilder stringBuilder = new StringBuilder(512);
                stringBuilder.append("HTTP/1.1 ").append(n).append(Code.msg(n)).append("\r\n");
                if (string != null && string.length() != 0) {
                    stringBuilder.append("Content-Length: ").append(string.length()).append("\r\n").append("Content-Type: text/html\r\n");
                } else {
                    stringBuilder.append("Content-Length: 0\r\n");
                    string = "";
                }
                if (bl) {
                    stringBuilder.append("Connection: close\r\n");
                }
                stringBuilder.append("\r\n").append(string);
                String string2 = stringBuilder.toString();
                byte[] byArray = string2.getBytes("ISO8859_1");
                this.rawout.write(byArray);
                this.rawout.flush();
                if (bl) {
                    ServerImpl.this.closeConnection(this.connection);
                }
            }
            catch (IOException iOException) {
                ServerImpl.this.logger.log(Level.FINER, "ServerImpl.sendReply", iOException);
                ServerImpl.this.closeConnection(this.connection);
            }
        }

        class LinkHandler
        implements HttpHandler {
            Filter.Chain nextChain;

            LinkHandler(Filter.Chain chain) {
                this.nextChain = chain;
            }

            @Override
            public void handle(HttpExchange httpExchange) throws IOException {
                this.nextChain.doFilter(httpExchange);
            }
        }
    }

    class Dispatcher
    implements Runnable {
        final LinkedList<HttpConnection> connsToRegister = new LinkedList();

        Dispatcher() {
        }

        private void handleEvent(Event event) {
            ExchangeImpl exchangeImpl = event.exchange;
            HttpConnection httpConnection = exchangeImpl.getConnection();
            try {
                if (event instanceof WriteFinishedEvent) {
                    int n = ServerImpl.this.endExchange();
                    if (ServerImpl.this.terminating && n == 0) {
                        ServerImpl.this.finished = true;
                    }
                    ServerImpl.this.responseCompleted(httpConnection);
                    LeftOverInputStream leftOverInputStream = exchangeImpl.getOriginalInputStream();
                    if (!leftOverInputStream.isEOF()) {
                        exchangeImpl.close = true;
                    }
                    if (exchangeImpl.close || ServerImpl.this.idleConnections.size() >= MAX_IDLE_CONNECTIONS) {
                        httpConnection.close();
                        ServerImpl.this.allConnections.remove(httpConnection);
                    } else if (leftOverInputStream.isDataBuffered()) {
                        ServerImpl.this.requestStarted(httpConnection);
                        this.handle(httpConnection.getChannel(), httpConnection);
                    } else {
                        this.connsToRegister.add(httpConnection);
                    }
                }
            }
            catch (IOException iOException) {
                ServerImpl.this.logger.log(Level.FINER, "Dispatcher (1)", iOException);
                httpConnection.close();
            }
        }

        void reRegister(HttpConnection httpConnection) {
            try {
                SocketChannel socketChannel = httpConnection.getChannel();
                socketChannel.configureBlocking(false);
                SelectionKey selectionKey = socketChannel.register(ServerImpl.this.selector, 1);
                selectionKey.attach(httpConnection);
                httpConnection.selectionKey = selectionKey;
                httpConnection.time = ServerImpl.this.getTime() + IDLE_INTERVAL;
                ServerImpl.this.idleConnections.add(httpConnection);
            }
            catch (IOException iOException) {
                ServerImpl.dprint(iOException);
                ServerImpl.this.logger.log(Level.FINER, "Dispatcher(8)", iOException);
                httpConnection.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!ServerImpl.this.finished) {
                try {
                    List list = null;
                    Object object = ServerImpl.this.lolock;
                    synchronized (object) {
                        if (ServerImpl.this.events.size() > 0) {
                            list = ServerImpl.this.events;
                            ServerImpl.this.events = new LinkedList();
                        }
                    }
                    if (list != null) {
                        for (Event event : list) {
                            this.handleEvent(event);
                        }
                    }
                    for (HttpConnection httpConnection : this.connsToRegister) {
                        this.reRegister(httpConnection);
                    }
                    this.connsToRegister.clear();
                    ServerImpl.this.selector.select(1000L);
                    object = ServerImpl.this.selector.selectedKeys();
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        HttpConnection httpConnection;
                        Object object2;
                        SelectionKey selectionKey = (SelectionKey)iterator2.next();
                        iterator2.remove();
                        if (selectionKey.equals(ServerImpl.this.listenerKey)) {
                            if (ServerImpl.this.terminating) continue;
                            SocketChannel socketChannel = ServerImpl.this.schan.accept();
                            if (ServerConfig.noDelay()) {
                                socketChannel.socket().setTcpNoDelay(true);
                            }
                            if (socketChannel == null) continue;
                            socketChannel.configureBlocking(false);
                            object2 = socketChannel.register(ServerImpl.this.selector, 1);
                            httpConnection = new HttpConnection();
                            httpConnection.selectionKey = object2;
                            httpConnection.setChannel(socketChannel);
                            ((SelectionKey)object2).attach(httpConnection);
                            ServerImpl.this.requestStarted(httpConnection);
                            ServerImpl.this.allConnections.add(httpConnection);
                            continue;
                        }
                        try {
                            if (selectionKey.isReadable()) {
                                object2 = (SocketChannel)selectionKey.channel();
                                httpConnection = (HttpConnection)selectionKey.attachment();
                                selectionKey.cancel();
                                ((AbstractSelectableChannel)object2).configureBlocking(true);
                                if (ServerImpl.this.idleConnections.remove(httpConnection)) {
                                    ServerImpl.this.requestStarted(httpConnection);
                                }
                                this.handle((SocketChannel)object2, httpConnection);
                                continue;
                            }
                            assert (false);
                        }
                        catch (CancelledKeyException cancelledKeyException) {
                            this.handleException(selectionKey, null);
                        }
                        catch (IOException iOException) {
                            this.handleException(selectionKey, iOException);
                        }
                    }
                    ServerImpl.this.selector.selectNow();
                }
                catch (IOException iOException) {
                    ServerImpl.this.logger.log(Level.FINER, "Dispatcher (4)", iOException);
                }
                catch (Exception exception) {
                    ServerImpl.this.logger.log(Level.FINER, "Dispatcher (7)", exception);
                }
            }
            try {
                ServerImpl.this.selector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void handleException(SelectionKey selectionKey, Exception exception) {
            HttpConnection httpConnection = (HttpConnection)selectionKey.attachment();
            if (exception != null) {
                ServerImpl.this.logger.log(Level.FINER, "Dispatcher (2)", exception);
            }
            ServerImpl.this.closeConnection(httpConnection);
        }

        public void handle(SocketChannel socketChannel, HttpConnection httpConnection) throws IOException {
            try {
                Exchange exchange = new Exchange(socketChannel, ServerImpl.this.protocol, httpConnection);
                ServerImpl.this.executor.execute(exchange);
            }
            catch (HttpError httpError) {
                ServerImpl.this.logger.log(Level.FINER, "Dispatcher (4)", httpError);
                ServerImpl.this.closeConnection(httpConnection);
            }
            catch (IOException iOException) {
                ServerImpl.this.logger.log(Level.FINER, "Dispatcher (5)", iOException);
                ServerImpl.this.closeConnection(httpConnection);
            }
        }
    }

    private static class DefaultExecutor
    implements Executor {
        private DefaultExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }
}

