/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class ClangReturnType
extends ClangTokenGroup {
    private DataType datatype = null;
    private Varnode varnode = null;

    public ClangReturnType(ClangNode par) {
        super(par);
    }

    public DataType getDataType() {
        return this.datatype;
    }

    public Varnode getVarnode() {
        return this.varnode;
    }

    @Override
    public void restoreFromXML(XmlPullParser parser, PcodeFactory pfactory) {
        XmlElement node = parser.peek();
        super.restoreFromXML(parser, pfactory);
        String varrefstring = node.getAttribute("varref");
        if (varrefstring != null) {
            int refid = SpecXmlUtils.decodeInt((String)varrefstring);
            this.varnode = pfactory.getRef(refid);
            if (this.varnode != null) {
                if (this.varnode.getHigh() == null) {
                    Msg.warn((Object)this, (Object)("VOID high variable problem at " + this.varnode.getAddress()));
                    return;
                }
                this.datatype = this.varnode.getHigh().getDataType();
            }
        }
    }
}

