/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OdexedFieldAccess;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction22cs
extends Instruction
implements TwoRegisterInstruction,
OdexedFieldAccess {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte regB;
    private short fieldOffset;

    public Instruction22cs(Opcode opcode, byte regA, byte regB, int fieldOffset) {
        super(opcode);
        if (regA >= 16 || regB >= 16) {
            throw new RuntimeException("The register number must be less than v16");
        }
        if (fieldOffset >= 65536) {
            throw new RuntimeException("The field offset must be less than 65536");
        }
        this.regA = regA;
        this.regB = regB;
        this.fieldOffset = (short)fieldOffset;
    }

    private Instruction22cs(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regA = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 1]);
        this.regB = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 1]);
        this.fieldOffset = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 2);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regB << 4 | this.regA);
        out.writeShort(this.fieldOffset);
    }

    @Override
    public Format getFormat() {
        return Format.Format22cs;
    }

    @Override
    public int getRegisterA() {
        return this.regA;
    }

    @Override
    public int getRegisterB() {
        return this.regB;
    }

    @Override
    public int getFieldOffset() {
        return this.fieldOffset & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction22cs(opcode, buffer, bufferIndex);
        }
    }
}

