/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.shape;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.picking.ShapePickSupport;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;

public class VisualGraphShapePickSupport<V extends VisualVertex, E extends VisualEdge<V>>
extends ShapePickSupport<V, E> {
    public VisualGraphShapePickSupport(VisualizationServer<V, E> viewer) {
        super(viewer);
    }

    protected Collection<V> getFilteredVertices(Layout<V, E> layout) {
        return GraphViewerUtils.createCollectionWithZOrderBySelection(super.getFilteredVertices(layout));
    }

    public E getEdge(Layout<V, E> layout, double viewSpaceX, double viewSpaceY) {
        Point2D.Double viewSpacePoint = new Point2D.Double(viewSpaceX, viewSpaceY);
        Point graphSpacePoint = GraphViewerUtils.translatePointFromViewSpaceToGraphSpace(viewSpacePoint, this.vv);
        Rectangle2D.Float pickArea = new Rectangle2D.Float((float)graphSpacePoint.x - this.pickSize / 2.0f, (float)graphSpacePoint.y - this.pickSize / 2.0f, this.pickSize, this.pickSize);
        VisualEdge closestEdge = null;
        double smallestDistance = Double.MAX_VALUE;
        for (VisualEdge e : this.getFilteredEdges(layout)) {
            Shape edgeShape = GraphViewerUtils.getEdgeShapeInGraphSpace(this.vv, e);
            if (edgeShape == null || !edgeShape.intersects(pickArea)) continue;
            float[] coords = new float[6];
            GeneralPath path = new GeneralPath(edgeShape);
            PathIterator iterator = path.getPathIterator(null);
            if (iterator.isDone()) continue;
            iterator.next();
            iterator.currentSegment(coords);
            float segmentX = coords[0];
            float deltaX = segmentX - (float)graphSpacePoint.x;
            float segmentY = coords[1];
            float deltaY = segmentY - (float)graphSpacePoint.y;
            float currentDistance = deltaX * deltaX + deltaY * deltaY;
            if (!((double)currentDistance < smallestDistance)) continue;
            smallestDistance = currentDistance;
            closestEdge = e;
        }
        return (E)closestEdge;
    }
}

