/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.ps.ebr;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.jparted.lib.ps.ebr.EBRPartition;

public class ExtendedBootRecord {
    public static final short MBR_SIGNATURE = 21930;
    protected final byte[] reserved1 = new byte[394];
    protected final byte[] optIBMBootmgrEntry = new byte[9];
    protected final byte[] reserved2 = new byte[37];
    protected final byte[] optDiskSignature = new byte[4];
    protected final byte[] reserved3 = new byte[2];
    protected final EBRPartition firstEntry;
    protected final EBRPartition secondEntry;
    protected final byte[] reserved4 = new byte[32];
    protected final byte[] mbrSignature = new byte[2];

    public ExtendedBootRecord(byte[] data, int offset, long extendedPartitionOffset, long thisRecordOffset, int sectorSize) {
        System.arraycopy(data, offset + 0, this.reserved1, 0, this.reserved1.length);
        System.arraycopy(data, offset + 394, this.optIBMBootmgrEntry, 0, this.optIBMBootmgrEntry.length);
        System.arraycopy(data, offset + 403, this.reserved2, 0, this.reserved2.length);
        System.arraycopy(data, offset + 440, this.optDiskSignature, 0, this.optDiskSignature.length);
        System.arraycopy(data, offset + 444, this.reserved3, 0, this.reserved3.length);
        this.firstEntry = new EBRPartition(data, offset + 446, thisRecordOffset, sectorSize);
        this.secondEntry = new EBRPartition(data, offset + 462, extendedPartitionOffset, sectorSize);
        System.arraycopy(data, offset + 478, this.reserved4, 0, this.reserved4.length);
        System.arraycopy(data, offset + 510, this.mbrSignature, 0, this.mbrSignature.length);
        if (!Util.arrayRegionsEqual((byte[])this.getBytes(), (int)0, (int)ExtendedBootRecord.getStructSize(), (byte[])data, (int)offset, (int)ExtendedBootRecord.getStructSize())) {
            throw new RuntimeException("Internal error!");
        }
    }

    public ExtendedBootRecord(ExtendedBootRecord source) {
        System.arraycopy(source.reserved1, 0, this.reserved1, 0, this.reserved1.length);
        System.arraycopy(source.optIBMBootmgrEntry, 0, this.optIBMBootmgrEntry, 0, this.optIBMBootmgrEntry.length);
        System.arraycopy(source.reserved2, 0, this.reserved2, 0, this.reserved2.length);
        System.arraycopy(source.optDiskSignature, 0, this.optDiskSignature, 0, this.optDiskSignature.length);
        System.arraycopy(source.reserved3, 0, this.reserved3, 0, this.reserved3.length);
        this.firstEntry = new EBRPartition(source.firstEntry);
        this.secondEntry = new EBRPartition(source.secondEntry);
        System.arraycopy(source.reserved4, 0, this.reserved3, 0, this.reserved4.length);
        System.arraycopy(source.mbrSignature, 0, this.mbrSignature, 0, this.mbrSignature.length);
    }

    public static int getStructSize() {
        return 512;
    }

    public byte[] getOptionalIBMBootManagerEntry() {
        return Util.createCopy((byte[])this.optIBMBootmgrEntry);
    }

    public int getOptionalDiskSignature() {
        return Util.readIntBE((byte[])this.optDiskSignature);
    }

    public EBRPartition getFirstEntry() {
        return this.firstEntry;
    }

    public EBRPartition getSecondEntry() {
        return this.secondEntry;
    }

    public short getMBRSignature() {
        return Util.readShortBE((byte[])this.mbrSignature);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " diskSignature: 0x" + Util.toHexStringBE((int)this.getOptionalDiskSignature()) + " (optional, and possibly incorrect)");
        ps.println(prefix + " firstEntry:");
        if (this.firstEntry.isValid()) {
            this.firstEntry.print(ps, prefix + "  ");
        } else {
            ps.println(prefix + "  [Invalid data]");
        }
        ps.println(prefix + " secondEntry:");
        if (this.secondEntry.isValid()) {
            this.secondEntry.print(ps, prefix + "  ");
        } else {
            ps.println(prefix + "  [Invalid data]");
        }
        ps.println(prefix + " mbrSignature: 0x" + Util.toHexStringBE((short)this.getMBRSignature()));
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + this.getClass().getSimpleName() + ":");
        this.printFields(ps, prefix);
    }

    public boolean isValid() {
        return this.getMBRSignature() == 21930 && this.isPartitionInfoValid();
    }

    public boolean isPartitionInfoValid() {
        return this.firstEntry.isValid() && this.secondEntry.isValid();
    }

    public byte[] getBytes() {
        byte[] result = new byte[512];
        int i = 0;
        System.arraycopy(this.reserved1, 0, result, i, this.reserved1.length);
        System.arraycopy(this.optIBMBootmgrEntry, 0, result, i += this.reserved1.length, this.optIBMBootmgrEntry.length);
        System.arraycopy(this.reserved2, 0, result, i += this.optIBMBootmgrEntry.length, this.reserved2.length);
        System.arraycopy(this.optDiskSignature, 0, result, i += this.reserved2.length, this.optDiskSignature.length);
        System.arraycopy(this.reserved3, 0, result, i += this.optDiskSignature.length, this.reserved3.length);
        byte[] curData = this.firstEntry.getBytes();
        System.arraycopy(curData, 0, result, i += this.reserved3.length, curData.length);
        i += curData.length;
        curData = this.secondEntry.getBytes();
        System.arraycopy(curData, 0, result, i, curData.length);
        System.arraycopy(this.reserved4, 0, result, i += curData.length, this.reserved4.length);
        System.arraycopy(this.mbrSignature, 0, result, i += this.reserved4.length, this.mbrSignature.length);
        if ((i += this.mbrSignature.length) != result.length) {
            throw new RuntimeException("Internal error!");
        }
        return result;
    }

    public boolean isTerminator() {
        return this.secondEntry.getLBAFirstSector() == 0 && this.secondEntry.getLBAPartitionLength() == 0;
    }
}

