/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.ActionContext;
import docking.AutoLookupKeyStrokeConsumer;
import docking.DockingTool;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.KeyStrokeConsumer;
import docking.action.ComponentBasedDockingAction;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.actions.KeyBindingUtils;
import docking.actions.ToolActions;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.SettingsDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.table.AbstractGTableModel;
import docking.widgets.table.ChooseColumnsDialog;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.ConfigurableColumnTableModel;
import docking.widgets.table.DefaultTableCellRendererWrapper;
import docking.widgets.table.GBooleanCellRenderer;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.table.GTableHeader;
import docking.widgets.table.GTableHeaderRenderer;
import docking.widgets.table.GTableMouseListener;
import docking.widgets.table.GTableToCSV;
import docking.widgets.table.RowObjectSelectionManager;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.SelectColumnsDialog;
import docking.widgets.table.SelectionManager;
import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableSortState;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import resources.ResourceManager;

public class GTable
extends JTable
implements KeyStrokeConsumer {
    private static final KeyStroke COPY_KEY_STROKE = KeyStroke.getKeyStroke(67, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
    private static final KeyStroke COPY_COLUMN_KEY_STROKE = KeyStroke.getKeyStroke(67, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40);
    private static final KeyStroke SELECT_ALL_KEY_STROKE = KeyStroke.getKeyStroke(65, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
    private static final String LAST_EXPORT_FILE = "LAST_EXPORT_DIR";
    private int userDefinedRowHeight;
    private boolean isInitialized;
    private boolean allowActions;
    private KeyListener autoLookupListener;
    private long lastLookupTime;
    private String lookupString;
    private int lookupColumn = -1;
    private AutoLookupKeyStrokeConsumer autoLookupKeyStrokeConsumer = new AutoLookupKeyStrokeConsumer();
    protected List<TableCellRenderer> defaultGTableRendererList = new ArrayList<TableCellRenderer>();
    private boolean htmlRenderingEnabled;
    private String preferenceKey;
    private GTableMouseListener headerMouseListener;
    private JPopupMenu tableHeaderPopupMenu;
    private boolean columnHeaderPopupEnabled = true;
    private int lastPopupColumnIndex;
    private boolean copying;
    private SelectionManager selectionManager;
    private Integer visibleRowCount;
    public static final long KEY_TIMEOUT = 800L;
    private static final KeyStroke ESCAPE = KeyStroke.getKeyStroke("ESCAPE");
    private TableModelListener rowHeightListener = e -> this.adjustRowHeight();
    private TableColumnModelListener tableColumnModelListener = null;
    private final Map<Integer, GTableCellRenderingData> columnRenderingDataMap = new HashMap<Integer, GTableCellRenderingData>();

    public GTable() {
        this.init();
    }

    public GTable(TableModel dm) {
        super(dm);
        this.init();
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        if (this.visibleRowCount != null) {
            int height = this.getRowHeight() * this.visibleRowCount;
            size.height = Math.max(size.height, height);
        }
        return size;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    public void selectRow(int row) {
        this.setRowSelectionInterval(row, row);
    }

    public boolean selectRow(MouseEvent event) {
        if (event.getSource() != this) {
            return false;
        }
        int row = this.rowAtPoint(event.getPoint());
        if (row >= 0) {
            if (!this.isRowSelected(row)) {
                this.setRowSelectionInterval(row, row);
            }
            return true;
        }
        return false;
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new GTableColumnModel(this);
    }

    @Override
    public void setColumnModel(TableColumnModel columnModel) {
        super.setColumnModel(columnModel);
        this.setTableHeader(new GTableHeader(this));
        JTableHeader header = this.getTableHeader();
        this.initializeHeader(header);
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        if (this.selectionManager != null) {
            this.selectionManager.dispose();
            this.selectionManager = null;
        }
        super.setSelectionModel(newModel);
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (this.selectionManager != null) {
            this.selectionManager.dispose();
        }
        super.setModel(dataModel);
        this.initializeRowHeight();
        this.selectionManager = this.createSelectionManager(dataModel);
    }

    protected <T> SelectionManager createSelectionManager(TableModel model) {
        if (model instanceof RowObjectTableModel) {
            return new RowObjectSelectionManager(this, (RowObjectTableModel)model);
        }
        return null;
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void notifyTableChanged(TableModelEvent event) {
        if (this.selectionManager != null) {
            this.selectionManager.tableChanged(event);
        }
        this.tableChanged(event);
    }

    public void dispose() {
        if (this.dataModel instanceof AbstractGTableModel) {
            ((AbstractGTableModel)this.dataModel).dispose();
        }
        if (this.columnModel instanceof GTableColumnModel) {
            ((GTableColumnModel)this.columnModel).dispose();
        }
    }

    private int getRow(TableModel model, String keyString) {
        SortedTableModel sortedModel;
        if (keyString == null) {
            return -1;
        }
        int currRow = this.getSelectedRow();
        if (currRow >= 0 && currRow < this.getRowCount() - 1) {
            Object obj;
            if (keyString.length() == 1) {
                ++currRow;
            }
            if ((obj = this.getValueAt(currRow, this.convertColumnIndexToView(this.lookupColumn))) != null && obj.toString().toLowerCase().startsWith(keyString.toLowerCase())) {
                return currRow;
            }
        }
        if (model instanceof SortedTableModel && this.lookupColumn == (sortedModel = (SortedTableModel)model).getPrimarySortColumnIndex()) {
            return this.autoLookupBinary(sortedModel, keyString);
        }
        return this.autoLookupLinear(keyString);
    }

    private int autoLookupLinear(String keyString) {
        Object obj;
        int i;
        int rowCount = this.getRowCount();
        int startRow = this.getSelectedRow();
        int counter = 0;
        int col = this.convertColumnIndexToView(this.lookupColumn);
        for (i = startRow + 1; i < rowCount; ++i) {
            obj = this.getValueAt(i, col);
            if (obj != null && obj.toString().toLowerCase().startsWith(keyString.toLowerCase())) {
                return i;
            }
            if (counter++ <= 50000) continue;
            return -1;
        }
        for (i = 0; i < startRow; ++i) {
            obj = this.getValueAt(i, col);
            if (obj != null && obj.toString().toLowerCase().startsWith(keyString.toLowerCase())) {
                return i;
            }
            if (counter++ <= 50000) continue;
            return -1;
        }
        return -1;
    }

    private int autoLookupBinary(SortedTableModel model, String keyString) {
        Object modifiedLookupString = keyString;
        int sortedOrder = 1;
        int primarySortColumnIndex = model.getPrimarySortColumnIndex();
        TableSortState columnSortState = model.getTableSortState();
        ColumnSortState sortState = columnSortState.getColumnSortState(primarySortColumnIndex);
        if (!sortState.isAscending()) {
            sortedOrder = -1;
            int lastCharPos = ((String)modifiedLookupString).length() - 1;
            char lastChar = ((String)modifiedLookupString).charAt(lastCharPos);
            lastChar = (char)(lastChar + '\u0001');
            modifiedLookupString = ((String)modifiedLookupString).substring(0, lastCharPos) + lastChar;
        }
        int min = 0;
        int max = model.getRowCount() - 1;
        int col = this.convertColumnIndexToView(this.lookupColumn);
        while (min < max) {
            int i = (min + max) / 2;
            Object obj = this.getValueAt(i, col);
            if (obj == null) {
                obj = "";
            }
            int compare = ((String)modifiedLookupString).toString().compareToIgnoreCase(obj.toString());
            if ((compare *= sortedOrder) < 0) {
                max = i - 1;
                continue;
            }
            if (compare > 0) {
                min = i + 1;
                continue;
            }
            return i;
        }
        String value = this.getValueAt(min, col).toString();
        if (value.toLowerCase().startsWith(keyString.toLowerCase())) {
            return min;
        }
        if (min - 1 >= 0 && (value = this.getValueAt(min - 1, col).toString()).toLowerCase().startsWith(keyString.toLowerCase())) {
            return min - 1;
        }
        if (min + 1 < this.dataModel.getRowCount() && (value = this.getValueAt(min + 1, col).toString()).toLowerCase().startsWith(keyString.toLowerCase())) {
            return min + 1;
        }
        return -1;
    }

    public void setAutoLookupColumn(int lookupColumn) {
        this.lookupColumn = lookupColumn;
        if (this.autoLookupListener == null) {
            this.autoLookupListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (GTable.this.getRowCount() == 0) {
                        return;
                    }
                    if (this.isIgnorableKeyEvent(e)) {
                        return;
                    }
                    long when = e.getWhen();
                    GTable.this.lookupString = when - GTable.this.lastLookupTime > 800L ? "" + e.getKeyChar() : GTable.this.lookupString + e.getKeyChar();
                    int row = GTable.this.getRow(GTable.this.dataModel, GTable.this.lookupString);
                    if (row >= 0) {
                        GTable.this.setRowSelectionInterval(row, row);
                        Rectangle rect = GTable.this.getCellRect(row, 0, false);
                        GTable.this.scrollRectToVisible(rect);
                    }
                    GTable.this.lastLookupTime = when;
                }

                private boolean isIgnorableKeyEvent(KeyEvent event) {
                    if (event.isAltDown() || event.isAltGraphDown() || event.isControlDown() || event.isMetaDown()) {
                        return true;
                    }
                    return event.isActionKey() || event.getKeyChar() == '\uffff' || Character.isISOControl(event.getKeyChar());
                }
            };
        }
        if (lookupColumn >= 0 && lookupColumn < this.getModel().getColumnCount()) {
            this.addKeyListener(this.autoLookupListener);
        } else {
            this.removeKeyListener(this.autoLookupListener);
        }
    }

    public void setActionsEnabled(boolean b) {
        this.allowActions = b;
    }

    @Override
    public boolean isKeyConsumed(KeyStroke keyStroke) {
        if (this.allowActions) {
            return false;
        }
        return this.autoLookupKeyStrokeConsumer.isKeyConsumed(keyStroke);
    }

    public void setAutoEditEnabled(boolean allowAutoEdit) {
        this.putClientProperty("JTable.autoStartsEdit", allowAutoEdit);
    }

    private void installEditKeyBinding() {
        AbstractAction action = new AbstractAction("StartEdit"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int row = GTable.this.getSelectedRow();
                int col = GTable.this.getSelectedColumn();
                if (col == -1) {
                    Toolkit.getDefaultToolkit().beep();
                }
                KeyEvent evt = new KeyEvent(GTable.this, 0, 0L, 0, 0, '\uffff');
                GTable.this.editCellAt(row, col, evt);
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(113, 0);
        KeyBindingUtils.registerAction((JComponent)this, ks, action, 0);
    }

    private void init() {
        ToolTipManager.sharedInstance().unregisterComponent(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setTableHeader(new GTableHeader(this));
        this.setAutoEditEnabled(false);
        this.installEditKeyBinding();
        this.initDefaultRenderers();
        this.disableGridLines();
        JTableHeader header = this.getTableHeader();
        this.initializeHeader(header);
        this.setAutoResizeMode(2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row;
                if (e.getButton() == 3 && (row = GTable.this.rowAtPoint(e.getPoint())) >= 0 && !GTable.this.isRowSelected(row)) {
                    GTable.this.setRowSelectionInterval(row, row);
                }
            }
        });
        this.removeActionKeyStrokes();
        this.isInitialized = true;
        this.initializeRowHeight();
    }

    private void removeActionKeyStrokes() {
        KeyBindingUtils.clearKeyBinding((JComponent)this, COPY_KEY_STROKE);
        KeyBindingUtils.clearKeyBinding((JComponent)this, COPY_COLUMN_KEY_STROKE);
        KeyBindingUtils.clearKeyBinding((JComponent)this, SELECT_ALL_KEY_STROKE);
    }

    private void initializeHeader(JTableHeader header) {
        header.setUpdateTableInRealTime(true);
        this.headerMouseListener = new GTableMouseListener(this);
        header.addMouseListener(this.headerMouseListener);
        header.addMouseMotionListener(this.headerMouseListener);
        this.tableColumnModelListener = new MyTableColumnModelListener();
        header.getColumnModel().addColumnModelListener(this.tableColumnModelListener);
    }

    private void initializeRowHeight() {
        ConfigurableColumnTableModel configurableModel = this.getConfigurableColumnTableModel();
        if (configurableModel != null) {
            configurableModel.removeTableModelListener(this.rowHeightListener);
            configurableModel.addTableModelListener(this.rowHeightListener);
        }
        this.adjustRowHeight();
    }

    private void adjustRowHeight() {
        int preferredHeight;
        if (!this.isInitialized) {
            return;
        }
        int linesPerRow = this.getLinesPerRow();
        int newHeight = linesPerRow * (preferredHeight = this.calculatePreferredRowHeight());
        if (newHeight != this.getRowHeight()) {
            this.doSetRowHeight(newHeight);
        }
    }

    private int calculatePreferredRowHeight() {
        if (this.userDefinedRowHeight != 16) {
            return this.userDefinedRowHeight;
        }
        TableCellRenderer defaultRenderer = this.getDefaultRenderer(String.class);
        try {
            Component component = defaultRenderer.getTableCellRendererComponent(this, "Ghidra", false, false, 0, 0);
            Dimension preferredSize = component.getPreferredSize();
            return preferredSize.height + 3;
        }
        catch (Throwable t) {
            return this.userDefinedRowHeight;
        }
    }

    private int getLinesPerRow() {
        int linesPerRow = 1;
        ConfigurableColumnTableModel configurableModel = this.getConfigurableColumnTableModel();
        if (configurableModel != null) {
            int columnCnt = this.getColumnCount();
            for (int i = 0; i < columnCnt; ++i) {
                int modelColumnIndex = this.convertColumnIndexToModel(i);
                int cnt = configurableModel.getMaxLines(modelColumnIndex);
                if (cnt <= linesPerRow) continue;
                linesPerRow = cnt;
            }
        }
        return linesPerRow;
    }

    @Override
    public void setRowHeight(int height) {
        this.doSetRowHeight(height);
        this.userDefinedRowHeight = height;
    }

    private void doSetRowHeight(int height) {
        super.setRowHeight(height);
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        this.adjustRowHeight();
        super.columnAdded(e);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        this.adjustRowHeight();
        super.columnRemoved(e);
    }

    public ConfigurableColumnTableModel getConfigurableColumnTableModel() {
        TableModel model = this.getUnwrappedTableModel();
        if (model instanceof ConfigurableColumnTableModel) {
            return (ConfigurableColumnTableModel)model;
        }
        return null;
    }

    protected TableModel getUnwrappedTableModel() {
        TableModel model = this.getModel();
        return RowObjectTableModel.unwrap(model);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (ks == ESCAPE && !this.isEditing()) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        if (columnClass == null) {
            return super.getDefaultRenderer(String.class);
        }
        TableCellRenderer renderer = super.getDefaultRenderer(columnClass);
        if (renderer == null) {
            renderer = super.getDefaultRenderer(String.class);
        }
        return this.wrapDefaultTableCellRenderer(renderer, columnClass);
    }

    protected TableCellRenderer wrapDefaultTableCellRenderer(TableCellRenderer renderer, Class<?> columnClass) {
        if (renderer instanceof DefaultTableCellRendererWrapper) {
            return renderer;
        }
        if (renderer instanceof GTableCellRenderer) {
            this.setDefaultRenderer(columnClass, renderer);
            return renderer;
        }
        DefaultTableCellRendererWrapper wrapper = new DefaultTableCellRendererWrapper(renderer);
        this.setDefaultRenderer(columnClass, wrapper);
        return wrapper;
    }

    protected void initDefaultRenderers() {
        GTableCellRenderer gTableCellRenderer = new GTableCellRenderer();
        this.setDefaultRenderer(String.class, gTableCellRenderer);
        this.setDefaultRenderer(Enum.class, gTableCellRenderer);
        this.setDefaultRenderer(Byte.class, gTableCellRenderer);
        this.setDefaultRenderer(Short.class, gTableCellRenderer);
        this.setDefaultRenderer(Integer.class, gTableCellRenderer);
        this.setDefaultRenderer(Long.class, gTableCellRenderer);
        this.setDefaultRenderer(Float.class, gTableCellRenderer);
        this.setDefaultRenderer(Double.class, gTableCellRenderer);
        this.setDefaultRenderer(Boolean.class, new GBooleanCellRenderer());
        this.defaultGTableRendererList.add(gTableCellRenderer);
    }

    private void disableGridLines() {
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel == null) {
            return;
        }
        TableColumnModel cm = this.getColumnModel();
        if (!(cm instanceof GTableColumnModel)) {
            super.createDefaultColumnsFromModel();
            return;
        }
        GTableColumnModel tableColumnModel = (GTableColumnModel)this.getColumnModel();
        boolean wasEnabled = tableColumnModel.setEventsEnabled(false);
        this.removeAllColumns();
        int columnCount = tableModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn newColumn = new TableColumn(i);
            this.initialTableColumnSize(newColumn, tableModel, i);
            newColumn.setHeaderRenderer(new GTableHeaderRenderer());
            this.addColumn(newColumn);
        }
        tableColumnModel.setEventsEnabled(wasEnabled);
    }

    private void removeAllColumns() {
        if (this.columnModel instanceof GTableColumnModel) {
            ((GTableColumnModel)this.columnModel).removeAllColumns();
            return;
        }
        while (this.columnModel.getColumnCount() > 0) {
            this.columnModel.removeColumn(this.columnModel.getColumn(0));
        }
    }

    private void initialTableColumnSize(TableColumn column, TableModel tableModel, int columnIndex) {
        TableModel wrappedModel = RowObjectTableModel.unwrap(tableModel);
        if (!(wrappedModel instanceof AbstractGTableModel)) {
            return;
        }
        AbstractGTableModel gTableModel = (AbstractGTableModel)wrappedModel;
        int width = gTableModel.getPreferredColumnWidth(columnIndex);
        if (width != -1) {
            column.setPreferredWidth(width);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String str = super.getToolTipText(e);
        if (str != null) {
            return str;
        }
        int row = this.rowAtPoint(e.getPoint());
        int col = this.columnAtPoint(e.getPoint());
        if (row < 0 || col < 0 || row >= this.getRowCount() || col >= this.getColumnCount()) {
            return null;
        }
        Object value = this.getValueAt(row, col);
        if (value != null) {
            Component component = this.getCellRenderer(row, col).getTableCellRendererComponent(this, value, false, false, row, col);
            int prefWidth = component.getPreferredSize().width;
            int cellWidth = this.getCellRect((int)row, (int)col, (boolean)false).width;
            if (prefWidth > cellWidth) {
                String string = value.toString();
                if (component instanceof JLabel) {
                    string = ((JLabel)component).getText();
                }
                if (string == null) {
                    return null;
                }
                if (this.htmlRenderingEnabled) {
                    return HTMLUtilities.toHTML((String)string);
                }
                String html = HTMLUtilities.toLiteralHTMLForTooltip((String)string);
                return html;
            }
        }
        return null;
    }

    public void setHTMLRenderingEnabled(boolean enable) {
        this.htmlRenderingEnabled = enable;
        for (TableCellRenderer renderer : this.defaultGTableRendererList) {
            if (!(renderer instanceof GTableCellRenderer)) continue;
            GTableCellRenderer gRenderer = (GTableCellRenderer)renderer;
            gRenderer.setHTMLRenderingEnabled(enable);
        }
    }

    public void setPreferenceKey(String preferenceKey) {
        this.preferenceKey = preferenceKey;
        if (!(this.columnModel instanceof GTableColumnModel)) {
            throw new AssertException("Setting preference key has no effect if not using a GTableColumnModel");
        }
        ((GTableColumnModel)this.columnModel).restoreState();
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void savePreferences() {
        if (!(this.columnModel instanceof GTableColumnModel)) {
            throw new AssertException("Saving preferences has no effect if not using a GTableColumnModel");
        }
        ((GTableColumnModel)this.columnModel).saveState();
    }

    public void setUserSortingEnabled(boolean enabled) {
        this.headerMouseListener.setSortingEnabled(enabled);
    }

    public void setColumnHeaderPopupEnabled(boolean enabled) {
        this.columnHeaderPopupEnabled = enabled;
    }

    public boolean isColumnHeaderPopupEnabled() {
        return this.columnHeaderPopupEnabled;
    }

    public JPopupMenu getTableColumnPopupMenu(int columnIndex) {
        if (!this.columnHeaderPopupEnabled) {
            return null;
        }
        if (this.columnModel instanceof GTableColumnModel) {
            return this.getHeaderPopupMenu(columnIndex);
        }
        return null;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        return this.getCellRendererOverride(row, col);
    }

    public final TableCellRenderer getCellRendererOverride(int row, int col) {
        int modelIndex;
        TableCellRenderer renderer;
        ConfigurableColumnTableModel configurableModel = this.getConfigurableColumnTableModel();
        if (configurableModel != null && (renderer = configurableModel.getRenderer(modelIndex = this.convertColumnIndexToModel(col))) != null) {
            return renderer;
        }
        return super.getCellRenderer(row, col);
    }

    @Override
    public boolean editCellAt(int row, int column) {
        boolean editAtCell = super.editCellAt(row, column);
        if (editAtCell) {
            Component editor = this.getEditorComponent();
            editor.requestFocus();
        }
        return editAtCell;
    }

    public void scrollToSelectedRow() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        int row = selectedRows[0];
        Rectangle visibleRect = this.getVisibleRect();
        Rectangle cellRect = this.getCellRect(row, 0, true);
        cellRect.x = visibleRect.x;
        cellRect.width = visibleRect.width;
        this.scrollRectToVisible(cellRect);
    }

    private JPopupMenu getHeaderPopupMenu(int columnIndex) {
        if (this.tableHeaderPopupMenu == null) {
            this.tableHeaderPopupMenu = this.buildTableHeaderPopupMenu();
        }
        JMenuItem item = (JMenuItem)this.tableHeaderPopupMenu.getComponent(1);
        boolean enableSettingsAction = false;
        ConfigurableColumnTableModel configurableModel = this.getConfigurableColumnTableModel();
        if (configurableModel != null) {
            this.lastPopupColumnIndex = this.convertColumnIndexToModel(columnIndex);
            SettingsDefinition[] settingsDefs = configurableModel.getColumnSettingsDefinitions(this.lastPopupColumnIndex);
            enableSettingsAction = settingsDefs.length != 0;
        }
        item.setEnabled(enableSettingsAction);
        return this.tableHeaderPopupMenu;
    }

    private JPopupMenu buildTableHeaderPopupMenu() {
        HelpLocation helpLocation = new HelpLocation("Tables", "GhidraTableHeaders");
        final JPopupMenu newPopupMenu = new JPopupMenu();
        newPopupMenu.add(this.createAddRemoveColumnsMenuItem(helpLocation));
        newPopupMenu.add(this.createColumnSettingsMenuItem(helpLocation));
        newPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                DockingWindowManager.setMouseOverObject(newPopupMenu);
            }
        });
        DockingWindowManager.getHelpService().registerHelp(newPopupMenu, helpLocation);
        return newPopupMenu;
    }

    private JMenuItem createAddRemoveColumnsMenuItem(HelpLocation helpLocation) {
        JMenuItem item = new JMenuItem("Add/Remove Columns...");
        TableModel model = this.getModel();
        item.addActionListener(e -> {
            SelectColumnsDialog dialog = new SelectColumnsDialog((GTableColumnModel)this.columnModel, model);
            DockingWindowManager.showDialog(this, dialog);
        });
        DockingWindowManager.getHelpService().registerHelp(item, helpLocation);
        return item;
    }

    private JMenuItem createColumnSettingsMenuItem(HelpLocation helpLocation) {
        JMenuItem item = new JMenuItem("Column Settings...");
        item.addActionListener(e -> {
            ConfigurableColumnTableModel configurableModel = this.getConfigurableColumnTableModel();
            if (configurableModel == null) {
                return;
            }
            SettingsDefinition[] settings = configurableModel.getColumnSettingsDefinitions(this.lastPopupColumnIndex);
            if (settings.length == 0) {
                return;
            }
            SettingsDialog dialog = new SettingsDialog(null);
            dialog.show(this, configurableModel.getColumnName(this.lastPopupColumnIndex) + " Settings", settings, configurableModel.getColumnSettings(this.lastPopupColumnIndex));
            ((GTableColumnModel)this.getColumnModel()).saveState();
        });
        DockingWindowManager.getHelpService().registerHelp(item, helpLocation);
        return item;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object value = super.getValueAt(row, column);
        if (!this.copying) {
            return value;
        }
        Object updated = this.maybeConvertValue(value);
        return updated;
    }

    private Object maybeConvertValue(Object value) {
        if (value == null) {
            return null;
        }
        String asString = value.toString();
        String converted = HTMLUtilities.fromHTML((String)asString);
        return converted;
    }

    GTableCellRenderingData getRenderingData(int viewColumn) {
        int modelColumn = this.convertColumnIndexToModel(viewColumn);
        GTableCellRenderingData renderData = this.columnRenderingDataMap.get(modelColumn);
        if (renderData == null) {
            Settings settings = SettingsImpl.NO_SETTINGS;
            ConfigurableColumnTableModel configurableModel = this.getConfigurableColumnTableModel();
            if (configurableModel != null) {
                settings = configurableModel.getColumnSettings(modelColumn);
            }
            renderData = new GTableCellRenderingData(this, viewColumn, settings);
            this.columnRenderingDataMap.put(modelColumn, renderData);
        }
        renderData.resetRowData();
        return renderData;
    }

    protected boolean supportsPopupActions() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyColumns(int ... copyColumns) {
        int[] originalColumns = new int[]{};
        boolean wasAllowed = this.getColumnSelectionAllowed();
        if (wasAllowed) {
            originalColumns = this.getSelectedColumns();
        }
        this.setColumnSelectionAllowed(true);
        this.setSelectedColumns(copyColumns);
        this.copying = true;
        try {
            Action builtinCopyAction = TransferHandler.getCopyAction();
            builtinCopyAction.actionPerformed(new ActionEvent(this, 0, "copy"));
        }
        finally {
            this.copying = false;
            this.setSelectedColumns(originalColumns);
            this.setColumnSelectionAllowed(wasAllowed);
        }
    }

    private void setSelectedColumns(int[] columns) {
        this.columnModel.getSelectionModel().clearSelection();
        for (int column : columns) {
            this.addColumnSelectionInterval(column, column);
        }
    }

    private int[] promptUserForColumns() {
        ChooseColumnsDialog dialog = new ChooseColumnsDialog((GTableColumnModel)this.columnModel, this.getModel());
        DockingWindowManager.showDialog(this, dialog);
        return dialog.getChosenColumns();
    }

    private GhidraFileChooser createExportFileChooser() {
        GhidraFileChooser chooser = new GhidraFileChooser(this);
        chooser.setTitle("Export to CSV");
        chooser.setApproveButtonText("OK");
        String filepath = Preferences.getProperty((String)LAST_EXPORT_FILE);
        if (filepath != null) {
            chooser.setSelectedFile(new File(filepath));
        }
        return chooser;
    }

    private File chooseExportFile() {
        int result;
        GhidraFileChooser chooser = this.createExportFileChooser();
        File file = chooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        if (file.exists() && (result = OptionDialog.showYesNoDialog(this, "Overwrite?", "File exists. Do you want to overwrite?")) != 1) {
            return null;
        }
        this.storeLastExportDirectory(file);
        return file;
    }

    private void storeLastExportDirectory(File file) {
        Preferences.setProperty((String)LAST_EXPORT_FILE, (String)file.getAbsolutePath());
        Preferences.store();
    }

    private void doCopy() {
        this.copying = true;
        Action builtinCopyAction = TransferHandler.getCopyAction();
        try {
            builtinCopyAction.actionPerformed(new ActionEvent(this, 0, "copy"));
        }
        finally {
            this.copying = false;
        }
    }

    private void doCopyCurrentColumn(MouseEvent event) {
        int column = this.getSelectedColumn();
        if (event != null) {
            column = this.columnAtPoint(event.getPoint());
        }
        if (column < 0) {
            Msg.debug((Object)this, (Object)"Copy failed--no column selected");
            return;
        }
        this.copyColumns(column);
    }

    private void doCopyColumns() {
        int[] userColumns = this.promptUserForColumns();
        if (userColumns == null) {
            return;
        }
        this.copyColumns(userColumns);
    }

    private void doExport() {
        File file = this.chooseExportFile();
        if (file != null) {
            GTableToCSV.writeCSV(file, this);
        }
    }

    private void doExportColumns() {
        int[] userColumns = this.promptUserForColumns();
        if (userColumns == null) {
            return;
        }
        File file = this.chooseExportFile();
        if (file == null) {
            return;
        }
        ArrayList<Integer> columnList = new ArrayList<Integer>();
        for (int userColumn : userColumns) {
            columnList.add(userColumn);
        }
        GTableToCSV.writeCSVUsingColunns(file, this, columnList);
    }

    public static void createSharedActions(DockingTool tool, ToolActions toolActions, String owner) {
        String actionMenuGroup = "zzzTableGroup";
        tool.setMenuGroup(new String[]{"Copy"}, actionMenuGroup, "1");
        tool.setMenuGroup(new String[]{"Export"}, actionMenuGroup, "2");
        tool.setMenuGroup(new String[]{"Select All"}, actionMenuGroup, "3");
        int subGroupIndex = 1;
        GTableAction copyAction = new GTableAction("Table Data Copy", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTable gTable = (GTable)context.getSourceComponent();
                gTable.doCopy();
            }
        };
        copyAction.setPopupMenuData(new MenuData(new String[]{"Copy", "Copy"}, ResourceManager.loadImage((String)"images/page_white_copy.png"), actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        copyAction.setKeyBindingData(new KeyBindingData(COPY_KEY_STROKE));
        copyAction.setHelpLocation(new HelpLocation("Tables", "Copy"));
        GTableAction copyCurrentColumnAction = new GTableAction("Table Data Copy Current Column", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTable gTable = (GTable)context.getSourceComponent();
                gTable.doCopyCurrentColumn(context.getMouseEvent());
            }
        };
        copyCurrentColumnAction.setPopupMenuData(new MenuData(new String[]{"Copy", "Copy Current Column"}, ResourceManager.loadImage((String)"images/page_white_copy.png"), actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        copyCurrentColumnAction.setKeyBindingData(new KeyBindingData(COPY_COLUMN_KEY_STROKE));
        copyCurrentColumnAction.setHelpLocation(new HelpLocation("Tables", "Copy_Current_Column"));
        GTableAction copyColumnsAction = new GTableAction("Table Data Copy by Columns", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTable gTable = (GTable)context.getSourceComponent();
                gTable.doCopyColumns();
            }
        };
        copyColumnsAction.setPopupMenuData(new MenuData(new String[]{"Copy", "Copy Columns..."}, ResourceManager.loadImage((String)"images/page_white_copy.png"), actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        copyColumnsAction.setHelpLocation(new HelpLocation("Tables", "Copy_Columns"));
        GTableAction exportAction = new GTableAction("Table Data CSV Export", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTable gTable = (GTable)context.getSourceComponent();
                gTable.doExport();
            }
        };
        exportAction.setPopupMenuData(new MenuData(new String[]{"Export", "Export to CSV..."}, ResourceManager.loadImage((String)"images/application-vnd.oasis.opendocument.spreadsheet-template.png"), actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        exportAction.setHelpLocation(new HelpLocation("Tables", "ExportCSV"));
        GTableAction exportColumnsAction = new GTableAction("Table Data CSV Export (by Columns)", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTable gTable = (GTable)context.getSourceComponent();
                gTable.doExportColumns();
            }
        };
        exportColumnsAction.setPopupMenuData(new MenuData(new String[]{"Export", "Export Columns to CSV..."}, ResourceManager.loadImage((String)"images/application-vnd.oasis.opendocument.spreadsheet-template.png"), actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        exportColumnsAction.setHelpLocation(new HelpLocation("Tables", "ExportCSV_Columns"));
        GTableAction selectAllAction = new GTableAction("Table Select All", owner){

            @Override
            public void actionPerformed(ActionContext context) {
                GTable gTable = (GTable)context.getSourceComponent();
                gTable.selectAll();
            }

            @Override
            public boolean isEnabledForContext(ActionContext context) {
                if (!super.isEnabledForContext(context)) {
                    return false;
                }
                GTable gTable = (GTable)context.getSourceComponent();
                int mode = gTable.getSelectionModel().getSelectionMode();
                return mode != 0;
            }
        };
        selectAllAction.setPopupMenuData(new MenuData(new String[]{"Select All"}, null, actionMenuGroup, -1, Integer.toString(subGroupIndex++)));
        selectAllAction.setKeyBindingData(new KeyBindingData(SELECT_ALL_KEY_STROKE));
        selectAllAction.setHelpLocation(new HelpLocation("Tables", "SelectAll"));
        toolActions.addGlobalAction(copyAction);
        toolActions.addGlobalAction(copyColumnsAction);
        toolActions.addGlobalAction(copyCurrentColumnAction);
        toolActions.addGlobalAction(exportAction);
        toolActions.addGlobalAction(exportColumnsAction);
        toolActions.addGlobalAction(selectAllAction);
    }

    private static abstract class GTableAction
    extends DockingAction
    implements ComponentBasedDockingAction {
        GTableAction(String name, String owner) {
            super(name, owner);
        }

        @Override
        public boolean isAddToPopup(ActionContext context) {
            if (!this.isEnabledForContext(context)) {
                return false;
            }
            GTable gTable = (GTable)context.getSourceComponent();
            return gTable.supportsPopupActions();
        }

        @Override
        public boolean isEnabledForContext(ActionContext context) {
            Component sourceComponent = context.getSourceComponent();
            return sourceComponent instanceof GTable;
        }

        @Override
        public boolean isValidComponentContext(ActionContext context) {
            Component sourceComponent = context.getSourceComponent();
            return sourceComponent instanceof GTable;
        }
    }

    private class MyTableColumnModelListener
    implements TableColumnModelListener {
        private MyTableColumnModelListener() {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            if (GTable.this.columnRenderingDataMap != null) {
                GTable.this.columnRenderingDataMap.clear();
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }
    }
}

