/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.autocomplete;

import docking.widgets.autocomplete.TextFieldAutocompleter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class AutocompletionCellRenderer<T>
implements ListCellRenderer<T> {
    private final TextFieldAutocompleter<T> owner;
    protected ListCellRenderer<Object> defaultRenderer = new DefaultListCellRenderer();

    public AutocompletionCellRenderer(TextFieldAutocompleter<T> owner) {
        this.owner = owner;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bg;
        Color fg;
        Icon icon;
        Font font;
        JLabel label = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        label.setText(this.owner.getCompletionDisplay(value));
        if (label.getText().equals("")) {
            label.setText(" ");
        }
        if ((font = this.owner.getCompletionFont(value, isSelected, cellHasFocus)) != null) {
            label.setFont(font);
        }
        if ((icon = this.owner.getCompletionIcon(value, isSelected, cellHasFocus)) != null) {
            label.setIcon(icon);
        }
        if ((fg = this.owner.getCompletionForeground(value, isSelected, cellHasFocus)) != null) {
            label.setForeground(fg);
        }
        if ((bg = this.owner.getCompletionBackground(value, isSelected, cellHasFocus)) != null) {
            label.setBackground(bg);
        }
        return label;
    }
}

