/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.DockingUtils;
import docking.action.DockingAction;
import ghidra.util.SystemUtilities;
import javax.swing.Icon;

public class ToolBarData {
    private static final String NO_SUBGROUP = Character.toString('\uffff');
    private Icon icon;
    private String toolBarGroup;
    private String toolBarSubGroup;
    private DockingAction ownerAction;

    ToolBarData(DockingAction ownerAction, Icon icon, String toolBarGroup, String toolBarSubGroup) {
        this.icon = DockingUtils.scaleIconAsNeeded(icon);
        this.toolBarGroup = toolBarGroup;
        this.ownerAction = ownerAction;
        this.toolBarSubGroup = toolBarSubGroup == null ? NO_SUBGROUP : toolBarSubGroup;
    }

    public ToolBarData(Icon icon) {
        this(null, icon, null, NO_SUBGROUP);
    }

    public ToolBarData(Icon icon, String toolBarGroup) {
        this(null, icon, toolBarGroup, NO_SUBGROUP);
    }

    public ToolBarData(Icon icon, String toolBarGroup, String toolBarSubGroup) {
        this(null, icon, toolBarGroup, toolBarSubGroup);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getToolBarGroup() {
        return this.toolBarGroup;
    }

    public String getToolBarSubGroup() {
        return this.toolBarSubGroup;
    }

    public void setIcon(Icon newIcon) {
        if (this.icon == newIcon) {
            return;
        }
        ToolBarData oldData = new ToolBarData(this.icon, this.toolBarGroup, this.toolBarSubGroup);
        this.icon = DockingUtils.scaleIconAsNeeded(newIcon);
        this.firePropertyChanged(oldData);
    }

    public void setToolBarGroup(String newGroup) {
        if (SystemUtilities.isEqual((Object)this.toolBarGroup, (Object)newGroup)) {
            return;
        }
        ToolBarData oldData = new ToolBarData(this.icon, this.toolBarGroup, this.toolBarSubGroup);
        this.toolBarGroup = newGroup;
        this.firePropertyChanged(oldData);
    }

    public void setToolBarSubGroup(String newSubGroup) {
        if (SystemUtilities.isEqual((Object)this.toolBarSubGroup, (Object)newSubGroup)) {
            return;
        }
        ToolBarData oldData = new ToolBarData(this.icon, this.toolBarGroup, this.toolBarSubGroup);
        this.toolBarSubGroup = newSubGroup == null ? NO_SUBGROUP : newSubGroup;
        this.firePropertyChanged(oldData);
    }

    private void firePropertyChanged(ToolBarData oldData) {
        if (this.ownerAction != null) {
            this.ownerAction.firePropertyChanged("ToolBar", oldData, this);
        }
    }
}

