/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class TerminatedSettingsDefinition
implements EnumSettingsDefinition {
    private static final int UNTERMINATED_VALUE = 0;
    private static final int TERMINATED_VALUE = 1;
    private static final String[] choices = new String[]{"unterminated", "terminated"};
    private static final String TERMINATED = "terminated";
    public static final TerminatedSettingsDefinition DEF = new TerminatedSettingsDefinition();

    private TerminatedSettingsDefinition() {
    }

    public boolean isTerminated(Settings settings) {
        if (settings == null) {
            return false;
        }
        Long value = settings.getLong(TERMINATED);
        if (value == null) {
            return false;
        }
        return value == 1L;
    }

    public void setTerminated(Settings settings, boolean isTerminated) {
        this.setChoice(settings, isTerminated ? 1 : 0);
    }

    public int getChoice(Settings settings) {
        if (this.isTerminated(settings)) {
            return 1;
        }
        return 0;
    }

    public void setChoice(Settings settings, int value) {
        settings.setLong(TERMINATED, (long)value);
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return "Termination";
    }

    public String getDescription() {
        return "Selects if the string is terminated or unterminated";
    }

    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(TERMINATED);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(TERMINATED);
        if (l == null) {
            destSettings.clearSetting(TERMINATED);
        } else {
            destSettings.setLong(TERMINATED, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(TERMINATED) != null;
    }
}

