/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.ConvertedRecordIterator;
import db.DBHandle;
import db.DBLongIterator;
import db.Field;
import db.KeyToRecordIterator;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressRecordDeleter;
import ghidra.program.database.symbol.SymbolDatabaseAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;

class SymbolDatabaseAdapterV1
extends SymbolDatabaseAdapter {
    private static final int SYMBOL_VERSION = 1;
    private static final int V1_SYMBOL_NAME_COL = 0;
    private static final int V1_SYMBOL_ADDR_COL = 1;
    private static final int V1_SYMBOL_PARENT_COL = 2;
    private static final int V1_SYMBOL_TYPE_COL = 3;
    private static final int V1_SYMBOL_DATA1_COL = 4;
    private static final int V1_SYMBOL_DATA2_COL = 5;
    private static final int V1_SYMBOL_COMMENT_COL = 6;
    private Table symbolTable;
    private AddressMap addrMap;

    SymbolDatabaseAdapterV1(DBHandle handle, AddressMap addrMap) throws VersionException {
        this.addrMap = addrMap;
        this.symbolTable = handle.getTable("Symbols");
        if (this.symbolTable == null) {
            throw new VersionException("Missing Table: Symbols");
        }
        if (this.symbolTable.getSchema().getVersion() != 1) {
            int version = this.symbolTable.getSchema().getVersion();
            if (version < 1) {
                throw new VersionException(true);
            }
            throw new VersionException(2, false);
        }
    }

    @Override
    Record createSymbol(String name, Address address, long namespaceID, SymbolType symbolType, long data1, int data2, String data3, SourceType source) {
        throw new UnsupportedOperationException();
    }

    @Override
    void removeSymbol(long symbolID) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean hasSymbol(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L) {
            return false;
        }
        return this.symbolTable.hasRecord((Field)new LongField(key), 1);
    }

    @Override
    long[] getSymbolIDs(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L) {
            return new long[0];
        }
        return this.symbolTable.findRecords((Field)new LongField(key), 1);
    }

    @Override
    Record getSymbolRecord(long symbolID) throws IOException {
        return this.convertV1Record(this.symbolTable.getRecord(symbolID));
    }

    private Record convertV1Record(Record record) {
        Address symbolAddress;
        String defaultName;
        if (record == null) {
            return null;
        }
        Record rec = SymbolDatabaseAdapter.SYMBOL_SCHEMA.createRecord(record.getKey());
        String symbolName = record.getString(0);
        rec.setString(0, symbolName);
        long symbolAddrKey = record.getLongValue(1);
        rec.setLongValue(1, symbolAddrKey);
        rec.setLongValue(2, record.getLongValue(2));
        byte symbolType = record.getByteValue(3);
        rec.setByteValue(3, symbolType);
        rec.setLongValue(4, record.getLongValue(4));
        rec.setIntValue(5, record.getIntValue(5));
        rec.setString(6, record.getString(6));
        SourceType source = SourceType.USER_DEFINED;
        if (symbolType == SymbolType.FUNCTION.getID() && symbolName.equals(defaultName = SymbolUtilities.getDefaultFunctionName(symbolAddress = this.addrMap.decodeAddress(symbolAddrKey)))) {
            source = SourceType.DEFAULT;
        }
        rec.setByteValue(7, (byte)source.ordinal());
        return rec;
    }

    @Override
    int getSymbolCount() {
        return this.symbolTable.getRecordCount();
    }

    @Override
    RecordIterator getSymbolsByAddress(boolean forward) throws IOException {
        return new V1ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBLongIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, forward)));
    }

    @Override
    RecordIterator getSymbolsByAddress(Address startAddr, boolean forward) throws IOException {
        return new V1ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBLongIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, startAddr, forward)));
    }

    @Override
    void updateSymbolRecord(Record record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getSymbols() throws IOException {
        return new V1ConvertedRecordIterator(this.symbolTable.iterator());
    }

    @Override
    RecordIterator getSymbols(Address start, Address end, boolean forward) throws IOException {
        return new V1ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBLongIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, start, end, forward)));
    }

    RecordIterator getSymbolsByName() throws IOException {
        return new V1ConvertedRecordIterator(this.symbolTable.indexIterator(0));
    }

    void deleteExternalEntries(Address start, Address end) throws IOException {
        AddressRecordDeleter.deleteRecords(this.symbolTable, 1, this.addrMap, start, end, null);
    }

    @Override
    void moveAddress(Address oldAddr, Address newAddr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Set<Address> deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getSymbolsByNamespace(long id) throws IOException {
        LongField field = new LongField(id);
        return new V1ConvertedRecordIterator(this.symbolTable.indexIterator(2, (Field)field, (Field)field, true));
    }

    @Override
    RecordIterator getSymbolsByName(String name) throws IOException {
        StringField field = new StringField(name);
        return new V1ConvertedRecordIterator(this.symbolTable.indexIterator(0, (Field)field, (Field)field, true));
    }

    @Override
    Table getTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    Address getMaxSymbolAddress(AddressSpace space) throws IOException {
        throw new UnsupportedOperationException();
    }

    private class V1ConvertedRecordIterator
    extends ConvertedRecordIterator {
        V1ConvertedRecordIterator(RecordIterator originalIterator) {
            super(originalIterator, false);
        }

        protected Record convertRecord(Record record) {
            return SymbolDatabaseAdapterV1.this.convertV1Record(record);
        }
    }
}

