/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import ghidra.program.database.function.FunctionDB;
import ghidra.program.database.function.ParameterDB;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableSizeException;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class ReturnParameterDB
extends ParameterDB {
    private DataType dataType;

    ReturnParameterDB(FunctionDB function, DataType dt, VariableStorage storage) {
        super(function, null);
        this.dataType = dt;
        this.storage = storage;
    }

    @Override
    public String getName() {
        return "<RETURN>";
    }

    @Override
    public void setName(String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public void setComment(String comment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getOrdinal() {
        return -1;
    }

    @Override
    final void setOrdinal(int ordinal) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataType(DataType type, VariableStorage newStorage, boolean force, SourceType source) throws InvalidInputException, VariableSizeException {
        this.functionMgr.lock.acquire();
        try {
            this.function.checkDeleted();
            boolean hasCustomStorage = this.function.hasCustomVariableStorage();
            if (!hasCustomStorage) {
                newStorage = VariableStorage.UNASSIGNED_STORAGE;
            }
            Program program = this.function.getProgram();
            type = VariableUtilities.checkDataType(type, newStorage.isVoidStorage() || newStorage.isUnassignedStorage(), this.getLength(), program);
            if (!newStorage.isUnassignedStorage()) {
                newStorage = VariableUtilities.checkStorage(this.function, newStorage, type, force);
            }
            this.function.setReturnStorageAndDataType(newStorage, type);
            this.dataType = program.getDataTypeManager().resolve(type, null);
            if (hasCustomStorage) {
                this.storage = newStorage;
            } else {
                this.storage = VariableStorage.UNASSIGNED_STORAGE;
                this.function.updateParametersAndReturn();
            }
            this.function.updateSignatureSourceAfterVariableChange(source, type);
            this.functionMgr.functionChanged(this.function, 5);
        }
        catch (IOException e) {
            this.functionMgr.dbError(e);
        }
        finally {
            this.functionMgr.lock.release();
        }
    }

    @Override
    public void setDataType(DataType type, SourceType source) throws InvalidInputException {
        this.setDataType(type, true, false, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataType(DataType type, boolean alignStack, boolean force, SourceType source) throws InvalidInputException {
        this.functionMgr.lock.acquire();
        try {
            this.function.checkDeleted();
            Program program = this.function.getProgram();
            type = VariableUtilities.checkDataType(type, true, 0, program);
            VariableStorage newStorage = VariableStorage.UNASSIGNED_STORAGE;
            boolean hasCustomVariableStorage = this.function.hasCustomVariableStorage();
            if (hasCustomVariableStorage) {
                DataType baseType = type;
                if (baseType instanceof TypeDef) {
                    baseType = ((TypeDef)baseType).getBaseDataType();
                }
                try {
                    newStorage = baseType instanceof VoidDataType ? VariableStorage.VOID_STORAGE : VariableUtilities.resizeStorage(this.getVariableStorage(), type, alignStack, this.function);
                    VariableUtilities.checkStorage(newStorage, type, force);
                }
                catch (InvalidInputException e) {
                    if (!force) {
                        throw e;
                    }
                    newStorage = VariableStorage.UNASSIGNED_STORAGE;
                }
                this.storage = newStorage;
            } else {
                this.storage = VariableStorage.UNASSIGNED_STORAGE;
            }
            this.function.setReturnStorageAndDataType(newStorage, type);
            this.dataType = program.getDataTypeManager().resolve(type, null);
            if (!hasCustomVariableStorage) {
                this.function.updateParametersAndReturn();
            }
            this.function.updateSignatureSourceAfterVariableChange(source, type);
            this.functionMgr.functionChanged(this.function, 5);
        }
        catch (IOException e) {
            this.functionMgr.dbError(e);
        }
        finally {
            this.functionMgr.lock.release();
        }
    }

    @Override
    public DataType getFormalDataType() {
        return this.dataType;
    }

    @Override
    public SourceType getSource() {
        return this.function.getSymbol().getSource();
    }

    @Override
    public boolean hasAssignedStorage() {
        return this.function.hasCustomVariableStorage() && !this.storage.isUnassignedStorage();
    }

    @Override
    public VariableStorage getVariableStorage() {
        return this.storage;
    }

    @Override
    void setStorageAndDataType(VariableStorage newStorage, DataType dt) {
        if (!this.function.hasCustomVariableStorage()) {
            newStorage = VariableStorage.UNASSIGNED_STORAGE;
        }
        try {
            this.function.setReturnStorageAndDataType(newStorage, dt);
            this.storage = newStorage;
            this.dataType = dt;
        }
        catch (IOException e) {
            this.function.getFunctionManager().dbError(e);
        }
    }
}

