/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.function.FunctionAdapter;
import ghidra.program.database.map.AddressMap;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class FunctionAdapterV2
extends FunctionAdapter {
    private static final int V2_RETURN_DATA_TYPE_ID_COL = 0;
    private static final int V2_STACK_PURGE_COL = 1;
    private static final int V2_STACK_PARAM_OFFSET_COL = 2;
    private static final int V2_STACK_RETURN_OFFSET_COL = 3;
    private static final int V2_STACK_LOCAL_SIZE_COL = 4;
    private static final int V2_FUNCTION_FLAGS_COL = 5;
    private static final int V2_CALLING_CONVENTION_ID_COL = 6;
    static final int SCHEMA_VERSION = 2;
    private Table table;

    FunctionAdapterV2(DBHandle dbHandle, AddressMap addrMap) throws VersionException {
        super(addrMap);
        this.table = dbHandle.getTable("Function Data");
        if (this.table == null) {
            throw new VersionException("Missing Table: Function Data");
        }
        int version = this.table.getSchema().getVersion();
        if (version != 2) {
            if (version < 2) {
                throw new VersionException(true);
            }
            throw new VersionException(2, false);
        }
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Function Data");
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }

    @Override
    void removeFunctionRecord(long functionKey) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Record getFunctionRecord(long functionKey) throws IOException {
        Record oldRecord = this.table.getRecord(functionKey);
        return this.translateRecord(oldRecord);
    }

    @Override
    void updateFunctionRecord(Record functionRecord) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Record createFunctionRecord(long symbolID, long returnDataTypeId) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator iterateFunctionRecords() throws IOException {
        return new FunctionAdapter.TranslatedRecordIterator(this.table.iterator());
    }

    @Override
    Record translateRecord(Record record) {
        if (record == null) {
            return null;
        }
        long entryPointKey = record.getKey();
        Record newRecord = FunctionAdapter.FUNCTION_SCHEMA.createRecord(entryPointKey);
        newRecord.setLongValue(0, record.getLongValue(0));
        newRecord.setIntValue(1, record.getIntValue(1));
        newRecord.setIntValue(2, record.getIntValue(3));
        newRecord.setIntValue(3, record.getIntValue(4));
        newRecord.setByteValue(4, (byte)(record.getByteValue(5) | 8));
        newRecord.setByteValue(5, record.getByteValue(6));
        newRecord.setString(6, null);
        return newRecord;
    }

    @Override
    int getVersion() {
        return 2;
    }
}

