/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.program.database.code.CommentsDBAdapterV0;
import ghidra.program.database.code.CommentsDBAdapterV1;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class CommentsDBAdapter {
    static final String COMMENTS_TABLE_NAME = "Comments";
    static final Schema COMMENTS_SCHEMA;
    static final int PRE_COMMENT_COL = 1;
    static final int POST_COMMENT_COL = 2;
    static final int EOL_COMMENT_COL = 0;
    static final int PLATE_COMMENT_COL = 3;
    static final int REPEATABLE_COMMENT_COL = 4;
    static final int COMMENT_COL_COUNT = 5;
    static final String[] NAMES;

    CommentsDBAdapter() {
    }

    static CommentsDBAdapter getAdapter(DBHandle dbHandle, int openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == 0) {
            return new CommentsDBAdapterV1(dbHandle, addrMap, true);
        }
        try {
            CommentsDBAdapterV1 adapter = new CommentsDBAdapterV1(dbHandle, addrMap, false);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            CommentsDBAdapter adapter = CommentsDBAdapter.findReadOnlyAdapter(dbHandle, addrMap);
            if (openMode == 3) {
                adapter = CommentsDBAdapter.upgrade(dbHandle, addrMap, adapter, monitor);
            }
            return adapter;
        }
    }

    private static CommentsDBAdapter findReadOnlyAdapter(DBHandle handle, AddressMap addrMap) throws VersionException, IOException {
        try {
            return new CommentsDBAdapterV1(handle, addrMap.getOldAddressMap(), false);
        }
        catch (VersionException versionException) {
            return new CommentsDBAdapterV0(handle, addrMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommentsDBAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, CommentsDBAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            monitor.setMessage("Upgrading Comments...");
            monitor.initialize((long)(oldAdapter.getRecordCount() * 2));
            int count = 0;
            CommentsDBAdapterV1 tmpAdapter = new CommentsDBAdapterV1(tmpHandle, addrMap, true);
            RecordIterator iter = oldAdapter.getRecords();
            while (iter.hasNext()) {
                monitor.checkCanceled();
                Record rec = iter.next();
                Address addr = oldAddrMap.decodeAddress(rec.getKey());
                rec.setKey(addrMap.getKey(addr, true));
                ((CommentsDBAdapter)tmpAdapter).updateRecord(rec);
                monitor.setProgress((long)(++count));
            }
            dbHandle.deleteTable(COMMENTS_TABLE_NAME);
            CommentsDBAdapterV1 newAdapter = new CommentsDBAdapterV1(dbHandle, addrMap, true);
            iter = ((CommentsDBAdapter)tmpAdapter).getRecords();
            while (iter.hasNext()) {
                monitor.checkCanceled();
                Record rec = iter.next();
                ((CommentsDBAdapter)newAdapter).updateRecord(rec);
                monitor.setProgress((long)(++count));
            }
            CommentsDBAdapterV1 commentsDBAdapterV1 = newAdapter;
            return commentsDBAdapterV1;
        }
    }

    abstract int getRecordCount() throws IOException;

    abstract Record getRecord(long var1) throws IOException;

    abstract Record createRecord(long var1, int var3, String var4) throws IOException;

    abstract boolean deleteRecord(long var1) throws IOException;

    abstract boolean deleteRecords(Address var1, Address var2) throws IOException;

    abstract void updateRecord(Record var1) throws IOException;

    abstract RecordIterator getRecords(Address var1, Address var2, boolean var3) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract AddressKeyIterator getKeys(Address var1, Address var2, boolean var3) throws IOException;

    abstract void putRecord(Record var1) throws IOException;

    abstract RecordIterator getRecords(Address var1) throws IOException;

    abstract AddressKeyIterator getKeys(AddressSetView var1, boolean var2) throws IOException;

    abstract void moveAddressRange(Address var1, Address var2, long var3, TaskMonitor var5) throws CancelledException, IOException;

    static {
        NAMES = new String[5];
        CommentsDBAdapter.NAMES[1] = "Pre";
        CommentsDBAdapter.NAMES[2] = "Post";
        CommentsDBAdapter.NAMES[0] = "EOL";
        CommentsDBAdapter.NAMES[3] = "Plate";
        CommentsDBAdapter.NAMES[4] = "Repeatable";
        COMMENTS_SCHEMA = new Schema(1, "Address", new Class[]{StringField.class, StringField.class, StringField.class, StringField.class, StringField.class}, NAMES);
    }
}

