/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.wizard.WizardState;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.EventQueue;
import java.io.IOException;

public class CreateNewSessionTask
extends Task {
    private final WizardState<VTWizardStateKey> state;
    private final VTController controller;

    public CreateNewSessionTask(VTController controller, WizardState<VTWizardStateKey> state) {
        super("Create New Version Tracking Session", true, true, true);
        this.controller = controller;
        this.state = state;
    }

    public void run(TaskMonitor monitor) {
        VTSessionDB session = null;
        String name = null;
        try {
            Program sourceProgram = (Program)this.state.get((Object)VTWizardStateKey.SOURCE_PROGRAM);
            Program destinationProgram = (Program)this.state.get((Object)VTWizardStateKey.DESTINATION_PROGRAM);
            session = VTSessionDB.createVTSession("New Session", sourceProgram, destinationProgram, (Object)this);
            DomainObjectAdapterDB dobj = null;
            if (session instanceof DomainObjectAdapterDB) {
                dobj = session;
            }
            sourceProgram.release((Object)this.controller.getTool());
            destinationProgram.release((Object)this.controller.getTool());
            if (dobj != null) {
                name = (String)this.state.get((Object)VTWizardStateKey.SESSION_NAME);
                DomainFolder folder = (DomainFolder)this.state.get((Object)VTWizardStateKey.NEW_SESSION_FOLDER);
                try {
                    folder.createFile(name, (DomainObject)dobj, monitor);
                }
                catch (InvalidNameException e) {
                    Msg.showError((Object)((Object)this), null, (String)"Invalid Domain Object Name", (Object)"Please report this error; the name should have been checked already");
                }
            }
            final VTSessionDB finalSession = session;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateNewSessionTask.this.controller.openVersionTrackingSession(finalSession);
                    CreateNewSessionTask.this.releaseDomainObject(finalSession);
                }
            });
        }
        catch (CancelledException e) {
            this.releaseDomainObject(session);
        }
        catch (IOException e) {
            this.releaseDomainObject(session);
            Msg.showError((Object)((Object)this), null, (String)"Failed to Create Session", (Object)("Failed to create db file: " + name), (Throwable)e);
        }
    }

    private void releaseDomainObject(VTSession session) {
        if (session == null) {
            return;
        }
        ((VTSessionDB)session).release((Object)this);
    }
}

