/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.exception.AssertException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.Test;
import junit.framework.TestSuite;
import utilities.util.FileUtilities;

public class TestSuiteUtilities {
    private static final char JAR_FILE_SEPARATOR = '/';
    private static Class<?> TEST_CASE_CLASS = TestSuiteUtilities.createTestClass();
    private static final String ALL_TESTS_CODE = "package %PACKAGE%;\nimport ghidra.util.TestUtilities;\nimport junit.framework.Test;\n\n/**\n * Generic test suite for single package.\n */\npublic class %CLASSNAME% {\n\tpublic static Test suite() {\n\t\t%CLASSNAME% testAll = new %CLASSNAME%();\n\t\treturn TestUtilities.getPkgTestSuite(testAll.getClass().getPackage().getName());\n\t}\n}\n";

    private static Class<?> createTestClass() {
        try {
            return Class.forName("junit.framework.TestCase");
        }
        catch (ClassNotFoundException e) {
            throw new AssertException();
        }
    }

    public static TestSuite getTestSuite(String pkgName) {
        return TestSuiteUtilities.getTestSuite(pkgName, true);
    }

    public static TestSuite getPkgTestSuite(String pkgName) {
        return TestSuiteUtilities.getTestSuite(pkgName, false);
    }

    private static TestSuite getTestSuite(String pkgName, boolean recurse) {
        TestSuite suite = new TestSuite();
        suite.setName("[Package] " + pkgName);
        Iterator<String> iter = TestSuiteUtilities.getClassNames(pkgName, TEST_CASE_CLASS);
        while (iter.hasNext()) {
            String name = iter.next();
            try {
                suite.addTest((Test)new TestSuite(Class.forName(name)));
            }
            catch (ClassNotFoundException e) {
                System.out.println("Failed to load test case: " + name);
            }
        }
        if (recurse) {
            iter = TestSuiteUtilities.getSubPkgNames(pkgName);
            while (iter.hasNext()) {
                String subPkgName = iter.next();
                TestSuite ts = TestSuiteUtilities.getTestSuite(subPkgName, true);
                if (ts.countTestCases() <= 0) continue;
                suite.addTest((Test)ts);
            }
        }
        return suite;
    }

    private static boolean hasTests(String pkgName, boolean recurse) {
        Iterator<String> iter = TestSuiteUtilities.getClassNames(pkgName, TEST_CASE_CLASS);
        if (iter.hasNext()) {
            return true;
        }
        if (recurse) {
            iter = TestSuiteUtilities.getSubPkgNames(pkgName);
            while (iter.hasNext()) {
                String subPkgName = iter.next();
                if (!TestSuiteUtilities.hasTests(subPkgName, true)) continue;
                return true;
            }
        }
        return false;
    }

    public static Iterator<String> getClassNames(String pkgName, Class<?> searchClass) {
        HashSet<String> classNames = new HashSet<String>();
        String classPath = System.getProperty("java.class.path");
        if (classPath == null || classPath.trim().length() == 0) {
            classPath = System.getProperty("user.dir");
        }
        String javaHome = System.getProperty("java.home");
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreElements()) {
            String path = (String)st.nextElement();
            if (path.startsWith(javaHome)) continue;
            if (path.endsWith(".jar") || path.endsWith(".zip")) {
                TestSuiteUtilities.findClassesInJar(path, pkgName, searchClass, classNames);
                continue;
            }
            File f = new File(path);
            if (!f.isDirectory()) continue;
            TestSuiteUtilities.findClassesInPath(path, pkgName, searchClass, classNames);
        }
        return classNames.iterator();
    }

    private static void findClassesInPath(String classPath, String pkgName, Class<?> searchClass, HashSet<String> classNames) {
        String pkgPath;
        File dir;
        String[] names;
        File cfile = new File((String)classPath);
        String absolutePath = cfile.getAbsolutePath();
        if (!((String)classPath).equals(absolutePath)) {
            classPath = absolutePath;
        }
        if (!((String)classPath).endsWith(File.separator)) {
            classPath = (String)classPath + File.separator;
        }
        if ((names = (dir = new File((String)(classPath = (String)classPath + (pkgPath = pkgName.replace('.', File.separatorChar))))).list()) == null) {
            return;
        }
        for (String name : names) {
            String className;
            File f = new File(dir, name);
            String filename = f.getAbsolutePath();
            if (f.isDirectory() || !filename.endsWith(".class") || classNames.contains(className = TestSuiteUtilities.createClassName(filename, pkgName, File.separatorChar))) continue;
            try {
                Class<?> c = Class.forName(className);
                if (!TestSuiteUtilities.isClassOfInterest(c, searchClass)) continue;
                classNames.add(className);
            }
            catch (Throwable t) {
                if (t instanceof LinkageError) continue;
                System.out.println("Error loading class " + filename + ", " + t);
            }
        }
    }

    private static void findClassesInJar(String jarFilename, String pkgName, Class<?> searchClass, HashSet<String> classNames) {
        try (JarFile jarFile = new JarFile(jarFilename);){
            Object pkgPath;
            Object object = pkgPath = pkgName != null ? pkgName.replace('.', '/') : "";
            if (((String)pkgPath).length() > 0) {
                pkgPath = (String)pkgPath + "/";
            }
            int lastSepIx = ((String)pkgPath).length() - 1;
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String className;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class") || lastSepIx != -1 && name.indexOf((String)pkgPath) != 0 || name.lastIndexOf(47) != lastSepIx || classNames.contains(className = TestSuiteUtilities.createClassName(name, pkgName, '/'))) continue;
                try {
                    Class<?> c = Class.forName(className);
                    if (!TestSuiteUtilities.isClassOfInterest(c, searchClass)) continue;
                    classNames.add(className);
                }
                catch (Throwable t) {}
            }
        }
        catch (IOException e) {
            return;
        }
    }

    private static String createClassName(String filename, String pkgName, char fileSep) {
        String name;
        int ix;
        Object pkgPath;
        Object object = pkgPath = pkgName != null ? pkgName.trim() : "";
        if (((String)pkgPath).length() > 0 && !((String)pkgPath).endsWith(".")) {
            pkgPath = (String)pkgPath + ".";
        }
        if ((ix = (name = filename.substring(0, filename.indexOf(".class"))).lastIndexOf(fileSep)) >= 0) {
            name = name.substring(ix + 1);
        }
        return (String)pkgPath + name;
    }

    private static boolean isClassOfInterest(Class<?> c, Class<?> searchClass) {
        boolean isAbstract = Modifier.isAbstract(c.getModifiers());
        return searchClass.isAssignableFrom(c) && !isAbstract;
    }

    public static Iterator<String> getSubPkgNames(String pkgName) {
        HashSet<String> pkgNames = new HashSet<String>();
        String classPath = System.getProperty("java.class.path");
        if (classPath == null || classPath.trim().length() == 0) {
            classPath = System.getProperty("user.dir");
        }
        String javaHome = System.getProperty("java.home");
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreElements()) {
            String path = (String)st.nextElement();
            if (path.startsWith(javaHome)) continue;
            if (path.endsWith(".jar") || path.endsWith(".zip")) {
                TestSuiteUtilities.findPkgsInJar(path, pkgName, pkgNames);
                continue;
            }
            File f = new File(path);
            if (!f.isDirectory()) continue;
            TestSuiteUtilities.findPkgsInPath(path, pkgName, pkgNames);
        }
        return pkgNames.iterator();
    }

    private static void findPkgsInPath(String classPath, String pkgName, HashSet<String> pkgNames) {
        File dir;
        String[] names;
        File cfile = new File((String)classPath);
        String absolutePath = cfile.getAbsolutePath();
        if (!((String)classPath).equals(absolutePath)) {
            classPath = absolutePath;
        }
        if (!((String)classPath).endsWith(File.separator)) {
            classPath = (String)classPath + File.separator;
        }
        String pkgPath = pkgName != null ? pkgName.replace('.', File.separatorChar) : "";
        classPath = (String)classPath + pkgPath;
        Object pkgPrefix = pkgName;
        if (pkgName != null && pkgName.length() > 0) {
            pkgPrefix = (String)pkgPrefix + ".";
        }
        if ((names = (dir = new File((String)classPath)).list()) == null) {
            return;
        }
        for (String name : names) {
            String subPkgName;
            File f = new File(dir, name);
            if (!f.isDirectory() || pkgNames.contains(subPkgName = (String)pkgPrefix + f.getName())) continue;
            pkgNames.add(subPkgName);
        }
    }

    private static void findPkgsInJar(String jarFilename, String pkgName, HashSet<String> pkgNames) {
        try (JarFile jarFile = new JarFile(jarFilename);){
            Object pkgPath;
            Object object = pkgPath = pkgName != null ? pkgName.replace('.', '/') : "";
            if (((String)pkgPath).length() > 0) {
                pkgPath = (String)pkgPath + "/";
            }
            int lastSepIx = ((String)pkgPath).length() - 1;
            Object pkgPrefix = pkgName;
            if (pkgName != null && pkgName.length() > 0) {
                pkgPrefix = (String)pkgPrefix + ".";
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                int ix;
                JarEntry entry = entries.nextElement();
                Object name = entry.getName();
                if (!((String)name).endsWith(".class")) continue;
                if (lastSepIx != -1) {
                    if (((String)name).indexOf((String)pkgPath) != 0) continue;
                    name = ((String)name).substring(lastSepIx + 1);
                }
                if ((ix = ((String)name).indexOf(47)) <= 0 || pkgNames.contains(name = (String)pkgPrefix + ((String)name).substring(0, ix))) continue;
                pkgNames.add((String)name);
            }
        }
        catch (IOException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTestSuites(File baseDir, String className, String pkgName) throws IOException {
        File dir = TestSuiteUtilities.makeDir(baseDir, pkgName);
        String srcCode = ALL_TESTS_CODE.replaceAll("%CLASSNAME%", className);
        srcCode = srcCode.replaceAll("%PACKAGE%", pkgName);
        OutputStreamWriter out = null;
        try {
            out = new FileWriter(new File(dir, className + ".java"));
            out.write(srcCode);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int createTestSuites(File baseDir, String className, String pkgName, boolean recurse) throws IOException {
        int cnt = 0;
        if (TestSuiteUtilities.hasTests(pkgName, false)) {
            TestSuiteUtilities.createTestSuites(baseDir, className, pkgName);
            ++cnt;
        }
        if (recurse) {
            Iterator<String> iter = TestSuiteUtilities.getSubPkgNames(pkgName);
            while (iter.hasNext()) {
                cnt += TestSuiteUtilities.createTestSuites(baseDir, className, iter.next(), true);
            }
        }
        return cnt;
    }

    private static File makeDir(File baseDir, String pkgName) {
        File dir = new File(baseDir, pkgName.replace('.', File.separatorChar));
        FileUtilities.mkdirs((File)dir);
        return dir;
    }

    public static void main(String[] args) {
        try {
            if ("createTestSuites".equals(args[0])) {
                File baseDir = new File(args[1]);
                if (!baseDir.exists() || !baseDir.isDirectory()) {
                    System.err.println("TestUtilities: invalid directory (" + args[1] + ")");
                    throw new RuntimeException();
                }
                String className = args[2];
                if (className.length() == 0 || !className.matches("[A-Z][a-zA-Z0-9]*?")) {
                    System.err.println("TestUtilities: invalid class name (" + args[2] + ")");
                    throw new RuntimeException();
                }
                String pkg = args[3];
                if (pkg.length() == 0 || !pkg.matches("[a-z][a-zA-Z0-9]*(\\.[a-z][a-zA-Z0-9]*)*")) {
                    System.err.println("TestUtilities: invalid package name (" + args[3] + ")");
                    throw new RuntimeException();
                }
                System.out.println("Searching for TestCases and creating TestSuites...");
                System.out.println("  package: " + pkg);
                System.out.println("  destination: " + baseDir);
                int cnt = TestSuiteUtilities.createTestSuites(baseDir, className, pkg, true);
                System.out.println(cnt + " TestSuite(s) Created.");
            }
            System.exit(0);
        }
        catch (Throwable t) {
            System.err.println("TestUtilities: invalid usage");
        }
        System.exit(-1);
    }
}

