/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.FunctionInlineSettingsDefinition;
import ghidra.util.table.field.FunctionNoReturnSettingsDefinition;
import ghidra.util.table.field.FunctionThunkSettingsDefinition;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;
import java.awt.Component;
import javax.swing.JLabel;

public class FunctionSignatureTableColumn
extends ProgramLocationTableColumnExtensionPoint<Function, Function> {
    private static final FunctionInlineSettingsDefinition INLINE = FunctionInlineSettingsDefinition.DEF;
    private static final FunctionThunkSettingsDefinition THUNK = FunctionThunkSettingsDefinition.DEF;
    private static final FunctionNoReturnSettingsDefinition NORETURN = FunctionNoReturnSettingsDefinition.DEF;
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[]{INLINE, THUNK, NORETURN};
    private SignatureRenderer renderer = new SignatureRenderer();

    public String getColumnDisplayName(Settings settings) {
        return this.getColumnName();
    }

    public String getColumnName() {
        return "Function Signature";
    }

    public Function getValue(Function rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        if (rowObject == null) {
            return null;
        }
        return rowObject;
    }

    @Override
    public ProgramLocation getProgramLocation(Function rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        if (rowObject == null) {
            return null;
        }
        return new FunctionNameFieldLocation(program, rowObject.getEntryPoint(), 0, rowObject.getPrototypeString(false, false), rowObject.getName());
    }

    public SettingsDefinition[] getSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    public GColumnRenderer<Function> getColumnRenderer() {
        return this.renderer;
    }

    public int getColumnPreferredWidth() {
        return 200;
    }

    private class SignatureRenderer
    extends AbstractGhidraColumnRenderer<Function> {
        private SignatureRenderer() {
        }

        private void inline(Function function, Settings settings, StringBuilder buffy) {
            if (!function.isInline()) {
                return;
            }
            boolean showInline = INLINE.getValue(settings);
            if (!showInline) {
                return;
            }
            buffy.append("inline ");
        }

        private void noreturn(Function function, Settings settings, StringBuilder buffy) {
            if (!function.hasNoReturn()) {
                return;
            }
            boolean showNoreturn = NORETURN.getValue(settings);
            if (!showNoreturn) {
                return;
            }
            buffy.append("noreturn ");
        }

        private void thunk(Function function, Settings settings, StringBuilder buffy) {
            if (!function.isThunk()) {
                return;
            }
            boolean showThunk = THUNK.getValue(settings);
            if (!showThunk) {
                return;
            }
            buffy.append("thunk ");
        }

        String getSignature(Function function, Settings settings) {
            if (function == null) {
                return null;
            }
            StringBuilder buffy = new StringBuilder();
            this.inline(function, settings, buffy);
            this.thunk(function, settings, buffy);
            this.noreturn(function, settings, buffy);
            String prototypeString = function.getPrototypeString(false, false);
            buffy.append(prototypeString);
            return buffy.toString();
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            Settings settings = data.getColumnSettings();
            label.setFont(this.getFixedWidthFont());
            Function function = (Function)value;
            label.setText(this.getSignature(function, settings));
            return label;
        }

        public String getFilterString(Function t, Settings settings) {
            return this.getSignature(t, settings);
        }
    }
}

